/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.largeobject;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.postgresforest.Driver;
import org.postgresforest.core.BaseConnection;
import org.postgresforest.fastpath.Fastpath;
import org.postgresforest.fastpath.FastpathArg;
import org.postgresforest.largeobject.LargeObject;
import org.postgresforest.util.GT;
import org.postgresforest.util.PSQLException;
import org.postgresforest.util.PSQLState;

public class LargeObjectManager {
    private Fastpath fp;
    private BaseConnection conn;
    public static final int WRITE = 131072;
    public static final int READ = 262144;
    public static final int READWRITE = 393216;

    private LargeObjectManager() {
    }

    public LargeObjectManager(BaseConnection conn) throws SQLException {
        ResultSet res;
        this.conn = conn;
        this.fp = conn.getFastpathAPI();
        String sql = conn.getMetaData().supportsSchemasInTableDefinitions() ? "SELECT p.proname,p.oid  FROM pg_catalog.pg_proc p, pg_catalog.pg_namespace n  WHERE p.pronamespace=n.oid AND n.nspname='pg_catalog' AND (" : "SELECT proname,oid FROM pg_proc WHERE ";
        sql = sql + " proname = 'lo_open' or proname = 'lo_close' or proname = 'lo_creat' or proname = 'lo_unlink' or proname = 'lo_lseek' or proname = 'lo_tell' or proname = 'loread' or proname = 'lowrite'";
        if (conn.getMetaData().supportsSchemasInTableDefinitions()) {
            sql = sql + ")";
        }
        if ((res = conn.createStatement().executeQuery(sql)) == null) {
            throw new PSQLException(GT.tr("Failed to initialize LargeObject API"), PSQLState.SYSTEM_ERROR);
        }
        this.fp.addFunctions(res);
        res.close();
        if (Driver.logDebug) {
            Driver.debug("Large Object initialised");
        }
    }

    public LargeObject open(int oid) throws SQLException {
        return this.open(oid, 393216);
    }

    public LargeObject open(int oid, int mode) throws SQLException {
        if (this.conn.getAutoCommit()) {
            throw new PSQLException(GT.tr("Large Objects may not be used in auto-commit mode."), PSQLState.NO_ACTIVE_SQL_TRANSACTION);
        }
        return new LargeObject(this.fp, oid, mode);
    }

    public int create() throws SQLException {
        return this.create(393216);
    }

    public int create(int mode) throws SQLException {
        if (this.conn.getAutoCommit()) {
            throw new PSQLException(GT.tr("Large Objects may not be used in auto-commit mode."), PSQLState.NO_ACTIVE_SQL_TRANSACTION);
        }
        FastpathArg[] args = new FastpathArg[]{new FastpathArg(mode)};
        return this.fp.getInteger("lo_creat", args);
    }

    public void delete(int oid) throws SQLException {
        FastpathArg[] args = new FastpathArg[]{new FastpathArg(oid)};
        this.fp.fastpath("lo_unlink", false, args);
    }

    public void unlink(int oid) throws SQLException {
        this.delete(oid);
    }
}

