/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.vm;

import java.io.IOException;
import java.sql.SQLException;
import org.postgresforest.Driver;
import org.postgresforest.util.GT;
import org.postgresforest.util.PSQLException;
import org.postgresforest.vm.ColumnInfo;
import org.postgresforest.vm.LogUtil;
import org.postgresforest.vm.OrderInfo;
import org.postgresforest.vm.Parser;
import org.postgresforest.vm.SelectColumnInfo;
import org.postgresforest.vm.err.ForestSQLState;

public class NoPartitionParser
extends Parser {
    public NoPartitionParser(LogUtil logUtil) {
        super(logUtil);
    }

    public void parse(String sql) throws SQLException {
        this.init();
        this.m_srcSql = sql;
        this.initTokenizer(sql);
        try {
            while (!this.checkToken(-3) && this.m_tokenizer.ttype != -1) {
            }
        }
        catch (IOException e) {
            throw new PSQLException(GT.tr("SQL analysis error."), ForestSQLState.INTERNAL_ERROR, (Throwable)e);
        }
        if (this.m_tokenizer.sval != null) {
            this.m_type = commandSet.getInt(this.m_tokenizer.sval);
        }
        try {
            if (this.m_type == 15) {
                this.parseSelect();
            }
            while (this.m_tokenizer.nextToken() != -1) {
            }
        }
        catch (IOException e1) {
            throw new PSQLException(GT.tr("SQL analysis error."), ForestSQLState.INTERNAL_ERROR, (Throwable)e1);
        }
        if (Driver.logInfo) {
            switch (this.m_type) {
                case 15: {
                    this.m_logUtil.info("Parser Result: Command Type = SELECT");
                    break;
                }
                case 10: {
                    this.m_logUtil.info("Parser Result: Command Type = INSERT");
                    break;
                }
                case 6: {
                    this.m_logUtil.info("Parser Result: Command Type = DELETE");
                    break;
                }
                case 18: {
                    this.m_logUtil.info("Parser Result: Command Type = UPDATE");
                }
            }
            String tableName = "";
            for (int i = 0; i < this.m_tables.size(); ++i) {
                Parser.TableInfo tblInfo = (Parser.TableInfo)this.m_tables.get(i);
                tableName = tableName + tblInfo.getTableName() + ",";
            }
            this.m_logUtil.info("Parser Result: Extraction Table Name = " + tableName);
            String updateColumn = "";
            for (int i = 0; i < this.m_updateCol.size(); ++i) {
                Parser.UpdateColumnInfo colInf = (Parser.UpdateColumnInfo)this.m_updateCol.get(i);
                updateColumn = updateColumn + colInf.getName() + ",";
            }
            this.m_logUtil.info("Parser Result: Extraction Update Column Name = " + updateColumn);
            this.m_logUtil.info("Parser Result: ORDER BY = " + this.m_orderBy);
            this.m_logUtil.info("Parser Result: GROUP BY = " + this.m_groupBy);
            this.m_logUtil.info("Parser Result: FUNCTION = " + this.m_Function);
            this.m_logUtil.info("Parser Result: JOIN = " + this.m_JoinTable);
            this.m_logUtil.info("Parser Result: FOR UPDATE = " + this.m_ForUpdate);
            this.m_logUtil.info("Parser Result: DISTINCT = " + this.m_distinct);
            this.m_logUtil.info("Parser Result: UNION = " + this.m_union);
            this.m_logUtil.info("Parser Result: LIMIT = " + this.m_limit);
            this.m_logUtil.info("Parser Result: LIMIT COUNT = " + this.m_limitCount);
            this.m_logUtil.info("Parser Result: OFFSET = " + this.m_offset);
            String orderName = "";
            for (int i = 0; i < this.m_orderList.size(); ++i) {
                OrderInfo orderInfo = (OrderInfo)this.m_orderList.get(i);
                orderName = orderName + orderInfo.getName() + ",";
            }
            this.m_logUtil.info("Parser Result: ORDER LIST = " + orderName);
            String columnName = "";
            for (int i = 0; i < this.m_groupList.size(); ++i) {
                ColumnInfo columnInfo = (ColumnInfo)this.m_groupList.get(i);
                columnName = columnName + columnInfo.getName() + ",";
            }
            this.m_logUtil.info("Parser Result: GROUP LIST = " + columnName);
            String selectColumnName = "";
            for (int i = 0; i < this.m_selectList.size(); ++i) {
                SelectColumnInfo selectColumnInfo = (SelectColumnInfo)this.m_selectList.get(i);
                selectColumnName = selectColumnName + selectColumnInfo.getName() + ",";
            }
            this.m_logUtil.info("Parser Result: SELECT LIST = " + selectColumnName);
            this.m_logUtil.info("Parser Result: FUNCTION(TOTAL) = " + this.m_execFunction);
        }
    }

    protected void parseSelect() throws IOException, SQLException {
        int token = -1;
        while ((token = this.m_tokenizer.nextToken()) != -1) {
            if (token == -3) {
                int wtype = commandSet.getInt(this.m_tokenizer.sval);
                String tmpSval = this.m_tokenizer.sval;
                switch (wtype) {
                    case 111: {
                        if (!this.checkToken(-3) || (wtype = commandSet.getInt(this.m_tokenizer.sval)) != 18) break;
                        this.m_ForUpdate = true;
                        if (!Driver.logDebug) break;
                        this.m_logUtil.debug("FOR UPDATE is specified\uff01");
                    }
                }
                continue;
            }
            if (token == 45) {
                this.forwardLineComment();
                continue;
            }
            if (token != 47) continue;
            this.forwardComment();
        }
    }
}

