/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.vm.core;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.postgresforest.Driver;
import org.postgresforest.core.Field;
import org.postgresforest.core.PGStream;
import org.postgresforest.core.ParameterList;
import org.postgresforest.core.Query;
import org.postgresforest.core.QueryExecutor;
import org.postgresforest.core.ResultCursor;
import org.postgresforest.core.ResultHandler;
import org.postgresforest.util.GT;
import org.postgresforest.util.PSQLException;
import org.postgresforest.vm.Lock;
import org.postgresforest.vm.LogUtil;
import org.postgresforest.vm.MetaDataReWriter;
import org.postgresforest.vm.NoPartitionParser;
import org.postgresforest.vm.NoPartitionReWriter;
import org.postgresforest.vm.Parser;
import org.postgresforest.vm.QueryInfo;
import org.postgresforest.vm.ReWriter;
import org.postgresforest.vm.StatementSub;
import org.postgresforest.vm.StatementThreadMng;
import org.postgresforest.vm.core.ProtocolConnectionImpl;
import org.postgresforest.vm.core.SimpleParameterList;
import org.postgresforest.vm.core.SimpleQuery;
import org.postgresforest.vm.core.SimpleResultHandler;
import org.postgresforest.vm.err.ForestPSQLException;
import org.postgresforest.vm.err.ForestSQLState;
import org.postgresforest.vm.gsc.GscData;

public class QueryExecutorImpl
implements QueryExecutor {
    protected LogUtil m_logUtil;
    protected GscData m_gsc;
    protected StatementThreadMng m_threadMng;
    protected RollBackInfo m_rollBackInfo = new RollBackInfo();
    protected List m_metaDataAccess = Collections.synchronizedList(new ArrayList());
    protected boolean m_updateSyncMode;
    protected boolean m_updateSyncModeManual = false;
    protected boolean m_autocommit = false;
    protected ProtocolConnectionImpl m_protocolConnectionImpl;

    public QueryExecutorImpl(GscData gsc, StatementThreadMng mng, ProtocolConnectionImpl protocolConnectionImpl) {
        this.m_gsc = gsc;
        this.m_logUtil = this.m_gsc.getLogUtil();
        this.m_threadMng = mng;
        this.m_protocolConnectionImpl = protocolConnectionImpl;
    }

    public ParameterList createFastpathParameters(int count) {
        return null;
    }

    public Query createParameterizedQuery(String sql) {
        return this.createSimpleQuery(sql);
    }

    public Query createSimpleQuery(String sql) {
        Parser parser = new Parser(this.m_logUtil);
        if (!this.m_gsc.hasPartition() && this.m_gsc.canPartitionMode()) {
            if (Driver.logInfo) {
                this.m_logUtil.info("NoPartitionParser was selected.");
            }
            parser = new NoPartitionParser(this.m_logUtil);
        } else {
            if (Driver.logInfo) {
                this.m_logUtil.info("Parser was selected.");
            }
            parser = new Parser(this.m_logUtil);
        }
        SimpleQuery query = new SimpleQuery(parser);
        try {
            parser.parse(sql);
            if (Driver.logInfo) {
                this.m_logUtil.info("Parser was completed. (" + sql + ")");
            }
        }
        catch (SQLException e) {
            query.setParserErr(e);
        }
        return query;
    }

    /*
     * Loose catch block
     */
    public synchronized void execute(Query query, ParameterList parameters, ResultHandler handler, int maxRows, int fetchSize, int flags) throws SQLException {
        block56: {
            StatementSub statementSub;
            ReWriter rw;
            SimpleQuery simpleQuery = (SimpleQuery)query;
            SimpleParameterList parameters_wk = null;
            if (parameters != null) {
                parameters_wk = (SimpleParameterList)parameters.copy();
            }
            if (this.getAutocommit() && !this.m_gsc.isTableAvailable()) {
                this.m_gsc.waitTableAvailable();
            } else if (!this.getAutocommit() && !this.m_gsc.isTableAvailable() && this.m_protocolConnectionImpl.getTransactionState() == 0) {
                this.m_gsc.waitTableAvailable();
            }
            Parser parser = simpleQuery.getParser();
            parser.setParamList(parameters_wk);
            if (this.isMetaDataAccess()) {
                if (Driver.logInfo) {
                    this.m_logUtil.info("MetaDataReWriter was selected.");
                }
                rw = new MetaDataReWriter(this.m_gsc);
            } else if (parser instanceof NoPartitionParser) {
                if (Driver.logInfo) {
                    this.m_logUtil.info("NoPartitionReWriter was selected.");
                }
                rw = new NoPartitionReWriter(this.m_gsc);
            } else {
                if (Driver.logInfo) {
                    this.m_logUtil.info("ReWriter was selected.");
                }
                rw = new ReWriter(this.m_gsc);
            }
            try {
                rw.rewrite(parser);
                if (Driver.logInfo) {
                    this.m_logUtil.info("ReWriter was completed. (" + parser.getSrcSql() + ")");
                }
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e1) {
                throw new PSQLException(GT.tr("SQL analysis error."), ForestSQLState.INTERNAL_ERROR, (Throwable)e1);
            }
            ArrayList queryinfoList = rw.getQueryInfo();
            int threadCnt = queryinfoList.size();
            int queryType = rw.getQueryType();
            simpleQuery.setQueryNum(threadCnt);
            simpleQuery.setQueryType(queryType);
            boolean flg = true;
            StatementSub[] th = new StatementSub[threadCnt];
            Lock lock = new Lock(threadCnt);
            for (int i = 0; i < threadCnt; ++i) {
                QueryInfo qi = (QueryInfo)queryinfoList.get(i);
                statementSub = this.m_threadMng.getStatementSub();
                statementSub.execute(simpleQuery, parameters_wk, maxRows, fetchSize, flags, this, qi, rw, lock);
                th[i] = statementSub;
            }
            Field[] fields = null;
            Vector tuples = new Vector();
            try {
                block55: {
                    switch (queryType) {
                        case 0: {
                            SimpleResultHandler resHandler;
                            try {
                                lock.waitAllEnd();
                            }
                            catch (InterruptedException e1) {
                                // empty catch block
                            }
                            for (int i = 0; i < threadCnt; ++i) {
                                statementSub = th[i];
                                if (statementSub.getErrCode() != 0) {
                                    throw statementSub.getErrObj();
                                }
                                resHandler = statementSub.getResultHandler();
                                if (i == 0) {
                                    fields = resHandler.getFields();
                                }
                                tuples.addAll(resHandler.getTuples());
                            }
                            handler.handleResultRows(query, fields, tuples, null);
                            break;
                        }
                        case 1: {
                            try {
                                lock.waitEnd();
                            }
                            catch (InterruptedException e1) {
                                // empty catch block
                            }
                            statementSub = th[0];
                            if (statementSub.getErrCode() != 0) {
                                throw statementSub.getErrObj();
                            }
                            SimpleResultHandler resHandler = statementSub.getResultHandler();
                            handler.handleResultRows(resHandler.getFromQuery(), resHandler.getFields(), resHandler.getTuples(), resHandler.getCursor());
                            break;
                        }
                        case 2: {
                            SimpleResultHandler resHandler;
                            flg = true;
                            while (flg) {
                                int i;
                                if (this.isUpdateSyncMode()) {
                                    try {
                                        lock.waitAllEnd();
                                    }
                                    catch (InterruptedException e1) {
                                        // empty catch block
                                    }
                                    for (int i2 = 0; i2 < threadCnt; ++i2) {
                                        statementSub = th[i2];
                                        if (statementSub.getErrCode() != 0) {
                                            throw statementSub.getErrObj();
                                        }
                                        resHandler = statementSub.getResultHandler();
                                        if (resHandler.getStatus() != null && flg) {
                                            handler.handleCommandStatus(resHandler.getStatus(), resHandler.getUpdateCount(), resHandler.getInsertOID());
                                        } else if (flg || !parser.isForUpdate()) {
                                            handler.handleResultRows(resHandler.getFromQuery(), resHandler.getFields(), resHandler.getTuples(), resHandler.getCursor());
                                        }
                                        flg = false;
                                    }
                                    continue;
                                }
                                try {
                                    lock.waitEnd();
                                }
                                catch (InterruptedException e1) {
                                    // empty catch block
                                }
                                boolean allErr = true;
                                for (i = 0; i < threadCnt; ++i) {
                                    statementSub = th[i];
                                    if (!statementSub.isExecuted()) {
                                        allErr = false;
                                        continue;
                                    }
                                    if (statementSub.getErrCode() != 0) continue;
                                    resHandler = statementSub.getResultHandler();
                                    if (resHandler.getStatus() != null) {
                                        handler.handleCommandStatus(resHandler.getStatus(), resHandler.getUpdateCount(), resHandler.getInsertOID());
                                    } else {
                                        handler.handleResultRows(resHandler.getFromQuery(), resHandler.getFields(), resHandler.getTuples(), resHandler.getCursor());
                                    }
                                    flg = false;
                                    break;
                                }
                                if (flg && allErr) {
                                    ForestPSQLException err = new ForestPSQLException(GT.tr("It is processing failure at all servers, Each error should call getNextException()."), ForestSQLState.INTERNAL_ERROR);
                                    for (int i3 = 0; i3 < threadCnt; ++i3) {
                                        err.setNextException(th[i3].getErrObj(), th[i3].getURL(), th[i3].getSql());
                                    }
                                    throw err;
                                }
                                if (flg) continue;
                                for (i = 0; i < threadCnt; ++i) {
                                    th[i].setServerBrokenChk(true);
                                }
                                break block55;
                            }
                            break;
                        }
                    }
                }
                Object var25_34 = null;
            }
            catch (Throwable throwable) {
                Object var25_35 = null;
                for (int i = 0; i < threadCnt; ++i) {
                    this.m_threadMng.closeStatementSub(th[i]);
                }
                throw throwable;
            }
            for (int i = 0; i < threadCnt; ++i) {
                this.m_threadMng.closeStatementSub(th[i]);
            }
            {
                break block56;
                catch (Exception e) {
                    if (e instanceof SQLException) {
                        throw (SQLException)e;
                    }
                    throw new PSQLException(GT.tr("excute internal error.\n{0}", e), ForestSQLState.INTERNAL_ERROR, (Throwable)e);
                }
            }
        }
        if (!this.getAutocommit() && this.m_protocolConnectionImpl.getTransactionState() == 0) {
            this.m_protocolConnectionImpl.setTransactionState(1);
        }
    }

    public synchronized void execute(Query[] queries, ParameterList[] parameterLists, ResultHandler handler, int maxRows, int fetchSize, int flags) throws SQLException {
    }

    public synchronized byte[] fastpathCall(int fnid, ParameterList params, boolean suppressBegin) throws SQLException {
        return null;
    }

    public synchronized void fetch(ResultCursor cursor, ResultHandler handler, int fetchSize) throws SQLException {
    }

    public LogUtil getLogUtil() {
        return this.m_logUtil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRollback() {
        RollBackInfo rollBackInfo = this.m_rollBackInfo;
        synchronized (rollBackInfo) {
            return this.m_rollBackInfo.isRollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRollback(SQLException ex) {
        if (ex != null) {
            RollBackInfo rollBackInfo = this.m_rollBackInfo;
            synchronized (rollBackInfo) {
                this.m_rollBackInfo.setRollback(true);
                this.m_rollBackInfo.setRollbackException(new PSQLException(GT.tr("The error of the rollback object occurred."), ForestSQLState.INTERNAL_ERROR, (Throwable)ex));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRollback() {
        RollBackInfo rollBackInfo = this.m_rollBackInfo;
        synchronized (rollBackInfo) {
            this.m_rollBackInfo.setRollback(false);
        }
    }

    public SQLException getRollbackException() {
        return this.m_rollBackInfo.getRollbackException();
    }

    public void waitFree() {
        this.m_threadMng.waitFree();
    }

    public GscData getGsc() {
        return this.m_gsc;
    }

    public boolean addMetaDataAccess() {
        return this.m_metaDataAccess.add(Thread.currentThread());
    }

    public boolean isMetaDataAccess() {
        return this.m_metaDataAccess.contains(Thread.currentThread());
    }

    public boolean removeMetaDataAccess() {
        return this.m_metaDataAccess.remove(Thread.currentThread());
    }

    public boolean isUpdateSyncMode() {
        if (this.m_updateSyncModeManual) {
            return this.m_updateSyncMode;
        }
        return this.m_gsc.getUpdateSyncMode();
    }

    public void setUpdateSyncMode(boolean updateSyncMode) {
        this.m_updateSyncMode = updateSyncMode;
        this.m_updateSyncModeManual = true;
    }

    public boolean getAutocommit() {
        return this.m_autocommit;
    }

    public void setAutocommit(boolean autocommit) {
        this.m_autocommit = autocommit;
    }

    public void setTransactionState(int transactionState) {
        this.m_protocolConnectionImpl.setTransactionState(transactionState);
    }

    public PGStream getPGStream() {
        return null;
    }

    class RollBackInfo {
        private boolean m_rollback = false;
        private SQLException m_rollbackException;

        RollBackInfo() {
        }

        protected void setRollback(boolean rollback) {
            this.m_rollback = rollback;
        }

        protected boolean isRollback() {
            return this.m_rollback;
        }

        protected void setRollbackException(SQLException rollbackException) {
            this.m_rollbackException = rollbackException;
        }

        protected SQLException getRollbackException() {
            return this.m_rollbackException;
        }
    }
}

