/*
 * Decompiled with CFR 0.152.
 */
package com.jcoverage.coverage.asm;

import com.jcoverage.coverage.InstrumentData;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public class AsmMethodInstrumenter
extends MethodAdapter
implements Opcodes {
    private String className;
    private String methodName;
    private String desc;
    private InstrumentData instrumentData;
    private int currentLineNumber = 0;
    private Map labelMap = new HashMap();

    public AsmMethodInstrumenter(MethodVisitor mv, String className, String name, String desc, InstrumentData instrumentData) {
        super(mv);
        this.instrumentData = instrumentData;
        this.className = className;
        this.methodName = name;
        this.desc = desc;
    }

    public void visitJumpInsn(int opcode, Label label) {
        super.visitJumpInsn(opcode, label);
        if (opcode == 167 || opcode == 168 || opcode == 169) {
            return;
        }
        this.labelMap.put(label, new Integer(this.currentLineNumber));
    }

    public void visitLineNumber(int line, Label start) {
        this.mv.visitMethodInsn(184, "com/jcoverage/coverage/InstrumentationFactory", "getInstance", "()Lcom/jcoverage/coverage/InstrumentationFactory;");
        this.mv.visitLdcInsn((Object)this.className);
        this.mv.visitMethodInsn(182, "com/jcoverage/coverage/InstrumentationFactory", "newInstrumentation", "(Ljava/lang/String;)Lcom/jcoverage/coverage/Instrumentation;");
        this.mv.visitIntInsn(17, line);
        this.mv.visitMethodInsn(185, "com/jcoverage/coverage/Instrumentation", "touch", "(I)V");
        super.visitLineNumber(line, start);
        this.currentLineNumber = line;
        if (this.labelMap.containsKey(start)) {
            Integer n = (Integer)this.labelMap.get(start);
            this.instrumentData.addConditional(this.methodName, this.desc, n, line);
        }
        this.instrumentData.addSourceNumber(this.methodName, this.desc, line);
    }

    public void visitTableSwitchInsn(int min, int max, Label defaultLabel, Label[] labels) {
        super.visitTableSwitchInsn(min, max, defaultLabel, labels);
        this.instrumentData.addConditional(this.methodName, this.desc, -1, this.currentLineNumber);
        this.labelMap.put(defaultLabel, new Integer(this.currentLineNumber));
        int i = 0;
        while (i < labels.length) {
            this.labelMap.put(labels[i], new Integer(-1));
            ++i;
        }
    }
}

