/*
 * Decompiled with CFR 0.152.
 */
package jp.co.dgic.djunit.ant;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import jp.co.dgic.djunit.ant.DJUnitBaseTest;
import jp.co.dgic.djunit.ant.DJUnitFormatterElement;
import jp.co.dgic.djunit.ant.DJUnitTest;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.junit.Enumerations;
import org.apache.tools.ant.types.FileSet;

public final class DJUnitBatchTest
extends DJUnitBaseTest {
    private Project project;
    private Vector filesets = new Vector();

    public DJUnitBatchTest(Project project) {
        this.project = project;
    }

    public void addFileSet(FileSet fs) {
        this.filesets.addElement(fs);
    }

    public final Enumeration elements() {
        Object[] tests = this.createAllDJUnitTest();
        return Enumerations.fromArray((Object[])tests);
    }

    final void addTestsTo(Vector v) {
        DJUnitTest[] tests = this.createAllDJUnitTest();
        v.ensureCapacity(v.size() + tests.length);
        int i = 0;
        while (i < tests.length) {
            v.addElement(tests[i]);
            ++i;
        }
    }

    private DJUnitTest[] createAllDJUnitTest() {
        String[] filenames = this.getFilenames();
        DJUnitTest[] tests = new DJUnitTest[filenames.length];
        int i = 0;
        while (i < tests.length) {
            String classname = DJUnitBatchTest.javaToClass(filenames[i]);
            tests[i] = this.createJUnitTest(classname);
            ++i;
        }
        return tests;
    }

    private String[] getFilenames() {
        Vector<String> v = new Vector<String>();
        int size = this.filesets.size();
        int j = 0;
        while (j < size) {
            FileSet fs = (FileSet)this.filesets.elementAt(j);
            DirectoryScanner ds = fs.getDirectoryScanner(this.project);
            ds.scan();
            String[] f = ds.getIncludedFiles();
            int k = 0;
            while (k < f.length) {
                String pathname = f[k];
                if (pathname.endsWith(".java")) {
                    v.addElement(pathname.substring(0, pathname.length() - ".java".length()));
                } else if (pathname.endsWith(".class")) {
                    v.addElement(pathname.substring(0, pathname.length() - ".class".length()));
                }
                ++k;
            }
            ++j;
        }
        Object[] files = new String[v.size()];
        v.copyInto(files);
        return files;
    }

    public static final String javaToClass(String filename) {
        return filename.replace(File.separatorChar, '.');
    }

    private DJUnitTest createJUnitTest(String classname) {
        DJUnitTest test = new DJUnitTest();
        test.setName(classname);
        test.setHaltonerror(this.haltOnError);
        test.setHaltonfailure(this.haltOnFail);
        test.setFiltertrace(this.filtertrace);
        test.setFork(this.fork);
        test.setIf(this.ifProperty);
        test.setUnless(this.unlessProperty);
        test.setTodir(this.destDir);
        test.setFailureProperty(this.failureProperty);
        test.setErrorProperty(this.errorProperty);
        Enumeration list = this.formatters.elements();
        while (list.hasMoreElements()) {
            test.addFormatter((DJUnitFormatterElement)list.nextElement());
        }
        return test;
    }
}

