/*
 * Decompiled with CFR 0.152.
 */
package jp.co.dgic.djunit.ant;

import java.io.File;
import java.util.StringTokenizer;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.util.FileUtils;

public class DJUnitJvmArgs {
    public static final String DJUNIT_CLASS_LOADER = "jp.co.dgic.testing.common.DJUnitClassLoader";
    private static final String JUNIT_EXCLUDES_PATHS_KEY = "jp.co.dgic.eclipse.junit.excluded.paths";
    private static final String VIRTUALMOCK_USE_VIRTUALMOCK_KEY = "jp.co.dgic.eclipse.virtualmock.usevirtualmock";
    private static final String COVERAGE_USE_COVERAGE_KEY = "jp.co.dgic.eclipse.coverage.usecoverage";
    private static final String PROJECTS_SOURCE_DIR_KEY = "jp.co.dgic.eclipse.project.source.dir";
    private static final String VIRTUALMOCK_IGNORE_LIBRARY_KEY = "jp.co.dgic.eclipse.virtualmock.ignore.library";
    private static final String VIRTUALMOCK_NOTIGNORE_PATTERNS_KEY = "jp.co.dgic.eclipse.virtualmock.notignore.patterns";
    private static final String BYTECODE_LIBRARY_KEY = "jp.co.dgic.eclipse.classloader.bytecodelibrary";
    private static final String BYTECODE_LIBRARY_ASM = "ASM";
    private static final String BYTECODE_LIBRARY_BCEL = "BCEL";
    private static final String JUNIT_DEFAULT_EXCLUDED_PATHS = "";
    private boolean useCoverage = true;
    private boolean useVirtualMock = false;
    private String excludesPaths;
    private String targetSrcDir;
    private boolean isIgnireLibrary = false;
    private String notIgnorePatterns;
    private boolean useNoverify = false;
    private boolean useBcel = false;
    private File baseDir;

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    public void setUseCoverage(boolean useCoverage) {
        this.useCoverage = useCoverage;
    }

    public void setUseVirtualMock(boolean useVirtualMock) {
        this.useVirtualMock = useVirtualMock;
    }

    public void addExcludesPaths(String excludesPaths) {
        this.excludesPaths = excludesPaths;
    }

    public void setTargetSrcDir(String targetSrcDir) {
        this.targetSrcDir = this.toAbsolutecDir(targetSrcDir);
    }

    public void setIgnoreLibrary(boolean isIgnoreLibrary) {
        this.isIgnireLibrary = isIgnoreLibrary;
    }

    public void setNotIgnorePatterns(String notIgnorePatterns) {
        this.notIgnorePatterns = notIgnorePatterns;
    }

    public void setUseNoverify(boolean useNoverify) {
        this.useNoverify = useNoverify;
    }

    public void setUseBcel(boolean useBcel) {
        this.useBcel = useBcel;
    }

    public void addJvmArgsTo(CommandlineJava command) {
        command.createVmArgument().setValue("-Djp.co.dgic.eclipse.coverage.usecoverage=" + this.useCoverage);
        command.createVmArgument().setValue("-Djp.co.dgic.eclipse.virtualmock.usevirtualmock=" + this.useVirtualMock);
        command.createVmArgument().setValue("-Djp.co.dgic.eclipse.project.source.dir=" + (this.targetSrcDir == null ? JUNIT_DEFAULT_EXCLUDED_PATHS : this.targetSrcDir));
        command.createVmArgument().setValue("-Djp.co.dgic.eclipse.junit.excluded.paths=" + (this.excludesPaths == null ? JUNIT_DEFAULT_EXCLUDED_PATHS : ";" + this.excludesPaths));
        command.createVmArgument().setValue("-Djp.co.dgic.eclipse.virtualmock.ignore.library=" + this.isIgnireLibrary);
        command.createVmArgument().setValue("-Djp.co.dgic.eclipse.virtualmock.notignore.patterns=" + (this.notIgnorePatterns == null ? JUNIT_DEFAULT_EXCLUDED_PATHS : this.notIgnorePatterns));
        command.createVmArgument().setValue("-Djp.co.dgic.eclipse.classloader.bytecodelibrary=" + (this.useBcel ? BYTECODE_LIBRARY_BCEL : BYTECODE_LIBRARY_ASM));
        command.createVmArgument().setValue("-Djava.system.class.loader=jp.co.dgic.testing.common.DJUnitClassLoader");
        if (this.useNoverify) {
            command.createVmArgument().setValue("-noverify");
        }
    }

    private String toAbsolutecDir(String targetSrcDir) {
        String[] dirs = this.splitValue(targetSrcDir);
        if (dirs == null) {
            return targetSrcDir;
        }
        FileUtils fileUtils = FileUtils.newFileUtils();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < dirs.length) {
            File dir = fileUtils.resolveFile(this.baseDir, dirs[i]);
            sb.append(dir.getAbsolutePath());
            sb.append(";");
            ++i;
        }
        return sb.toString();
    }

    private String[] splitValue(String value) {
        if (value == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(value, ";");
        String[] values = new String[st.countTokens()];
        int index = 0;
        while (index < values.length) {
            values[index] = st.nextToken();
            ++index;
        }
        return values;
    }
}

