/*
 * Decompiled with CFR 0.152.
 */
package jp.co.dgic.eclipse.jdt.internal.coverage.report;

import java.util.ArrayList;
import java.util.List;
import jp.co.dgic.eclipse.jdt.internal.coverage.report.ClickableFieldLabel;
import jp.co.dgic.eclipse.jdt.internal.coverage.report.ColumnNameLabel;
import jp.co.dgic.eclipse.jdt.internal.coverage.report.FieldLabel;
import jp.co.dgic.eclipse.jdt.internal.coverage.report.ICoverageLabel;
import jp.co.dgic.eclipse.jdt.internal.coverage.report.IndicatorLabel;
import jp.co.dgic.eclipse.jdt.internal.coverage.ui.CoverageReportView;
import jp.co.dgic.testing.common.coverage.CoverageEntry;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public abstract class CoverageCanvas
extends Canvas {
    protected CoverageReportView coverageView;
    protected String kindName;
    protected static final int LINE_HEIGHT = 18;
    private int textMaxLength;
    private int rowNumber;
    private List nameFields;

    public CoverageCanvas(CoverageReportView coverageView, String kindName) {
        super((Composite)coverageView.getReportCanvas(), 0);
        this.coverageView = coverageView;
        this.kindName = kindName;
    }

    public void init() {
        this.nameFields = new ArrayList();
        GridLayout gl = new GridLayout(7, false);
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.setLayout((Layout)gl);
        this.addHeader();
        this.buildContents();
        this.adjustWidth();
    }

    protected abstract void buildContents();

    protected void addHeader() {
        ColumnNameLabel[] headerLabels = new ColumnNameLabel[7];
        int column = 0;
        while (column < 7) {
            headerLabels[column] = column == 6 ? new ColumnNameLabel((Composite)this, true) : new ColumnNameLabel((Composite)this);
            headerLabels[column].setText(this.getHeaderTitles()[column]);
            headerLabels[column].setSize(this.getFieldWidths()[column], 18);
            ++column;
        }
        this.saveTextMaxLength(this.getHeaderTitles()[0]);
        this.nameFields.add(headerLabels[0]);
    }

    protected void addRow(CoverageEntry entry) {
        ICoverageLabel[] rowLabels = new ICoverageLabel[]{new ClickableFieldLabel((Composite)this, 16384), new FieldLabel((Composite)this, 131072), new FieldLabel((Composite)this, 131072), new FieldLabel((Composite)this, 131072), new IndicatorLabel((Composite)this, entry.getLineCoverage()), new FieldLabel((Composite)this, 131072), new IndicatorLabel((Composite)this, entry.getBranchCoverage())};
        this.saveTextMaxLength(entry.getName());
        rowLabels[0].setText(entry.getName());
        rowLabels[1].setText("" + entry.getFiles());
        rowLabels[2].setText("" + entry.getLines());
        rowLabels[3].setText(String.valueOf(entry.getLineCoverageRate()) + "%");
        rowLabels[5].setText(String.valueOf(entry.getBranchCoverageRate()) + "%");
        int column = 0;
        while (column < 7) {
            rowLabels[column].setSize(this.getFieldWidths()[column], 18);
            rowLabels[column].setLineNumber(this.rowNumber);
            ++column;
        }
        ++this.rowNumber;
        ((ClickableFieldLabel)rowLabels[0]).addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ICoverageLabel label = (ICoverageLabel)e.getSource();
                CoverageCanvas.this.mouseClick(label);
            }
        });
        this.nameFields.add(rowLabels[0]);
    }

    protected abstract int[] getFieldWidths();

    protected abstract void mouseClick(ICoverageLabel var1);

    protected String[] getHeaderTitles() {
        return new String[]{this.kindName, "files", "lines", "%line", "indicator", "%branch", "indicator"};
    }

    private void saveTextMaxLength(String text) {
        if (text == null) {
            return;
        }
        if (this.textMaxLength < text.length()) {
            this.textMaxLength = text.length();
        }
    }

    private void adjustWidth() {
        if (this.nameFields.size() == 0) {
            return;
        }
        int fontWidth = this.getAverageFontWidth();
        int width = fontWidth * this.textMaxLength;
        ICoverageLabel aLabel = null;
        int index = 0;
        while (index < this.nameFields.size()) {
            aLabel = (ICoverageLabel)this.nameFields.get(index);
            aLabel.setSize(width, 18);
            ++index;
        }
    }

    private int getAverageFontWidth() {
        int lastLabelWidth;
        if (this.nameFields == null || this.nameFields.size() == 0) {
            return 0;
        }
        ICoverageLabel firstLabel = (ICoverageLabel)this.nameFields.get(0);
        ICoverageLabel lastLabel = (ICoverageLabel)this.nameFields.get(this.nameFields.size() - 1);
        int firstLabelWidth = this.getFontWidth(firstLabel);
        return (firstLabelWidth >= (lastLabelWidth = this.getFontWidth(lastLabel)) ? firstLabelWidth : lastLabelWidth) + 1;
    }

    private int getFontWidth(ICoverageLabel label) {
        try {
            GC gc = new GC((Drawable)label);
            return gc.getFontMetrics().getAverageCharWidth();
        }
        catch (Throwable throwable) {
            return 0;
        }
    }
}

