/*
 * Decompiled with CFR 0.152.
 */
package jp.co.dgic.eclipse.jdt.internal.coverage.report;

import jp.co.dgic.eclipse.jdt.internal.coverage.report.ICoverageLabel;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class IndicatorLabel
extends Canvas
implements ICoverageLabel,
PaintListener {
    private static final RGB RGB_GREEN = new RGB(0, 240, 0);
    private static final RGB RGB_RED = new RGB(224, 0, 0);
    private static final RGB RGB_GREEN_SHADOW = new RGB(0, 128, 0);
    private static final RGB RGB_RED_SHADOW = new RGB(128, 0, 0);
    private static final int MARGIN = 1;
    private double coverage;
    private RGB backgroundRGB;

    public IndicatorLabel(Composite parent, double coverage) {
        super(parent, 0);
        this.coverage = coverage;
        GridLayout gl = new GridLayout(2, false);
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        gl.marginHeight = 1;
        gl.marginWidth = 1;
        this.setLayout((Layout)gl);
        this.addPaintListener(this);
    }

    public void setLineNumber(int lineNumber) {
        this.backgroundRGB = lineNumber % 2 == 0 ? RGB_LINE_BACKGROUND : RGB_BACKGROUND;
        this.setBackground(new Color((Device)this.getDisplay(), this.backgroundRGB));
    }

    protected void checkSubclass() {
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return this.getSize();
    }

    public String getText() {
        return "";
    }

    public void setText(String text) {
    }

    public void paintControl(PaintEvent e) {
        this.drawRed(e.gc);
        this.drawGreen(e.gc);
    }

    private void drawRed(GC gc) {
        Rectangle r = this.getBounds();
        gc.setBackground(new Color((Device)this.getDisplay(), RGB_RED));
        gc.fillRectangle(1, 1, r.width - 1, r.height - 2);
        gc.setForeground(new Color((Device)this.getDisplay(), RGB_RED_SHADOW));
        int[] pointArray = new int[]{r.width - 1, 1, r.width - 1, r.height - 1, 2, r.height - 1};
        gc.drawPolyline(pointArray);
    }

    private void drawGreen(GC gc) {
        Rectangle r = this.getBounds();
        int greenWidth = (int)((double)r.width * this.coverage);
        if (greenWidth == 0) {
            return;
        }
        gc.setBackground(new Color((Device)this.getDisplay(), RGB_GREEN));
        gc.fillRectangle(0, 1, greenWidth, r.height - 2);
        gc.setForeground(new Color((Device)this.getDisplay(), RGB_GREEN_SHADOW));
        int[] pointArray = new int[]{greenWidth - 1, 1, greenWidth - 1, r.height - 1, 2, r.height - 1};
        gc.drawPolyline(pointArray);
    }
}

