/*
 * Decompiled with CFR 0.152.
 */
package jp.co.dgic.eclipse.jdt.internal.coverage.report.html;

import com.jcoverage.coverage.Instrumentation;
import com.jcoverage.coverage.reporting.collation.JavaFileLine;
import com.jcoverage.coverage.reporting.collation.JavaFilePage;
import com.jcoverage.coverage.reporting.collation.PackageSummaryPage;
import com.jcoverage.coverage.reporting.collation.ReportImpl;
import com.jcoverage.coverage.reporting.collation.ReportSummaryPackageLine;
import com.jcoverage.coverage.reporting.collation.ReportSummaryPage;
import com.jcoverage.coverage.reporting.collation.StaticFileCollator;
import com.jcoverage.coverage.reporting.html.MultiViewStaticHtmlFormat;
import com.jcoverage.reporting.Collator;
import com.jcoverage.reporting.FileSerializer;
import com.jcoverage.reporting.Format;
import com.jcoverage.reporting.Line;
import com.jcoverage.reporting.LineCategory;
import com.jcoverage.reporting.Page;
import com.jcoverage.reporting.Report;
import com.jcoverage.reporting.Serializer;
import com.jcoverage.util.ClassHelper;
import java.io.File;

public class HtmlReportDriver {
    File[] javaSourceDirectorys;
    Report report = new ReportImpl();
    Page indexPage;

    public HtmlReportDriver(File[] javaSourceDirectory) {
        this.javaSourceDirectorys = javaSourceDirectory;
        this.indexPage = this.report.createFrontPage();
    }

    public synchronized void addInstrumentation(String clzName, Instrumentation instrumentation) {
        String ownerClzName = clzName;
        if (HtmlReportDriver.isInnerClass(clzName)) {
            ownerClzName = HtmlReportDriver.getOwnerClassNameOf(clzName);
        }
        String id = HtmlReportDriver.getSourceFileId(ownerClzName, instrumentation);
        String sourcePath = String.valueOf(id.replace('.', File.separatorChar)) + ".java";
        String packageName = ClassHelper.getPackageName((String)id);
        if (packageName.equals("")) {
            packageName = "default";
        }
        Line packageLine = this.indexPage.lookupLineByField((LineCategory)ReportSummaryPage.CATEGORY_PACKAGE_SUMMARY, ReportSummaryPackageLine.COLUMN_PACKAGE_NAME, (Object)packageName);
        Page packageDetailPage = null;
        if (packageLine == null) {
            packageLine = this.indexPage.createLine((LineCategory)ReportSummaryPage.CATEGORY_PACKAGE_SUMMARY);
            packageLine.setField(ReportSummaryPackageLine.COLUMN_PACKAGE_NAME, (Object)packageName);
            packageDetailPage = packageLine.openDetailPage();
        } else {
            packageDetailPage = packageLine.getDetailPage();
        }
        Line javaFileLine = packageDetailPage.lookupLineByField((LineCategory)PackageSummaryPage.CATEGORY_JAVAFILES, JavaFileLine.COLUMN_FILE_NAME, (Object)clzName);
        Page javaFileDetailPage = null;
        if (javaFileLine == null) {
            javaFileLine = packageDetailPage.createLine((LineCategory)PackageSummaryPage.CATEGORY_JAVAFILES);
            javaFileLine.setField(JavaFileLine.COLUMN_FILE_NAME, (Object)clzName);
            javaFileLine.setField(JavaFileLine.COLUMN_PATH, (Object)HtmlReportDriver.getSourceFile(this.javaSourceDirectorys, sourcePath).getAbsolutePath());
            javaFileDetailPage = javaFileLine.openDetailPage();
        } else {
            javaFileDetailPage = javaFileLine.getDetailPage();
        }
        this.indexPage.addLineReference(javaFileLine, (LineCategory)PackageSummaryPage.CATEGORY_JAVAFILES);
        ((JavaFilePage)javaFileDetailPage).addInstrumentation(instrumentation);
    }

    public void generate(File outputDir) throws Exception {
        StaticFileCollator collator = new StaticFileCollator(".html");
        this.report.setCollator((Collator)collator);
        MultiViewStaticHtmlFormat htmlFormat = new MultiViewStaticHtmlFormat();
        FileSerializer serializer = new FileSerializer(outputDir);
        collator.addOutputter((Format)htmlFormat, (Serializer)serializer);
        this.indexPage.close();
    }

    public static String getSourceFileId(String clzName, Instrumentation instrumentation) {
        if (HtmlReportDriver.isInnerClass(clzName)) {
            throw new IllegalStateException("Cannot call this method (getSourceFileId) for an inner class");
        }
        String pkgname = ClassHelper.getPackageName((String)clzName);
        if (instrumentation.getSourceFileName() == null) {
            return clzName;
        }
        if (pkgname.equals("")) {
            return HtmlReportDriver.stripJavaSuffix(instrumentation.getSourceFileName());
        }
        return String.valueOf(pkgname) + "." + HtmlReportDriver.stripJavaSuffix(instrumentation.getSourceFileName());
    }

    public static String stripJavaSuffix(String s) {
        return s.substring(0, s.length() - ".java".length());
    }

    public static boolean isInnerClass(String clzName) {
        return clzName.indexOf("$") != -1;
    }

    private static File getSourceFile(File[] directories, String sourcePath) {
        if (directories == null || directories.length == 0) {
            return new File(sourcePath);
        }
        int i = 0;
        while (i < directories.length) {
            File f = new File(directories[i], sourcePath);
            if (f.exists()) {
                return f;
            }
            ++i;
        }
        return new File(sourcePath);
    }

    private static String getOwnerClassNameOf(String innerClassName) {
        if (!HtmlReportDriver.isInnerClass(innerClassName)) {
            return innerClassName;
        }
        int index = innerClassName.lastIndexOf(36);
        String ownerClassName = innerClassName.substring(0, index);
        return HtmlReportDriver.getOwnerClassNameOf(ownerClassName);
    }
}

