/*
 * Decompiled with CFR 0.152.
 */
package jp.co.dgic.eclipse.jdt.internal.coverage.ui;

import java.util.HashMap;
import jp.co.dgic.eclipse.jdt.internal.coverage.ui.CoverageMarker;
import jp.co.dgic.eclipse.jdt.internal.junit.ui.DJUnitMessages;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class MarkerCreator
implements IWorkspaceRunnable {
    private IResource resource;
    private Integer lineNumber;
    private int startOffset;
    private int endOffset;

    public MarkerCreator(IResource resource, Integer lineNumber, int startOffset, int endOffset) {
        this.resource = resource;
        this.lineNumber = lineNumber;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        this.createMarkerToLine();
    }

    private void createMarkerToLine() throws CoreException {
        IMarker marker = this.resource.createMarker(CoverageMarker.MARKER_ID);
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("message", DJUnitMessages.getFormattedString("MarkerUtil.message.nohits", this.lineNumber));
        attributes.put("lineNumber", this.lineNumber);
        attributes.put("priority", new Integer(2));
        attributes.put("userEditable", new Boolean(false));
        if (this.startOffset != -1 && this.endOffset != -1) {
            attributes.put("charStart", new Integer(this.startOffset));
            attributes.put("charEnd", new Integer(this.endOffset));
        }
        marker.setAttributes(attributes);
    }
}

