/*
 * Decompiled with CFR 0.152.
 */
package jp.co.dgic.eclipse.jdt.internal.coverage.util;

import com.jcoverage.coverage.Instrumentation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import jp.co.dgic.testing.common.coverage.CoverageEntry;
import jp.co.dgic.testing.common.coverage.CoverageResultFactory;
import jp.co.dgic.testing.common.util.DJUnitUtil;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class CoverageUtil {
    public static final String COVERAGE_INCLUDES_PATTERNS_KEY = "jp.co.dgic.eclipse.coverage.included.patterns";
    public static final String COVERAGE_EXCLUDES_PATTERNS_KEY = "jp.co.dgic.eclipse.coverage.excluded.patterns";
    public static final String COVERAGE_USE_COVERAGE_KEY = "jp.co.dgic.eclipse.coverage.usecoverage";
    private static HashMap coverageEntrys;

    public static void prepareCoverageEntry() {
        coverageEntrys = new HashMap();
        CoverageEntry entry = null;
        Instrumentation i = null;
        Map m = CoverageUtil.getCoverage();
        Iterator it = m.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            i = (Instrumentation)m.get(key);
            entry = new CoverageEntry(key);
            entry.addInstrumentation(i);
            coverageEntrys.put(key, entry);
        }
    }

    public static CoverageEntry getOverallCoverage() {
        if (coverageEntrys == null) {
            CoverageUtil.prepareCoverageEntry();
        }
        CoverageEntry entry = new CoverageEntry("Overall coverage figures");
        Iterator it = coverageEntrys.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            entry.addInstrumentation((CoverageEntry)me.getValue());
        }
        Map packageCoverage = CoverageUtil.getPackageCoverage();
        double sumBranchCoverage = 0.0;
        Iterator it2 = packageCoverage.entrySet().iterator();
        while (it2.hasNext()) {
            sumBranchCoverage += ((CoverageEntry)it2.next().getValue()).getBranchCoverage();
        }
        entry.setBranchCoverage(sumBranchCoverage / (double)packageCoverage.size());
        return entry;
    }

    public static Map getPackageCoverage() {
        if (coverageEntrys == null) {
            CoverageUtil.prepareCoverageEntry();
        }
        TreeMap entries = new TreeMap();
        CoverageEntry entry = null;
        Iterator it = coverageEntrys.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            entry = CoverageUtil.getEntryBy(entries, CoverageUtil.getPackageNameFrom(key));
            entry.addInstrumentation((CoverageEntry)coverageEntrys.get(key));
        }
        return entries;
    }

    public static Map getFileCoverage() {
        if (coverageEntrys == null) {
            CoverageUtil.prepareCoverageEntry();
        }
        TreeMap<String, CoverageEntry> entries = new TreeMap<String, CoverageEntry>();
        CoverageEntry entry = null;
        Iterator it = coverageEntrys.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            entry = new CoverageEntry(key);
            entry.addInstrumentation((CoverageEntry)coverageEntrys.get(key));
            entries.put(key, entry);
        }
        return entries;
    }

    private static CoverageEntry getEntryBy(Map map, String packageName) {
        CoverageEntry entry = (CoverageEntry)map.get(packageName);
        if (entry == null) {
            entry = new CoverageEntry(packageName);
            map.put(packageName, entry);
        }
        return entry;
    }

    private static Map getCoverage() {
        return CoverageResultFactory.getInstance().getInstrumentation();
    }

    private static String getPackageNameFrom(String sourceFileName) {
        if (sourceFileName == null) {
            return null;
        }
        String className = CoverageUtil.getClassNameFrom(sourceFileName);
        int index = className.lastIndexOf(46);
        if (index < 0) {
            return "default";
        }
        return className.substring(0, index);
    }

    private static String getClassNameFrom(String sourceFileName) {
        if (sourceFileName == null) {
            return null;
        }
        if (sourceFileName.endsWith(".java")) {
            return sourceFileName.substring(0, sourceFileName.lastIndexOf(46));
        }
        return sourceFileName;
    }

    public static boolean isExcluded(String className) {
        String[] patterns = CoverageUtil.getExcludedPatterns();
        if (patterns == null) {
            return false;
        }
        Perl5Matcher matcher = new Perl5Matcher();
        Perl5Compiler compiler = new Perl5Compiler();
        int index = 0;
        while (index < patterns.length) {
            try {
                if (matcher.matches(className, compiler.compile(patterns[index]))) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++index;
        }
        return false;
    }

    public static boolean isIncluded(String className) {
        String[] patterns = CoverageUtil.getIncludedPatterns();
        if (patterns == null) {
            return true;
        }
        Perl5Matcher matcher = new Perl5Matcher();
        Perl5Compiler compiler = new Perl5Compiler();
        int index = 0;
        while (index < patterns.length) {
            try {
                if (matcher.matches(className, compiler.compile(patterns[index]))) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++index;
        }
        return false;
    }

    private static String[] getExcludedPatterns() {
        String excludedPatterns = System.getProperty(COVERAGE_EXCLUDES_PATTERNS_KEY);
        if (excludedPatterns == null) {
            return null;
        }
        return DJUnitUtil.splitValue(excludedPatterns);
    }

    private static String[] getIncludedPatterns() {
        String includedPatterns = System.getProperty(COVERAGE_INCLUDES_PATTERNS_KEY);
        if (includedPatterns == null) {
            return null;
        }
        return DJUnitUtil.splitValue(includedPatterns);
    }

    public static boolean isUseCoverage() {
        String useCoverage = System.getProperty(COVERAGE_USE_COVERAGE_KEY);
        if (useCoverage == null) {
            return false;
        }
        return "true".equalsIgnoreCase(useCoverage);
    }
}

