/*
 * Decompiled with CFR 0.152.
 */
package jp.co.dgic.eclipse.jdt.internal.junit.runner;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;

public class MessageSender {
    private Socket clientSocket;
    private PrintWriter writer;
    private String host = "";
    private int port = -1;

    public boolean connect() {
        if (this.port == -1) {
            return false;
        }
        int i = 1;
        while (i < 20) {
            try {
                this.clientSocket = new Socket(this.host, this.port);
                this.writer = new PrintWriter(this.clientSocket.getOutputStream(), false);
                return true;
            }
            catch (IOException iOException) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++i;
            }
        }
        return false;
    }

    public void shutDown() {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
        try {
            if (this.clientSocket != null) {
                this.clientSocket.close();
                this.clientSocket = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void sendMessage(String msg) {
        if (this.writer == null) {
            return;
        }
        this.writer.println(msg);
    }

    public void initialize(String[] args) {
        try {
            int i = 0;
            while (i < args.length) {
                if (args[i].toLowerCase().equals("-host")) {
                    this.host = args[i + 1];
                }
                if (args[i].toLowerCase().equals("-djunitport")) {
                    this.port = Integer.parseInt(args[i + 1]);
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

