/*
 * Decompiled with CFR 0.152.
 */
package jp.co.dgic.eclipse.jdt.internal.junit.ui;

import jp.co.dgic.eclipse.jdt.internal.junit.ui.DJUnitPlugin;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.IDebugEventFilter;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIThread;

public class DJUnitDebugEventFilter
implements IDebugEventFilter {
    private static final String[] DJUNIT_FILTER_PATTERNS = new String[]{"jp.co.dgic.testing.*", "com.jcoverage.*", "junit.*", "org.eclipse.jdt.internal.junit.*", "java.*", "sun.*"};

    public DebugEvent[] filterDebugEvents(DebugEvent[] events) {
        if (!DJUnitPlugin.getDefault().isDJUnitTest()) {
            return events;
        }
        if (events == null || events.length == 0) {
            return events;
        }
        int i = 0;
        while (i < events.length) {
            Object src = events[i].getSource();
            if (src instanceof JDIThread && ((JDIThread)src).getDebugTarget() instanceof JDIDebugTarget) {
                JDIDebugTarget target = (JDIDebugTarget)((JDIThread)src).getDebugTarget();
                target.setStepFiltersEnabled(true);
                target.setStepFilters(this.addDJUnitFilterPatterns(target.getStepFilters()));
            }
            ++i;
        }
        return events;
    }

    private String[] addDJUnitFilterPatterns(String[] patterns) {
        if (patterns == null || patterns.length == 0) {
            return DJUNIT_FILTER_PATTERNS;
        }
        if (this.containDJUnitPatterns(patterns)) {
            return patterns;
        }
        String[] newPatterns = new String[patterns.length + DJUNIT_FILTER_PATTERNS.length];
        System.arraycopy(patterns, 0, newPatterns, 0, patterns.length);
        int i = 0;
        while (i < DJUNIT_FILTER_PATTERNS.length) {
            newPatterns[i + patterns.length] = DJUNIT_FILTER_PATTERNS[i];
            ++i;
        }
        return newPatterns;
    }

    private boolean containDJUnitPatterns(String[] patterns) {
        if (patterns == null || DJUNIT_FILTER_PATTERNS.length == 0) {
            return false;
        }
        int i = 0;
        while (i < DJUNIT_FILTER_PATTERNS.length) {
            boolean isFound = false;
            int ii = 0;
            while (ii < patterns.length) {
                if (DJUNIT_FILTER_PATTERNS[i].equals(patterns[ii])) {
                    isFound = true;
                    break;
                }
                ++ii;
            }
            if (!isFound) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

