/*
 * Decompiled with CFR 0.152.
 */
package jp.co.dgic.testing.common;

import java.lang.reflect.Method;
import java.net.URLClassLoader;
import jp.co.dgic.testing.common.util.DJUnitUtil;

public class DJUnitClassLoader
extends URLClassLoader {
    private static final String ASM_CLASS_MODIFIER_CLASS_NAME = "jp.co.dgic.testing.common.AsmClassModifier";
    private static final String BCEL_CLASS_MODIFIER_CLASS_NAME = "jp.co.dgic.testing.common.BcelClassModifier";
    private static final String CLASS_MODIFIER_MTHOD_NAME = "getModifiedClass";
    protected Object classModifier;
    static /* synthetic */ Class class$0;

    public DJUnitClassLoader(ClassLoader parent) {
        super(((URLClassLoader)parent).getURLs(), parent.getParent());
        this.createClassModifier();
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return super.loadClass(name, resolve);
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        if (this.classModifier == null || !DJUnitUtil.isProjectsSource(name)) {
            return super.findClass(name);
        }
        byte[] data = null;
        try {
            data = this.getModifiedClass(name);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error("djUnit class load error (Class : " + name + ")");
        }
        if (data == null) {
            return super.findClass(name);
        }
        return this.defineClass(name, data);
    }

    protected Class defineClass(String name, byte[] data) {
        Package p;
        int index = name.lastIndexOf(46);
        String packageName = name;
        if (index != -1) {
            packageName = name.substring(0, index);
        }
        if ((p = this.getPackage(packageName)) == null) {
            this.definePackage(packageName, null, null, null, null, null, null, null);
        }
        return this.defineClass(name, data, 0, data.length);
    }

    public void createClassModifier() {
        String library = System.getProperty("jp.co.dgic.eclipse.classloader.bytecodelibrary");
        String modifierClassName = ASM_CLASS_MODIFIER_CLASS_NAME;
        if ("BCEL".equalsIgnoreCase(library)) {
            modifierClassName = BCEL_CLASS_MODIFIER_CLASS_NAME;
        }
        Class<?> cls = null;
        try {
            cls = this.loadClass(modifierClassName);
            this.classModifier = cls.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error("djUnit initialize error.");
        }
    }

    protected byte[] getModifiedClass(String name) throws Exception {
        try {
            Class<?> clazz = this.classModifier.getClass();
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            Method modifyMethod = clazz.getMethod(CLASS_MODIFIER_MTHOD_NAME, classArray);
            return (byte[])modifyMethod.invoke(this.classModifier, name);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }
}

