/*
 * Decompiled with CFR 0.152.
 */
package jp.co.dgic.testing.common.virtualmock.asm;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import jp.co.dgic.testing.common.util.DJUnitUtil;
import jp.co.dgic.testing.common.virtualmock.InternalMockObjectManager;
import jp.co.dgic.testing.common.virtualmock.VirtualMockUtil;
import jp.co.dgic.testing.common.virtualmock.asm.AsmClassChecker;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public abstract class AbstractAsmMethodVisitor
extends MethodAdapter
implements Opcodes {
    protected static final String CONSTRUCTOR_METHOD_NAME = "<init>";
    protected static final String MANAGER_PACKAGE_NAME = "jp/co/dgic/testing/common/virtualmock/";
    protected static final String MANAGER_CLASS_NAME = "jp/co/dgic/testing/common/virtualmock/InternalMockObjectManager";
    protected static final String NULL_RETURN_VALUE_CLASS_NAME = "jp/co/dgic/testing/common/virtualmock/NullReturnValue";
    protected String _className;
    protected String _methodName;
    protected String _desc;
    protected String _signature;
    protected boolean _isStatic = false;
    protected String[] _exceptions;
    protected int _maxLocals = -1;
    protected Type[] _types;
    protected Type _returnType;
    protected Map classCheckerMap = new HashMap();
    protected String[] _superClassNames;
    protected boolean isAfterDup = false;

    public AbstractAsmMethodVisitor(MethodVisitor methodVisitor, String className, String methodName, String desc, String signature, boolean isStatic, String[] exceptions, int maxLocals, String[] superClassNames) {
        super(methodVisitor);
        this._className = className;
        this._methodName = methodName;
        this._desc = desc;
        this._signature = signature;
        this._isStatic = isStatic;
        this._exceptions = exceptions;
        this._maxLocals = maxLocals;
        this._types = Type.getArgumentTypes((String)desc);
        this._returnType = Type.getReturnType((String)desc);
        this._superClassNames = superClassNames;
    }

    public void visitInsn(int opcode) {
        if (opcode == 89 || opcode == 90) {
            this.isAfterDup = true;
        }
        super.visitInsn(opcode);
    }

    public void visitTypeInsn(int opcode, String desc) {
        if (opcode == 187) {
            this.isAfterDup = false;
        }
        super.visitTypeInsn(opcode, desc);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        boolean isInterface = this.isInterface(owner);
        String newOwner = owner;
        if (!isInterface) {
            newOwner = this.getOwnerClassName(owner, name, desc);
        }
        if (!owner.equals(newOwner)) {
            InternalMockObjectManager.printConsole("### owner name : " + owner + ", real owner name : " + newOwner + " ###");
        }
        if (this.isConstructor(name)) {
            this.createConstructorCall(opcode, newOwner, name, desc);
            return;
        }
        this.createMethodCall(opcode, newOwner, name, desc);
    }

    public void createMethodCall(int opcode, String owner, String name, String desc) {
        boolean isStaticMethod = opcode == 184;
        boolean isInterface = opcode == 185;
        InternalMockObjectManager.printConsole("[INVOKE METHOD] : " + (isStaticMethod ? " static " : " ") + owner + "#" + name + " " + desc);
        if (!this.canReplace(owner, isInterface)) {
            this.mv.visitMethodInsn(opcode, owner, name, desc);
            return;
        }
        Label hasMockReturnValue = new Label();
        Type[] argTypes = Type.getArgumentTypes((String)desc);
        if (argTypes == null) {
            argTypes = new Type[]{};
        }
        this.createCopyStackArgsToLocalVariables(isStaticMethod, argTypes);
        this.createCreateArgsArray(isStaticMethod, argTypes, this._maxLocals + 1);
        this.mv.visitLdcInsn((Object)this.makeKey(owner.replace('/', '.'), name));
        this.mv.visitVarInsn(25, this._maxLocals);
        this.mv.visitMethodInsn(184, MANAGER_CLASS_NAME, "indicateCalledAndGetReturnValue", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;");
        this.mv.visitVarInsn(58, this._maxLocals);
        this.mv.visitVarInsn(25, this._maxLocals);
        this.mv.visitJumpInsn(199, hasMockReturnValue);
        this.createPutArgsIntoStackFromLocalValriables(isStaticMethod, argTypes);
        this.mv.visitMethodInsn(opcode, owner, name, desc);
        Label toNextStatement = new Label();
        this.mv.visitJumpInsn(167, toNextStatement);
        this.mv.visitLabel(hasMockReturnValue);
        String[] exceptions = this.getExceptions(owner, name, desc);
        this.createThrowExceptions(exceptions);
        this.createInvoleThrowException(owner, name);
        Type returnType = Type.getReturnType((String)desc);
        if (this.isVoid(returnType, name)) {
            this.mv.visitVarInsn(25, this._maxLocals);
            this.mv.visitLdcInsn((Object)this.makeName(owner, name));
            this.mv.visitMethodInsn(184, MANAGER_CLASS_NAME, "checkReturnTypeIsIgnoreOrNullReturnValue", "(Ljava/lang/Object;Ljava/lang/String;)V");
        } else {
            String returnTypeClassName = this.getReturnTypeClassName(returnType, owner, name);
            this.mv.visitVarInsn(25, this._maxLocals);
            this.mv.visitTypeInsn(193, NULL_RETURN_VALUE_CLASS_NAME);
            Label toSetNullValue = new Label();
            this.mv.visitJumpInsn(154, toSetNullValue);
            this.mv.visitVarInsn(25, this._maxLocals);
            this.mv.visitTypeInsn(193, returnTypeClassName);
            Label toMockValueLoad = new Label();
            this.mv.visitJumpInsn(154, toMockValueLoad);
            this.mv.visitVarInsn(25, this._maxLocals);
            this.mv.visitLdcInsn((Object)this.makeName(owner, name));
            this.mv.visitMethodInsn(184, MANAGER_CLASS_NAME, "checkReturnTypeIsNullReturnValue", "(Ljava/lang/Object;Ljava/lang/String;)V");
            this.mv.visitLabel(toSetNullValue);
            this.mv.visitInsn(this.getZeroOpcodeByType(returnType));
            this.mv.visitJumpInsn(167, toNextStatement);
            this.mv.visitLabel(toMockValueLoad);
            this.mv.visitVarInsn(25, this._maxLocals);
            this.mv.visitTypeInsn(192, returnTypeClassName);
            if (this.isPrimitive(returnType)) {
                String methodNameOfToValue = this.getToValueMethodName(returnType);
                String descriptorOfToValue = this.getToValueDescriptor(returnType);
                this.mv.visitMethodInsn(182, returnTypeClassName, methodNameOfToValue, descriptorOfToValue);
            }
        }
        this.mv.visitLabel(toNextStatement);
    }

    public void createConstructorCall(int opcode, String owner, String name, String desc) {
        if (this.isSuperOrThis(owner)) {
            this.mv.visitMethodInsn(opcode, owner, name, desc);
            return;
        }
        boolean isStaticMethod = opcode == 184;
        InternalMockObjectManager.printConsole("[INVOKE CONSTRUCTOR] : " + (isStaticMethod ? " static " : " ") + owner + "#" + name + " " + desc);
        if (!this.canNewExprReplace(owner)) {
            this.mv.visitMethodInsn(opcode, owner, name, desc);
            return;
        }
        Label hasMockReturnValue = new Label();
        Type[] argTypes = Type.getArgumentTypes((String)desc);
        if (argTypes == null) {
            argTypes = new Type[]{};
        }
        this.createCopyStackArgsToLocalVariables(isStaticMethod, argTypes);
        this.createCreateArgsArray(isStaticMethod, argTypes, this._maxLocals + 1);
        this.mv.visitLdcInsn((Object)this.makeKey(owner.replace('/', '.'), name));
        this.mv.visitVarInsn(25, this._maxLocals);
        this.mv.visitLdcInsn((Object)new Boolean(this.isOwnSource(owner)));
        this.mv.visitMethodInsn(184, MANAGER_CLASS_NAME, "indicateCalledAndGetReturnValueForNewExpr", "(Ljava/lang/String;[Ljava/lang/Object;Z)Ljava/lang/Object;");
        this.mv.visitVarInsn(58, this._maxLocals);
        this.mv.visitVarInsn(25, this._maxLocals);
        this.mv.visitJumpInsn(199, hasMockReturnValue);
        this.createPutArgsIntoStackFromLocalValriables(isStaticMethod, argTypes);
        this.mv.visitMethodInsn(opcode, owner, name, desc);
        Label toNextStatement = new Label();
        this.mv.visitJumpInsn(167, toNextStatement);
        this.mv.visitLabel(hasMockReturnValue);
        if (this.isOwnSource(owner)) {
            this.mv.visitVarInsn(25, this._maxLocals);
            this.createCreateArgsArray(isStaticMethod, argTypes, this._maxLocals + 1);
            this.mv.visitLdcInsn((Object)this.makeKey(owner.replace('/', '.'), name));
            this.mv.visitVarInsn(25, this._maxLocals);
            this.mv.visitMethodInsn(184, MANAGER_CLASS_NAME, "indicateCalled", "(Ljava/lang/String;[Ljava/lang/Object;)V");
            this.mv.visitVarInsn(58, this._maxLocals);
        }
        String[] exceptions = this.getExceptions(owner, name, desc);
        this.createThrowExceptions(exceptions);
        this.createInvoleThrowException(owner, name);
        Type returnType = Type.getReturnType((String)desc);
        if (!this.isAfterDup) {
            this.mv.visitLabel(toNextStatement);
            return;
        }
        this.mv.visitInsn(87);
        String returnTypeClassName = this.getReturnTypeClassName(returnType, owner, name);
        this.mv.visitVarInsn(25, this._maxLocals);
        this.mv.visitTypeInsn(193, NULL_RETURN_VALUE_CLASS_NAME);
        Label toSetNullValue = new Label();
        this.mv.visitJumpInsn(154, toSetNullValue);
        this.mv.visitVarInsn(25, this._maxLocals);
        this.mv.visitTypeInsn(193, returnTypeClassName);
        Label toMockValueLoad = new Label();
        this.mv.visitJumpInsn(154, toMockValueLoad);
        this.mv.visitVarInsn(25, this._maxLocals);
        this.mv.visitLdcInsn((Object)this.makeName(owner, name));
        this.mv.visitMethodInsn(184, MANAGER_CLASS_NAME, "checkReturnTypeForNewExpr", "(Ljava/lang/Object;Ljava/lang/String;)V");
        this.mv.visitLabel(toSetNullValue);
        this.mv.visitInsn(1);
        this.mv.visitJumpInsn(167, toNextStatement);
        this.mv.visitLabel(toMockValueLoad);
        this.mv.visitVarInsn(25, this._maxLocals);
        this.mv.visitTypeInsn(192, returnTypeClassName);
        if (this.isPrimitive(returnType)) {
            String methodNameOfToValue = this.getToValueMethodName(returnType);
            String descriptorOfToValue = this.getToValueDescriptor(returnType);
            this.mv.visitMethodInsn(182, returnTypeClassName, methodNameOfToValue, descriptorOfToValue);
        }
        this.mv.visitLabel(toNextStatement);
    }

    protected void createReturnValueProcess() {
        Label l = new Label();
        this.mv.visitVarInsn(25, this._maxLocals);
        this.mv.visitJumpInsn(198, l);
        this.createThrowExceptions(this._exceptions);
        this.createInvoleThrowException(this._className, this._methodName);
        if (this.isVoid(this._returnType, this._methodName)) {
            this.mv.visitVarInsn(25, this._maxLocals);
            this.mv.visitLdcInsn((Object)this.makeName(this._className, this._methodName));
            this.mv.visitMethodInsn(184, MANAGER_CLASS_NAME, "checkReturnTypeIsIgnoreOrNullReturnValue", "(Ljava/lang/Object;Ljava/lang/String;)V");
            this.mv.visitInsn(177);
        } else {
            String returnTypeClassName = this.getReturnTypeClassName(this._returnType, this._className, this._methodName);
            this.mv.visitVarInsn(25, this._maxLocals);
            this.mv.visitTypeInsn(193, NULL_RETURN_VALUE_CLASS_NAME);
            Label toSetNullValue = new Label();
            this.mv.visitJumpInsn(154, toSetNullValue);
            this.mv.visitVarInsn(25, this._maxLocals);
            this.mv.visitTypeInsn(193, returnTypeClassName);
            Label toMockValueLoad = new Label();
            this.mv.visitJumpInsn(154, toMockValueLoad);
            this.mv.visitVarInsn(25, this._maxLocals);
            this.mv.visitLdcInsn((Object)this.makeName(this._className, this._methodName));
            this.mv.visitMethodInsn(184, MANAGER_CLASS_NAME, "checkReturnTypeIsNullReturnValue", "(Ljava/lang/Object;Ljava/lang/String;)V");
            this.mv.visitLabel(toSetNullValue);
            this.mv.visitInsn(this.getZeroOpcodeByType(this._returnType));
            this.mv.visitInsn(this.getReturnOpcodeByType(this._returnType));
            this.mv.visitLabel(toMockValueLoad);
            this.mv.visitVarInsn(25, this._maxLocals);
            this.mv.visitTypeInsn(192, returnTypeClassName);
            if (this.isPrimitive(this._returnType)) {
                String methodNameOfToValue = this.getToValueMethodName(this._returnType);
                String descriptorOfToValue = this.getToValueDescriptor(this._returnType);
                this.mv.visitMethodInsn(182, returnTypeClassName, methodNameOfToValue, descriptorOfToValue);
            }
            this.mv.visitInsn(this.getReturnOpcodeByType(this._returnType));
        }
        this.mv.visitLabel(l);
    }

    protected void createPrintln(String string) {
        this.mv.visitFieldInsn(178, "java/lang/System", "out", "Ljava/io/PrintStream;");
        this.mv.visitLdcInsn((Object)string);
        this.mv.visitMethodInsn(182, "java/io/PrintStream", "println", "(Ljava/lang/String;)V");
    }

    protected void createPrintlnMaxLocalsVariable() {
        this.mv.visitFieldInsn(178, "java/lang/System", "out", "Ljava/io/PrintStream;");
        this.mv.visitVarInsn(25, this._maxLocals);
        this.mv.visitMethodInsn(182, "java/io/PrintStream", "println", "(Ljava/lang/Object;)V");
    }

    protected void createThrowExceptions(String[] exceptions) {
        if (exceptions == null) {
            return;
        }
        int i = 0;
        while (i < exceptions.length) {
            InternalMockObjectManager.printConsole("exceptions[" + i + "] : " + exceptions[i]);
            this.mv.visitVarInsn(25, this._maxLocals);
            this.mv.visitTypeInsn(193, exceptions[i]);
            Label nextException = new Label();
            this.mv.visitJumpInsn(153, nextException);
            this.mv.visitVarInsn(25, this._maxLocals);
            this.mv.visitTypeInsn(192, exceptions[i]);
            this.mv.visitInsn(191);
            this.mv.visitLabel(nextException);
            ++i;
        }
    }

    protected void createInvoleThrowException(String className, String methodName) {
        this.mv.visitVarInsn(25, this._maxLocals);
        this.mv.visitLdcInsn((Object)this.makeName(className, methodName));
        this.mv.visitMethodInsn(184, MANAGER_CLASS_NAME, "throwException", "(Ljava/lang/Object;Ljava/lang/String;)V");
    }

    protected void createCreateArgsArray(boolean isStaticMethod, Type[] argTypes, int varStartIndex) {
        this.mv.visitIntInsn(16, argTypes.length);
        this.mv.visitTypeInsn(189, "java/lang/Object");
        this.mv.visitVarInsn(58, this._maxLocals);
        int varIndex = varStartIndex;
        if (!isStaticMethod) {
            ++varIndex;
        }
        int i = 0;
        while (i < argTypes.length) {
            this.mv.visitVarInsn(25, this._maxLocals);
            this.mv.visitIntInsn(16, i);
            if (this.isPrimitive(argTypes[i])) {
                String wrapperType = this.toWrapperType(argTypes[i]);
                this.mv.visitTypeInsn(187, wrapperType);
                this.mv.visitInsn(89);
                this.mv.visitVarInsn(this.getLoadOpcodeByType(argTypes[i]), varIndex);
                this.mv.visitMethodInsn(183, wrapperType, CONSTRUCTOR_METHOD_NAME, "(" + argTypes[i] + ")V");
                if (this.isTwoEntryType(argTypes[i])) {
                    ++varIndex;
                }
            } else {
                this.mv.visitVarInsn(25, varIndex);
            }
            ++varIndex;
            this.mv.visitInsn(83);
            ++i;
        }
    }

    protected void createCopyStackArgsToLocalVariables(boolean isStaticMethod, Type[] argTypes) {
        int argLength = argTypes.length;
        int argIndex = this._maxLocals + argLength;
        argIndex += this.getTwoEntryTypeCount(argTypes);
        if (!isStaticMethod) {
            ++argIndex;
        }
        int idx = argLength - 1;
        while (idx >= 0) {
            if (this.isTwoEntryType(argTypes[idx])) {
                --argIndex;
            }
            this.mv.visitVarInsn(this.getStoreOpcodeByType(argTypes[idx]), argIndex);
            --argIndex;
            --idx;
        }
        if (!isStaticMethod) {
            this.mv.visitVarInsn(58, argIndex);
        }
    }

    protected void createPutArgsIntoStackFromLocalValriables(boolean isStaticMethod, Type[] argTypes) {
        int argLength = argTypes.length;
        int argIndex = this._maxLocals + 1;
        if (!isStaticMethod) {
            this.mv.visitVarInsn(25, argIndex);
            ++argIndex;
        }
        int idx = 0;
        while (idx < argLength) {
            this.mv.visitVarInsn(this.getLoadOpcodeByType(argTypes[idx]), argIndex);
            if (this.isTwoEntryType(argTypes[idx])) {
                ++argIndex;
            }
            ++argIndex;
            ++idx;
        }
    }

    protected String[] getExceptions(String className, String methodName, String desc) {
        AsmClassChecker acc = this.getClassChecker(className);
        if (acc == null) {
            return new String[0];
        }
        return acc.getExceptions(methodName, desc);
    }

    protected String getOwnerClassName(String className, String methodName, String desc) {
        AsmClassChecker acc = this.getClassChecker(className);
        if (acc == null) {
            return className;
        }
        String name = acc.getOwnerName(String.valueOf(methodName) + desc, className);
        if (name == null) {
            return className;
        }
        return name.replace('.', '/');
    }

    protected AsmClassChecker getClassChecker(String className) {
        AsmClassChecker acc = (AsmClassChecker)((Object)this.classCheckerMap.get(className));
        if (acc != null) {
            return acc;
        }
        acc = new AsmClassChecker();
        try {
            ClassReader cr = new ClassReader(className);
            cr.accept((ClassVisitor)acc, 4);
        }
        catch (IOException iOException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.classCheckerMap.put(className, acc);
        return acc;
    }

    protected int getLoadOpcodeByType(Type type) {
        if (type.equals((Object)Type.BOOLEAN_TYPE)) {
            return 21;
        }
        if (type.equals((Object)Type.BYTE_TYPE)) {
            return 21;
        }
        if (type.equals((Object)Type.CHAR_TYPE)) {
            return 21;
        }
        if (type.equals((Object)Type.SHORT_TYPE)) {
            return 21;
        }
        if (type.equals((Object)Type.INT_TYPE)) {
            return 21;
        }
        if (type.equals((Object)Type.LONG_TYPE)) {
            return 22;
        }
        if (type.equals((Object)Type.DOUBLE_TYPE)) {
            return 24;
        }
        if (type.equals((Object)Type.FLOAT_TYPE)) {
            return 23;
        }
        return 25;
    }

    protected int getStoreOpcodeByType(Type type) {
        if (type.equals((Object)Type.BOOLEAN_TYPE)) {
            return 54;
        }
        if (type.equals((Object)Type.BYTE_TYPE)) {
            return 54;
        }
        if (type.equals((Object)Type.CHAR_TYPE)) {
            return 54;
        }
        if (type.equals((Object)Type.SHORT_TYPE)) {
            return 54;
        }
        if (type.equals((Object)Type.INT_TYPE)) {
            return 54;
        }
        if (type.equals((Object)Type.LONG_TYPE)) {
            return 55;
        }
        if (type.equals((Object)Type.DOUBLE_TYPE)) {
            return 57;
        }
        if (type.equals((Object)Type.FLOAT_TYPE)) {
            return 56;
        }
        return 58;
    }

    protected int getReturnOpcodeByType(Type type) {
        if (type.equals((Object)Type.BOOLEAN_TYPE)) {
            return 172;
        }
        if (type.equals((Object)Type.BYTE_TYPE)) {
            return 172;
        }
        if (type.equals((Object)Type.CHAR_TYPE)) {
            return 172;
        }
        if (type.equals((Object)Type.SHORT_TYPE)) {
            return 172;
        }
        if (type.equals((Object)Type.INT_TYPE)) {
            return 172;
        }
        if (type.equals((Object)Type.LONG_TYPE)) {
            return 173;
        }
        if (type.equals((Object)Type.DOUBLE_TYPE)) {
            return 175;
        }
        if (type.equals((Object)Type.FLOAT_TYPE)) {
            return 174;
        }
        return 176;
    }

    protected String toWrapperType(Type type) {
        if (type.equals((Object)Type.BOOLEAN_TYPE)) {
            return "java/lang/Boolean";
        }
        if (type.equals((Object)Type.BYTE_TYPE)) {
            return "java/lang/Byte";
        }
        if (type.equals((Object)Type.CHAR_TYPE)) {
            return "java/lang/Character";
        }
        if (type.equals((Object)Type.SHORT_TYPE)) {
            return "java/lang/Short";
        }
        if (type.equals((Object)Type.INT_TYPE)) {
            return "java/lang/Integer";
        }
        if (type.equals((Object)Type.LONG_TYPE)) {
            return "java/lang/Long";
        }
        if (type.equals((Object)Type.DOUBLE_TYPE)) {
            return "java/lang/Double";
        }
        if (type.equals((Object)Type.FLOAT_TYPE)) {
            return "java/lang/Float";
        }
        return "java/lang/Object";
    }

    protected boolean isPrimitive(Type type) {
        if (type.equals((Object)Type.BOOLEAN_TYPE)) {
            return true;
        }
        if (type.equals((Object)Type.BYTE_TYPE)) {
            return true;
        }
        if (type.equals((Object)Type.CHAR_TYPE)) {
            return true;
        }
        if (type.equals((Object)Type.SHORT_TYPE)) {
            return true;
        }
        if (type.equals((Object)Type.INT_TYPE)) {
            return true;
        }
        if (type.equals((Object)Type.LONG_TYPE)) {
            return true;
        }
        if (type.equals((Object)Type.DOUBLE_TYPE)) {
            return true;
        }
        return type.equals((Object)Type.FLOAT_TYPE);
    }

    protected int getZeroOpcodeByType(Type type) {
        if (type.equals((Object)Type.BOOLEAN_TYPE)) {
            return 3;
        }
        if (type.equals((Object)Type.BYTE_TYPE)) {
            return 3;
        }
        if (type.equals((Object)Type.CHAR_TYPE)) {
            return 3;
        }
        if (type.equals((Object)Type.SHORT_TYPE)) {
            return 3;
        }
        if (type.equals((Object)Type.INT_TYPE)) {
            return 3;
        }
        if (type.equals((Object)Type.LONG_TYPE)) {
            return 9;
        }
        if (type.equals((Object)Type.DOUBLE_TYPE)) {
            return 14;
        }
        if (type.equals((Object)Type.FLOAT_TYPE)) {
            return 11;
        }
        return 1;
    }

    protected boolean isVoid(Type type, String methodName) {
        if (this.isConstructor(methodName)) {
            return false;
        }
        return Type.VOID_TYPE.equals((Object)type);
    }

    protected String getReturnTypeClassName(Type type, String className, String methodName) {
        if (this.isConstructor(methodName)) {
            return className;
        }
        if (this.isPrimitive(type)) {
            return this.toWrapperType(type);
        }
        if (this.isArrayType(type)) {
            return type.toString();
        }
        return type.getClassName().replace('.', '/');
    }

    protected boolean isArrayType(Type type) {
        return type.getSort() == 9;
    }

    protected boolean isConstructor(String methodName) {
        return CONSTRUCTOR_METHOD_NAME.equals(methodName);
    }

    protected String getToValueMethodName(Type type) {
        if (this.isPrimitive(type)) {
            return String.valueOf(type.getClassName()) + "Value";
        }
        throw new IllegalArgumentException("Type[" + type + "] is NOT primitive type.");
    }

    protected String getToValueDescriptor(Type type) {
        if (this.isPrimitive(type)) {
            return "()" + type;
        }
        throw new IllegalArgumentException("Type[" + type + "] is NOT primitive type.");
    }

    protected boolean isTwoEntryType(Type type) {
        return Type.LONG_TYPE.equals((Object)type) || Type.DOUBLE_TYPE.equals((Object)type);
    }

    protected int getTwoEntryTypeCount(Type[] types) {
        if (types == null) {
            return 0;
        }
        int count = 0;
        int i = 0;
        while (i < types.length) {
            if (this.isTwoEntryType(types[i])) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    protected boolean isSuperOrThis(String className) {
        if (className == null) {
            return false;
        }
        if (this._superClassNames == null) {
            return false;
        }
        String name = className.replace('/', '.');
        int i = 0;
        while (i < this._superClassNames.length) {
            if (name.equals(this._superClassNames[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean canReplace(String className, boolean isInterface) {
        String name = className.replace('/', '.');
        if (DJUnitUtil.isDJUnitSystemClass(name)) {
            return false;
        }
        if (DJUnitUtil.isDefaultExcludedPath(name)) {
            return false;
        }
        if (!isInterface && this.isOwnSource(name)) {
            return false;
        }
        return !this.isIgnore(name);
    }

    protected boolean canNewExprReplace(String className) {
        String name = className.replace('/', '.');
        if (DJUnitUtil.isDJUnitSystemClass(name)) {
            return false;
        }
        if (DJUnitUtil.isDefaultExcludedPath(name)) {
            return false;
        }
        if (this.isIgnore(name)) {
            return this.isOwnSource(name);
        }
        return true;
    }

    private boolean isIgnore(String className) {
        if (!this.isIgnoreLibrary()) {
            return false;
        }
        return !VirtualMockUtil.isNotIgnore(className);
    }

    private boolean isIgnoreLibrary() {
        String ignoreLibrary = System.getProperty("jp.co.dgic.eclipse.virtualmock.ignore.library");
        if (ignoreLibrary == null || "".equals(ignoreLibrary)) {
            return false;
        }
        if ("false".equalsIgnoreCase(ignoreLibrary)) {
            return false;
        }
        return "true".equalsIgnoreCase(ignoreLibrary);
    }

    private boolean isInterface(String className) {
        AsmClassChecker acc = this.getClassChecker(className);
        if (acc == null) {
            return false;
        }
        return acc.isInterface();
    }

    protected boolean isOwnSource(String className) {
        String name = className.replace('/', '.');
        if (VirtualMockUtil.getIncludeValue() != null && VirtualMockUtil.isInclude(name)) {
            return true;
        }
        return DJUnitUtil.isProjectsSource(name);
    }

    protected String makeKey(String className, String methodName) {
        return String.valueOf(className.replace('/', '.')) + "." + methodName;
    }

    protected String makeName(String className, String methodName) {
        return String.valueOf(className.replace('/', '.')) + "#" + methodName;
    }

    protected String getInvokeOpcode(int opcode) {
        if (opcode == 185) {
            return "INVOKEINTERFACE";
        }
        if (opcode == 183) {
            return "INVOKESPECIAL";
        }
        if (opcode == 182) {
            return "INVOKEVIRTUAL";
        }
        if (opcode == 184) {
            return "INVOKESTATIC";
        }
        return "invoke opcode unknown...";
    }
}

