/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.calendar.factory;

import java.sql.Time;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import com.clustercontrol.bean.DataRangeConstant;
import com.clustercontrol.bean.DayOfWeekConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.calendar.ejb.entity.CalendarWeekdayInfoLocal;
import com.clustercontrol.calendar.ejb.entity.CalendarWeekdayInfoPK;
import com.clustercontrol.calendar.ejb.entity.CalendarWeekdayInfoUtil;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;

/**
 * カレンダ曜日別情報用プロパティ作成クラス
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class WeekdayProperty {
	/** 曜日 */
	public static final String WEEKDAY = "weekday";
	/** 時間帯(From) */
	public static final String TIME_FROM = "timeFrom";
	/** 時間帯(To) */
	public static final String TIME_TO = "timeTo";
	/** 説明 */
	public static final String DESCRIPTION = "description";
	/** 作成日時 */
	public static final String CREATE_TIME = "createTimestamp";
	/** 作成者 */
	public static final String CREATOR_NAME = "creatorName";
	/** 更新者 */
	public static final String MODIFIER_NAME = "ModifierName";
	/** 更新日時 */
	public static final String MODIFY_TIME = "ModifyTime";
	
	/**
	 * カレンダ曜日別情報用プロパティを返します。
	 * 
	 * @param id
	 * @param weekday
	 * @param from
	 * @param to
	 * @param mode
	 * @param locale
	 * @return カレンダ曜日別情報用プロパティ
	 * @throws FinderException
	 * @throws NamingException
	 * @throws FinderException
	 * @throws NamingException
	 */
	public Property getProperty(String id, Integer weekday, Date from, Date to, int mode, Locale locale) throws FinderException, NamingException {
		Property property = getProperty(mode, locale);
		
		if(mode == PropertyConstant.MODE_MODIFY){
		    //カレンダ曜日別情報を取得
			CalendarWeekdayInfoLocal info = 
				CalendarWeekdayInfoUtil.getLocalHome().findByPrimaryKey(
						new CalendarWeekdayInfoPK(id, weekday, new Time(from.getTime()), new Time(to.getTime())));
			
			if(info != null){
				//曜日
				ArrayList propertyList = PropertyUtil.getProperty(property, WEEKDAY);
				((Property)propertyList.get(0)).setValue(DayOfWeekConstant.typeToString(info.getWeekday().intValue()));
				//時間帯(From)
				propertyList = PropertyUtil.getProperty(property, TIME_FROM);
				((Property)propertyList.get(0)).setValue(info.getTime_from());
				//時間帯(To)
				propertyList = PropertyUtil.getProperty(property, TIME_TO);
				((Property)propertyList.get(0)).setValue(info.getTime_to());
				//説明
				propertyList = PropertyUtil.getProperty(property, DESCRIPTION);
				if(info.getDescription() != null && info.getDescription().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(info.getDescription());
				}
				//登録者
				propertyList = PropertyUtil.getProperty(property, CREATOR_NAME);
				if(info.getReg_user() != null && info.getReg_user().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(info.getReg_user());
				}
				//登録日時
				propertyList = PropertyUtil.getProperty(property, CREATE_TIME);
				if(info.getReg_date() != null){
					((Property)propertyList.get(0)).setValue(info.getReg_date());
				}
				//更新者
				propertyList = PropertyUtil.getProperty(property, MODIFIER_NAME);
				if(info.getUpdate_user() != null && info.getUpdate_user().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(info.getUpdate_user());
				}
				//更新日時
				propertyList = PropertyUtil.getProperty(property, MODIFY_TIME);
				if(info.getUpdate_date() != null){
					((Property)propertyList.get(0)).setValue(info.getUpdate_date());
				}
			}
		}
		
		return property;
	}
	
	/**
	 * カレンダ曜日別情報用プロパティを返します。
	 * 
	 * @param mode
	 * @return カレンダ曜日別情報用プロパティ
	 */
	public Property getProperty(int mode, Locale locale) {
	    //曜日
		Property weekday =
			new Property(WEEKDAY, Messages.getString("weekday", locale), PropertyConstant.EDITOR_SELECT);
		//時間帯(From)
		Property timeFrom =
			new Property(TIME_FROM, Messages.getString("timestamp", locale) + "(" + Messages.getString("start", locale) + ") " + Messages.getString("timestamp.example", locale), 
					PropertyConstant.EDITOR_TIME);
		//時間帯(To)
		Property timeTo =
			new Property(TIME_TO, Messages.getString("timestamp", locale) + "(" + Messages.getString("end", locale) + ") " + Messages.getString("timestamp.example", locale), 
					PropertyConstant.EDITOR_TIME);
		//説明
		Property description =
			new Property(DESCRIPTION, Messages.getString("description", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_256);
		//登録日時
		Property createTime =
			new Property(CREATE_TIME, Messages.getString("create.time", locale), PropertyConstant.EDITOR_DATETIME);
		//登録者
		Property creatorName =
			new Property(CREATOR_NAME, Messages.getString("creator.name", locale), PropertyConstant.EDITOR_TEXT);
		//更新日時
		Property modifyTime =
			new Property(MODIFY_TIME, Messages.getString("update.time", locale), PropertyConstant.EDITOR_DATETIME);
		//更新者
		Property modifierName =
			new Property(MODIFIER_NAME, Messages.getString("modifier.name", locale), PropertyConstant.EDITOR_TEXT);

		//値を初期化
		Object values[][] = {
				{ DayOfWeekConstant.STRING_SUNDAY, DayOfWeekConstant.STRING_MONDAY, DayOfWeekConstant.STRING_TUESDAY, DayOfWeekConstant.STRING_WEDNESDAY, DayOfWeekConstant.STRING_THURSDAY, DayOfWeekConstant.STRING_FRIDAY, DayOfWeekConstant.STRING_SATURDAY }, 
				{ DayOfWeekConstant.STRING_SUNDAY, DayOfWeekConstant.STRING_MONDAY, DayOfWeekConstant.STRING_TUESDAY, DayOfWeekConstant.STRING_WEDNESDAY, DayOfWeekConstant.STRING_THURSDAY, DayOfWeekConstant.STRING_FRIDAY, DayOfWeekConstant.STRING_SATURDAY }};

		weekday.setSelectValues(values);
		weekday.setValue(DayOfWeekConstant.STRING_SUNDAY);
		timeFrom.setValue("");
		timeTo.setValue("");
		description.setValue("");
		createTime.setValue("");
		creatorName.setValue("");
		modifyTime.setValue("");
		modifierName.setValue("");

		//モードにより、変更可及びコピー可を設定
		if(mode == PropertyConstant.MODE_ADD){
			weekday.setModify(PropertyConstant.MODIFY_OK);
			timeFrom.setModify(PropertyConstant.MODIFY_OK);
			timeTo.setModify(PropertyConstant.MODIFY_OK);
			description.setModify(PropertyConstant.MODIFY_OK);
		}
		else if(mode == PropertyConstant.MODE_MODIFY){
			weekday.setModify(PropertyConstant.MODIFY_OK);
			timeFrom.setModify(PropertyConstant.MODIFY_OK);
			timeTo.setModify(PropertyConstant.MODIFY_OK);
			description.setModify(PropertyConstant.MODIFY_OK);
		}
		
		Property property = new Property(null, null, "");
		
		// 初期表示ツリーを構成。
		property.removeChildren();
		property.addChildren(weekday);
		property.addChildren(timeFrom);
		property.addChildren(timeTo);
		property.addChildren(description);
		property.addChildren(createTime);
		property.addChildren(creatorName);
		property.addChildren(modifyTime);
		property.addChildren(modifierName);

		return property;
	}
}
