/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.accesscontrol.action;

import java.rmi.RemoteException;

import javax.naming.NamingException;

import com.clustercontrol.accesscontrol.ejb.session.AccessController;
import com.clustercontrol.accesscontrol.util.EjbConnectionManager;

/**
 * アクセス権限を確認するクライアント側アクションクラス<BR>
 * 
 * ユーザに権限があるか確認します。
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class CheckPermission {
	
	/**
	 * ユーザにロールの権限があるかチェックします。
	 * 
	 * マネージャにSessionBean経由でアクセスし、<BR>
	 * ログインユーザに指定のRole(権限)があるか判定し結果を返します。
	 * 
	 * @param roleName Role名(権限)
	 * @return 指定のRole(権限)がある場合は true
	 * 
	 * @see com.clustercontrol.accesscontrol.util.EjbConnectionManager
	 * @see com.clustercontrol.accesscontrol.ejb.session.AccessController#isPermission(java.lang.String)
	 */
	public boolean check(String roleName) {
		AccessController access = 
			EjbConnectionManager.getConnectionManager().getAccessController();
		
		try {
			return access.isPermission(roleName);
		} catch (RemoteException e) {
		} catch (NamingException e) {
		}
		return false;
	}
}