package com.clustercontrol.bean;

import com.clustercontrol.util.Messages;

public class ProtocolConstant {

	public static final String TYPE_PROTOCOL_TCP = "001";
	
	public static final String STRING_PROTOCOL_TCP = Messages.getString("protocol.tcp");
	
	/**
     * 種別から文字列に変換します。<BR>
	 * 
	 * @param type 種別
	 * @return 文字列
     */
    public static String typeToString(String type) {
        if (type == TYPE_PROTOCOL_TCP) {
            return STRING_PROTOCOL_TCP;
        }
        return "";
    }
    
    /**
     * 文字列から種別に変換します。<BR>
	 * 
	 * @param string 文字列
	 * @return 種別
     */
    public static String stringToType(String string) {
        if (string.equals(STRING_PROTOCOL_TCP)) {
            return TYPE_PROTOCOL_TCP;
        }
        return "";
    }
}
