/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.calendar.composite;

import java.util.ArrayList;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;

import com.clustercontrol.calendar.action.GetAddInfoList;
import com.clustercontrol.calendar.action.GetAddInfoListTableDefine;
import com.clustercontrol.calendar.bean.AddListTableDefine;
import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.util.Messages;

/**
 * カレンダ追加一覧コンポジットクラス<BR>
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class AddInfoListComposite extends Composite {
    protected CommonTableViewer m_viewer = null;

    protected String m_calendarId = null;
    
    protected Label m_labelId = null;
    protected Label m_labelCount = null;

    /**
     * コンストラクタ
     * 
     * @param parent
     * @param style
     * @since 2.0.0
     */
    public AddInfoListComposite(Composite parent, int style) {
        super(parent, style);
        initialize();
    }

    /**
     * 初期化処理<BR>
     * 
     * @since 2.0.0
     */
    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        
        m_labelId = new Label(this, SWT.LEFT);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        m_labelId.setLayoutData(gridData);

        Table table = new Table(this, SWT.H_SCROLL | SWT.V_SCROLL
                | SWT.FULL_SELECTION | SWT.SINGLE);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);

        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData(gridData);

        m_labelCount = new Label(this, SWT.RIGHT);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        m_labelCount.setLayoutData(gridData);
        
        m_viewer = new CommonTableViewer(table);
        m_viewer.createTableColumn(GetAddInfoListTableDefine.get(),
        		AddListTableDefine.SORT_COLUMN_INDEX,
        		AddListTableDefine.SORT_ORDER);

//        m_viewer.addDoubleClickListener(new UserDoubleClickListener(this));
    }

    /**
     * 更新処理<BR>
     * 
     * @since 2.0.0
     */
    public void update(String calendarId) {
    	m_calendarId = calendarId;
    	
        ArrayList info = null;

        //カレンダ追加情報一覧取得
        GetAddInfoList getAddInfoList = new GetAddInfoList();
        info = getAddInfoList.get(calendarId);
		if(info == null){
			info = new ArrayList();
		}
		
        m_viewer.setInput(info);

        if(calendarId != null && calendarId.length() > 0){
        	m_labelId.setText(Messages.getString("calendar.id") + " : " + calendarId);
        }
        else{
        	m_labelId.setText(Messages.getString("calendar.id") + " : ");
        }
        Object[] args = { new Integer(info.size()) };
        m_labelCount.setText(Messages.getString("records", args));
    }

    /**
     * このコンポジットが利用するテーブルビューアを返します。<BR>
     * 
     * @return テーブルビューア
     */
    public TableViewer getTableViewer() {
        return m_viewer;
    }

    /**
     * このコンポジットが利用するテーブルを返します。
     * <BR>
     * @return テーブル
     */
    public Table getTable() {
        return m_viewer.getTable();
    }

	/**
	 * @return
	 */
	public String getCalendarId() {
		return m_calendarId;
	}
}