/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.notify.bean;

public class NotifyInfoDetail implements java.io.Serializable {

	/** 通知ID。 */
	private String m_notifyId;
	
	/** 
	 * 重要度。
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	private Integer m_priority;
	
	/** 
	 * 通知フラグ。
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	private Integer m_validFlg;
	
	/** 
	 * 抑制フラグ。
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	private Integer m_inhibitionFlg;

	/**
	 * 通知IDを返します
	 * @return
	 */
	public String getNotifyId() {
		return m_notifyId;
	}

	/**
	 * 通知IDを設定します。
	 * @param id
	 */
	public void setNotifyId(String id) {
		m_notifyId = id;
	}

	/**
	 * 重要度を返します。
	 * 
	 * @return 重要度
	 */
	public Integer getPriority() {
		return m_priority;
	}
	
	/**
	 * 重要度を設定します。
	 * 
	 * @param m_priority
	 */
	public void setPriority(Integer m_priority) {
		this.m_priority = m_priority;
	}

	/**
	 * 有効無効を返します。（個別重要度）
	 * @return
	 */
	public Integer getValidFlg() {
		return m_validFlg;
	}

	/**
	 * 有効無効を設定します。（個別重要度）
	 * 
	 * @param flg
	 */
	public void setValidFlg(Integer flg) {
		m_validFlg = flg;
	}

	/**
	 * 抑制状態を返します。（個別抑制）
	 * @return
	 */
	public Integer getInhibitionFlg() {
		return m_inhibitionFlg;
	}

	/**`
	 * 抑制状態を設定します。(個別抑制)
	 * 
	 * @param flg
	 */
	public void setInhibitionFlg(Integer flg) {
		m_inhibitionFlg = flg;
	}
	
	
}
