/*
 
Copyright (C) 2008 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.mail.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;

import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.notify.mail.ejb.entity.MailTemplateInfoData;
import com.clustercontrol.notify.mail.ejb.session.MailTemplateController;
import com.clustercontrol.notify.mail.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * メールテンプレート情報を作成するクライアント側アクションクラス<BR>
 * 
 * @version 2.4.0
 * @since 2.4.0
 */
public class AddMailTemplate {

    /**
     * メールテンプレート情報を作成します。<BR>
     * マネージャにSessionBean経由でアクセスします。
     * 
     * @param info 作成対象のメールテンプレート情報
	 * @return 作成に成功した場合、<code> true </code>
	 * 
	 * @see com.clustercontrol.notify.mail.util.EjbConnectionManager
	 * @see com.clustercontrol.notify.mail.ejb.session.MailTemplateController
	 * @see com.clustercontrol.notify.mail.ejb.session.MailTemplateControllerBean#addMailTemplate(com.clustercontrol.notify.mail.ejb.entity.MailTemplateInfoData)
     */
    public boolean add(MailTemplateInfoData info) {
    	
    	MailTemplateController mailTemplate = EjbConnectionManager.getConnectionManager().getMailTemplateController();

        boolean result = false;
        String[] args = { info.getMailTemplateId() };
        try {
        	result = mailTemplate.addMailTemplate(info);
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (CreateException e) {
			if(e instanceof DuplicateKeyException){
				// メールテンプレートIDが重複している場合、エラーダイアログを表示する
	            MessageDialog.openInformation(
	            		null, 
	            		Messages.getString("message"),
	                    Messages.getString("message.notify.mail.10", args));
	            return result;
			}
        } catch (NamingException e) {
        } 
        
		if(result){
        	MessageDialog.openInformation(
        			null, 
        			Messages.getString("successful"), 
        			Messages.getString("message.notify.mail.1", args));
		}
		else{
        	MessageDialog.openError(
        			null, 
        			Messages.getString("failed"), 
        			Messages.getString("message.notify.mail.2", args));
		}
    	
    	return result;
    }
}