/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.priority.composite;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

import com.clustercontrol.util.Messages;

/**
 * パターンラベルコンポジットクラス<BR>
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class PatternLabelComposite extends Composite {

    /**
     * インスタンスを返します。
     * 
     * @param parent 親のコンポジット
     * @param style スタイル
     */
    public PatternLabelComposite(
    		Composite parent, 
    		int style) {
        super(parent, style);

        this.initialize();
    }
    
    /**
     * コンポジットを生成・構築します。
     */
    private void initialize() {
    	
    	// 変数として利用されるラベル
        Label label = null;
        // 変数として利用されるグリッドデータ
        GridData gridData = null;
        
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 2;
        layout.marginWidth = 5;
    	layout.numColumns = 11;
        this.setLayout(layout);

        /*
         * 判定の組み合わせ
         */
        label = new Label(this, SWT.LEFT);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 8;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("combination.of.judgments"));
        
        /*
         * ダミー
         */
        label = new Label(this, SWT.LEFT);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        label.setLayoutData(gridData);
        
        /*
         * 判定結果
         */
        label = new Label(this, SWT.LEFT);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("judgment.result"));
    }
}