/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.http.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.text.ParseException;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;

import org.eclipse.jface.dialogs.MessageDialog;
import org.quartz.SchedulerException;

import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.http.ejb.session.MonitorHttpController;
import com.clustercontrol.http.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * HTTP監視情報を更新するクライアント側アクションクラス<BR>
 * 
 * @version 2.2.0
 * @since 2.1.0
 */
public class ModifyHttp {

    /**
     * HTTP監視情報をマネージャ上で更新します。<BR>
     * 
     * @param info HTTP監視情報
     * @return 更新に成功した場合、true
     */
    public boolean modify(MonitorInfo info) {
    	
    	MonitorHttpController http = EjbConnectionManager.getConnectionManager().getHttpController();

        boolean result = false;
        String[] args = { info.getMonitorId() };
        try {
        	result = http.modifyHttp(info);
        } catch (InvalidTransactionException e) {
        } catch (IllegalStateException e) {
        } catch (RemoteException e) {
        	if(e instanceof AccessException){
        		// アクセス権なしの場合、エラーダイアログを表示する
        		MessageDialog.openInformation(null, Messages.getString("message"),
        				Messages.getString("message.accesscontrol.16"));
        	}
        } catch (CreateException e) {
        } catch (FinderException e) {
        } catch (RemoveException e) {
        } catch (SchedulerException e) {
        } catch (ParseException e) {
        } catch (NamingException e) {
        } catch (NotSupportedException e) {
        } catch (HeuristicMixedException e) {
        } catch (HeuristicRollbackException e) {
        } catch (RollbackException e) {
        } catch (SystemException e) {
        }
        
		if(result){
        	MessageDialog.openInformation(
        			null, 
        			Messages.getString("successful"), 
        			Messages.getString("message.monitor.35", args));
		}
		else{
        	MessageDialog.openError(
        			null, 
        			Messages.getString("failed"), 
        			Messages.getString("message.monitor.36", args));
		}
		
		return result;
    }
}