/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.composite;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

import com.clustercontrol.jobmanagement.bean.JobTreeItem;

/**
 * ジョブツリー用コンポジットのツリービューア用のITreeContentProviderクラスです。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class JobTreeContentProvider implements ITreeContentProvider {

    /**
     * ジョブツリーアイテムの要素(子のジョブツリーアイテム)を返します。
     * 
     * @param inputElement ジョブツリーアイテム
     * @return ジョブツリーアイテムの配列
     * 
     * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
     */
    public Object[] getElements(Object inputElement) {
        return getChildren(inputElement);
    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.viewers.IContentProvider#dispose()
     */
    public void dispose() {
    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
     */
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    /**
     * ジョブツリーアイテムの子のジョブツリーアイテムを返します。
     * 
     * @param parentElement ジョブツリーアイテム
     * @return ジョブツリーアイテムの配列
     * 
     * @see org.eclipse.jface.viewers.ITreeContentProvider#getChildren(java.lang.Object)
     */
    public Object[] getChildren(Object parentElement) {
        return ((JobTreeItem) parentElement).getChildren();
    }

    /**
     * ジョブツリーアイテムの親ジョブツリーアイテムを返します。
     * 
     * @param element 親ジョブツリーアイテム
     * 
     * @see org.eclipse.jface.viewers.ITreeContentProvider#getParent(java.lang.Object)
     */
    public Object getParent(Object element) {
        return ((JobTreeItem) element).getParent();
    }

    /**
     * ジョブツリーアイテムが子のジョブツリーアイテムを持っているかを返します。
     * 
     * @param element ジョブツリーアイテム
     * @return true：子がある、false：子がない
     * 
     * @see org.eclipse.jface.viewers.ITreeContentProvider#hasChildren(java.lang.Object)
     */
    public boolean hasChildren(Object element) {
        return ((JobTreeItem) element).size() > 0;
    }

}