/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.composite;

import java.util.ArrayList;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.composite.CommonTableViewerSorter;

/**
 * 実行予定用テーブルビューワークラス
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class RunScheduleTableViewer extends CommonTableViewer {
	
    /**
     * コンストラクタ
     * 
     * @param parent 親のコンポジット
     * 
     * @see org.eclipse.swt.SWT
     * @see org.eclipse.swt.widgets.Composite#Composite(Composite parent, int style)
     */
    public RunScheduleTableViewer(Composite parent) {
        super(parent);
    }

    /**
     * コンストラクタ
     * 
     * @param parent 親のコンポジット
     * @param style スタイル
     * 
     * @see org.eclipse.swt.SWT
     * @see org.eclipse.swt.widgets.Composite#Composite(Composite parent, int style)
     */
    public RunScheduleTableViewer(Composite parent, int style) {
        super(parent, style);
    }

    /**
     * コンストラクタ
     * 
     * @param table テーブル
     * 
     * @see org.eclipse.swt.SWT
     * @see org.eclipse.swt.widgets.Composite#Composite(Composite parent, int style)
     */
    public RunScheduleTableViewer(Table table) {
        super(table);
    }

    /**
     * テーブルビューアのカラムを作成します。
     * 
     * @param tableColumnList テーブルカラム情報({@link com.clustercontrol.bean.TableColumnInfo})のリスト
     * @param sortColumnIndex 初期表示時のソート対象のカラムインデックス
     * @param sortOrder 初期表示時のソートオーダー
     * 
     * @see com.clustercontrol.composite.CommonTableViewer#createTableColumn(java.util.ArrayList, int, int)
     */
    public void createTableColumn(ArrayList tableColumnList,
            int sortColumnIndex, int sortOrder) {
        this.m_tableColumnList = tableColumnList;

        for (int i = 0; i < this.m_tableColumnList.size(); i++) {
            TableColumnInfo tableColumnInfo = (TableColumnInfo) this.m_tableColumnList
                    .get(i);
            TableColumn column = new TableColumn(getTable(), tableColumnInfo
                    .getStyle(), i);
            column.setText(tableColumnInfo.getName());
            column.setWidth(tableColumnInfo.getWidth());

            //初期表示時のソート
            if (i == sortColumnIndex) {
                int order = sortOrder;
                tableColumnInfo.setOrder(order);
                setSorter(new CommonTableViewerSorter(i, order));
            }
        }
    }
}