/*
 
Copyright (C) 2007 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/


package com.clustercontrol.maintenance;

import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/**
 * The main plugin class to be used in the desktop.
 */
public class MaintenancePlugin extends AbstractUIPlugin {

	//The shared instance.
	private static MaintenancePlugin plugin;
	
    /** リソースバンドル */
    private ResourceBundle resourceBundle = null;
	
	/**
	 * The constructor.
	 */
	public MaintenancePlugin() {
		super();
		plugin = this;
        try {
            resourceBundle = ResourceBundle
                    .getBundle("com.clustercontrol.maintenance.MaintenancePluginResources");
        } catch (MissingResourceException x) {
            resourceBundle = null;
        }
	}

    /**
     * プラグインのリソースバンドルより、指定した文字列を返します。
     * 
     * @param key
     *            キー文字列
     * @return 指定した文字列。リソースバンドルが無い場合、もしくは指定した文字列 が存在しない場合は、keyを返します。
     */
    public static String getResourceString(String key) {
        ResourceBundle bundle = getDefault().getResourceBundle();
        try {
            return (bundle != null) ? bundle.getString(key) : key;
        } catch (MissingResourceException e) {
            return key;
        }
    }
	
    /**
     * プラグインのリソースバンドルより、指定した文字列を返します。
     * <p>
     * 
     * @param key
     *            キー文字列
     * @param arguments
     *            置き換える文字列
     * @return 指定した文字列。リソースバンドルが無い場合、もしくは指定した文字列 が存在しない場合は、keyを返します。
     * @see java.text.MessageFormat
     */
    public static String getResourceString(String key, Object[] arguments) {
        ResourceBundle bundle = getDefault().getResourceBundle();
        try {
            String message = (bundle != null) ? bundle.getString(key) : key;
            return MessageFormat.format(message, arguments);
        } catch (MissingResourceException e) {
            return key;
        }
    }
    
    /**
     * プラグインIDとして利用できる、固有のIDを返します。
     * 
     * @return プラグインID
     * @see Bundle#getSymbolicName()
     */
    public static String getPluginId() {
        return getDefault().getBundle().getSymbolicName();
    }
    
    /*
     * 参考サイトにて、実装を推奨していたメソッド群です。
     */

    /**
     * ログを出力します。
     * 
     * @param message
     *            ログメッセージ文字列
     * @param e
     *            発生した例外
     */
    public static void log(String message, Exception e) {
        IStatus status = new Status(IStatus.ERROR, getPluginId(),
                IStatus.ERROR, message, e);
        getDefault().getLog().log(status);
    }

    /**
     * ログを出力します。
     * 
     * @param message
     *            ログメッセージ文字列
     */
    public static void log(String message) {
        log(message, null);
    }

    /**
     * ログを出力します。
     * 
     * @param e
     *            発生した例外
     */
    public static void log(Exception e) {
        StringWriter stringWriter = new StringWriter();
        String message = stringWriter.getBuffer().toString();
        log(message, e);
    }

	/**
	 * This method is called upon plug-in activation
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
	}

	/**
	 * This method is called when the plug-in is stopped
	 */
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
		plugin = null;
	}

	/**
	 * Returns the shared instance.
	 */
	public static MaintenancePlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns an image descriptor for the image file at the given
	 * plug-in relative path.
	 *
	 * @param path the path
	 * @return the image descriptor
	 */
	public static ImageDescriptor getImageDescriptor(String path) {
		return AbstractUIPlugin.imageDescriptorFromPlugin("Maintenance", path);
	}
	
    /**
     * プラグインが保持するリソースバンドルを返します。
     * 
     * @return リソースバンドル
     */
    public ResourceBundle getResourceBundle() {
        return resourceBundle;
    }
}
