/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.notify.ejb.entity;

import java.rmi.RemoteException;

import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

/**
 * 通知イベント情報のCMP Entity Beanです。
 * 
 * @ejb.bean name="NotifyMailInfo"
 *     jndi-name="NotifyMailInfo"
 *     type="CMP"
 *     primkey-field="notifyId","priority"
 *     schema="NotifyMailInfo"
 *     cmp-version="2.x"
 *     data-source="java:/HinemosDS"
 *       
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 *           
 * @ejb.persistence 
 *     table-name="cc_notify_mail_info"
 *     
 * @ejb.finder 
 *     query="SELECT OBJECT(a) FROM NotifyMailInfo as a"  
 *     signature="java.util.Collection findAll()"
 *           
 * @ejb.permission
 *     unchecked="true"
 *     
 * @ejb.pk class="com.clustercontrol.notify.ejb.entity.NotifyMailInfoPK"
 */
public abstract class NotifyMailInfoBean implements EntityBean {
	
	/* (非 Javadoc)
	 * @see javax.ejb.EntityBean#setEntityContext(javax.ejb.EntityContext)
	 */
	public void setEntityContext(EntityContext ctx) throws EJBException, RemoteException {
	}
	
	/* (非 Javadoc)
	 * @see javax.ejb.EntityBean#unsetEntityContext()
	 */
	public void unsetEntityContext() throws EJBException, RemoteException {
	}
	
	/**
	 * 通知メール情報を生成します。
	 *
	 * @ejb.create-method
	 * 
	 * @param notifyId 通知ID
	 * @param priority 重要度
	 * @param mailNormalFlg メール通知フラグ
	 * @param mailNormalState メール通知状態
	 * @param mailInhibitionFlg メール抑制フラグ
	 * @param mailInhibitionState メール抑制状態
	 * @param mailFlg メールフラグ
	 * @param mailAddress メールアドレス（セミコロン区切り）
	 * @return プライマリキー
	 * @throws javax.ejb.CreateException
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 * @see com.clustercontrol.bean.ValidConstant
	 * @see com.clustercontrol.bean.MailConfirmConstant
	 */
	public NotifyMailInfoPK ejbCreate(
			String notifyId,
			Integer priority,
			String mailTemplateId,
			Integer mailFlg,
			Integer mailInhibitionFlg,
			String mailAddress) throws javax.ejb.CreateException {
		
		setNotifyId(notifyId);
		setPriority(priority);
		setMailTemplateId(mailTemplateId);
		setMailFlg(mailFlg);
		setMailInhibitionFlg(mailInhibitionFlg);
		setMailAddress(mailAddress);
		return null;
	}
	
	public void ejbRemove() throws RemoveException, EJBException, RemoteException {
	}
	
	public void ejbActivate() throws EJBException, RemoteException {
	}
	
	public void ejbPassivate() throws EJBException, RemoteException {
	}
	
	public void ejbLoad() throws EJBException, RemoteException {
	}
	
	public void ejbStore() throws EJBException, RemoteException {
	}
	
	/**
	 * 通知IDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="notify_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return 通知ID
	 */
	public abstract String getNotifyId();
	
	/**
	 * 通知IDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param notifyId 通知ID
	 */
	public abstract void setNotifyId(String notifyId);
	
	/**
	 * 重要度を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="priority"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public abstract Integer getPriority();
	
	/**
	 * 重要度を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param priority 重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public abstract void setPriority(Integer priority);
	
	/**
	 * メールテンプレートIDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="mail_template_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return  メールテンプレートID
	 */
	public abstract String getMailTemplateId();
	
	/**
	 *  メールテンプレートIDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param mailAddress  メールテンプレートID
	 */
	public abstract void setMailTemplateId(String mailTemplateId);
	
	
	/**
	 * メールフラグを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="mail_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return メールフラグ
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public abstract Integer getMailFlg();
	
	/**
	 * メールフラグを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param mailFlg メールフラグ
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public abstract void setMailFlg(Integer mailFlg);
	

	
	/**
	 * メール抑制フラグを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="mail_inhibition_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return メール抑制フラグ
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public abstract Integer getMailInhibitionFlg();
	
	/**
	 * メール抑制フラグを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param mailInhibitionFlg メール抑制フラグ
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public abstract void setMailInhibitionFlg(Integer mailInhibitionFlg);
	
	/**
	 * メールアドレスを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="mail_address"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(1024)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return メールアドレス（セミコロン区切り）
	 */
	public abstract String getMailAddress();
	
	/**
	 * メールアドレスを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param mailAddress メールアドレス（セミコロン区切り）
	 */
	public abstract void setMailAddress(String mailAddress);
	
	
	//	==========================================
	//	 CMR fields
	//	==========================================
	/**
	 * 通知情報を返します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @ejb.relation 
	 * name="NotifyInfo-NotifyMailInfo"
	 * role-name="NotifyMailInfo-NotifyInfo(multi)"
	 * cascade-delete="yes"
	 * 
	 * @jboss.relation
	 * related-pk-field="notifyId"
	 * fk-column="notify_id"
	 * 
	 * @return 通知情報
	 */
	public abstract NotifyInfoLocal getNotifyInfo();
	
	/**
	 * 通知情報を設定します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @param notifyInfo 通知情報
	 */
	public abstract void setNotifyInfo(NotifyInfoLocal notifyInfo);
}
