/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.notify.ejb.entity;

import java.rmi.RemoteException;
import java.sql.Timestamp;
import java.util.Collection;

import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

/**
 * システム通知情報のCMP Entity Beanです。
 * 
 * @ejb.bean name="SystemNotifyInfo"
 *     jndi-name="SystemNotifyInfo"
 *     type="CMP"
 *     primkey-field="notifyId"
 *     schema="SystemNotifyInfo"
 *     cmp-version="2.x"
 *     data-source="java:/HinemosDS"
 *           
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 *           
 * @ejb.persistence 
 *     table-name="cc_system_notify_info"
 *     
 * @ejb.finder 
 *     query="SELECT OBJECT(a) FROM SystemNotifyInfo as a"  
 *     signature="java.util.Collection findAll()"
 *     
 * @ejb.finder
 *    query=""
 *    signature="java.util.Collection findAllOrderByNotifyId()"
 * @jboss.query
 *    query="SELECT OBJECT(a) FROM SystemNotifyInfo as a ORDER BY a.notifyId"
 *    signature="java.util.Collection findAllOrderByNotifyId()"
 *           
 * @ejb.permission
 *     unchecked="true"
 *     
 * @ejb.pk class="com.clustercontrol.notify.ejb.entity.SystemNotifyEventInfoPK"
 */
public abstract class SystemNotifyInfoBean implements EntityBean {
	
	/* (非 Javadoc)
	 * @see javax.ejb.EntityBean#setEntityContext(javax.ejb.EntityContext)
	 */
	public void setEntityContext(EntityContext ctx) throws EJBException, RemoteException {
	}
	
	/* (非 Javadoc)
	 * @see javax.ejb.EntityBean#unsetEntityContext()
	 */
	public void unsetEntityContext() throws EJBException, RemoteException {
	}
	
	/**
	 * システム通知情報を生成します。
	 *
	 * @ejb.create-method
	 *  
	 * @param notifyId 通知ID
	 * @param description 説明
	 * @param notifyType 通知タイプ
	 * @param inhibitionFlg 抑制間隔フラグ
	 * @param inhibitionFrequency 抑制回数
	 * @param inhibitionPeriod 抑制期間（分）
	 * @param regDate 作成日時
	 * @param updateDate 最終変更日時
	 * @param regUser 作成ユーザ
	 * @param updateUser 更新ユーザ
	 * @return プライマリキー
	 * @throws javax.ejb.CreateException
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 * @see com.clustercontrol.bean.StatusValidPeriodConstant
	 * @see com.clustercontrol.bean.StatusExpirationConstant
	 * @see com.clustercontrol.bean.PriorityConstant
	 * @see com.clustercontrol.bean.ExclusionConstant
	 */
	public java.lang.String ejbCreate(
			String notifyId,
			String description,
			Integer notifyType,
			Integer inhibitionFlg,
			Integer inhibitionFrequency,
			Integer inhibitionPeriod,
			Timestamp regDate,
			Timestamp updateDate,
			String regUser,
			String updateUser,
			Integer vaildFlg
			) throws javax.ejb.CreateException {
		
		
		setNotifyId(notifyId);
		setDescription(description);
		setNotifyType(notifyType);
		setInhibitionFlg(inhibitionFlg);
		setInhibitionFrequency(inhibitionFrequency);
		setInhibitionPeriod(inhibitionPeriod);
		setRegDate(regDate);
		setUpdateDate(updateDate);
		setRegUser(regUser);
		setUpdateUser(updateUser);
	    setValidFlg(vaildFlg);
		return null;
	}
    /**
     * 通知タイプを返します。
     *
     * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="notify_type"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *
	 * @ejb.interface-method 
     * 
     * @return notifyType 通知タイプ
     *
     * @see com.clustercontrol.bean.ValidConstant
     */
	public abstract Integer getNotifyType();
	
	
	/**
	 * 通知タイプを設定します。
	 *
	 * @ejb.interface-method
	 * 
	 * @param notifyType
	 */
	public abstract void setNotifyType(Integer notifyType);


	public void ejbRemove() throws RemoveException, EJBException, RemoteException {
	}
	
	public void ejbActivate() throws EJBException, RemoteException {
	}
	
	public void ejbPassivate() throws EJBException, RemoteException {
	}
	
	public void ejbLoad() throws EJBException, RemoteException {
	}
	
	public void ejbStore() throws EJBException, RemoteException {
	}
	
	/**
	 * 通知IDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="notify_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return 通知ID
	 */
	public abstract String getNotifyId();
	
	/**
	 * 通知IDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param notifyId 通知ID
	 */
	public abstract void setNotifyId(String notifyId);
	
	/**
	 * 説明を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="description"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 説明
	 */
	public abstract String getDescription();
	
	/**
	 * 説明を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param description 説明
	 */
	public abstract void setDescription(String description);
	
	/**
	 * イベント通知フラグを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="event_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return イベント通知フラグ
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public abstract Integer getEventFlg();
	
	/**
	 * イベント通知フラグを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param eventFlg イベント通知フラグ
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public abstract void setEventFlg(Integer eventFlg);
	
	/**
	 * 抑制間隔フラグを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="inhibition_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 抑制間隔フラグ
	 * 
	 * @see com.clustercontrol.bean.ExclusionConstant
	 */
	public abstract Integer getInhibitionFlg();
	
	/**
	 * 抑制間隔フラグを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param inhibitionFlg 抑制間隔フラグ
	 * 
	 * @see com.clustercontrol.bean.ExclusionConstant
	 */
	public abstract void setInhibitionFlg(Integer inhibitionFlg);
	
	/**
	 * 抑制回数を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="inhibition_frequency"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 抑制回数
	 */
	public abstract Integer getInhibitionFrequency();
	
	/**
	 * 抑制回数を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param inhibitionFrequency 抑制回数
	 */
	public abstract void setInhibitionFrequency(Integer inhibitionFrequency);
	
	/**
	 * 抑制期間を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="inhibition_period"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return inhibitionPeriod 抑制期間（分）
	 */
	public abstract Integer getInhibitionPeriod();
	
	/**
	 * 抑制期間を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param inhibitionPeriod 抑制期間（分）
	 */
	public abstract void setInhibitionPeriod(Integer inhibitionPeriod);
	
	/**
	 * 作成日時を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="reg_date"
	 *     jdbc-type="TIMESTAMP"
	 *     sql-type="TIMESTAMP"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 作成日時
	 */
	public abstract Timestamp getRegDate();
	
	/**
	 * 作成日時を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param regDate 作成日時
	 */
	public abstract void setRegDate(Timestamp regDate);
	
	/**
	 * ステータス通知フラグを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="status_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return ステータス通知フラグ
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public abstract Integer getStatusFlg();
	
	/**
	 * ステータス通知フラグを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param statusFlg ステータス通知フラグ
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public abstract void setStatusFlg(Integer statusFlg);
	
	/**
	 * 存続期間経過後の処理フラグを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="status_invalid_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 存続期間経過後の処理フラグ
	 * 
	 * @see com.clustercontrol.bean.StatusExpirationConstant
	 */
	public abstract Integer getStatusInvalidFlg();
	
	/**
	 * 存続期間経過後の処理フラグを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param statusInvalidFlg 存続期間経過後の処理フラグ
	 * 
	 * @see com.clustercontrol.bean.StatusExpirationConstant
	 */
	public abstract void setStatusInvalidFlg(Integer statusInvalidFlg);
	
	/**
	 * ステータス情報更新時重要度を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="status_update_priority"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return ステータス情報更新時重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public abstract Integer getStatusUpdatePriority();
	
	/**
	 * ステータス情報更新時重要度を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param statusUpdatePriority ステータス情報更新時重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public abstract void setStatusUpdatePriority(Integer statusUpdatePriority);
	
	/**
	 * ステータス情報の存続期間を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="status_valid_period"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return ステータス情報の存続期間
	 * 
	 * @see com.clustercontrol.bean.StatusValidPeriodConstant
	 */
	public abstract Integer getStatusValidPeriod();
	
	/**
	 * ステータス情報の存続期間を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param statusValidPeriod ステータス情報の存続期間
	 * 
	 * @see com.clustercontrol.bean.StatusValidPeriodConstant
	 */
	public abstract void setStatusValidPeriod(Integer statusValidPeriod);
	
	/**
	 * 最終変更日時を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="update_date"
	 *     jdbc-type="TIMESTAMP"
	 *     sql-type="TIMESTAMP"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 最終変更日時
	 */
	public abstract Timestamp getUpdateDate();
	
	/**
	 * 最終変更日時を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param updateDate 最終変更日時
	 */
	public abstract void setUpdateDate(Timestamp updateDate);
	

/**
 * 有効無効フラグを返します。
 * 
 * @ejb.persistent-field 
 * @ejb.persistence
 *    column-name="inhibition_period"
 *     jdbc-type="SMALLINT"
 *     sql-type="smallint"
 *     read-only="false"
 *  
 * @ejb.interface-method
 * 
 * @return vaildFlg 有効無効フラグ
 */
public abstract Integer getValidFlg();

/**
 * 有効無効フラグを設定します。
 * 
 * @ejb.interface-method 
 * @param vaildFlg 有効無効フラグ
 */
public abstract void setValidFlg(Integer validFlg);

/**
 *更新ユーザを返します。
 * 
 * @ejb.persistent-field 
 * @ejb.persistence
 *    column-name="update_user"
 *     jdbc-type="VARCHAR"
 *     sql-type="VARCHAR(64)"
 *     read-only="false"
 *
 * @ejb.interface-method
 * 
 * @return updateUser 更新ユーザ
 */
public abstract String getUpdateUser();

/**
 * 最終変更ユーザを設定します。
 * 
 * @ejb.interface-method 
 * @param updateUser 更新ユーザ
 */
public abstract void setUpdateUser(String updateUser);


 /**
 *作成ユーザを返します。
 * 
 * @ejb.persistent-field 
 * @ejb.persistence
 *    column-name="reg_user"
 *     jdbc-type="VARCHAR"
 *     sql-type="VARCHAR(64)"
 *     read-only="false"
 *
 * @ejb.interface-method
 * 
 * @return updateUser 作成ユーザ
 */
public abstract String getRegUser();

/**
 * 作成ユーザを設定します。
 * 
 * @ejb.interface-method 
 * @param regUser 作成ユーザ
 */
public abstract void setRegUser(String regUser);


	
	
	//	==========================================
	//	 CMR fields
	//	==========================================
	/**
	 * システム通知イベント情報を返します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @ejb.relation 
	 * name="SystemNotifyInfo-SystemNotifyEventInfo"
	 * role-name="SystemNotifyInfo-SystemNotifyEventInfo(single)"
	 * 
	 * @return システム通知イベント情報のコレクション
	 */
	public abstract Collection getSystemNotifyEventInfo();
	
	/**
	 * システム通知イベント情報を設定します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @param collection 通知イベント情報のコレクション
	 */
	public abstract void setSystemNotifyEventInfo(Collection collection);
}
