/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.notify.bean.NotifyRelationInfo;
import com.clustercontrol.notify.ejb.entity.NotifyRelationInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyRelationInfoUtil;

/**
 * システム通知情報を検索するクラスです。
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class SelectNotifyRelation {
	
	/** ログ出力のインスタンス。 */
	protected static Log m_log = LogFactory.getLog( SelectNotifyRelation.class );
	
	/**
	 * システム通知情報を返します。
	 * 
	 * @param notifyId 取得対象の通知ID
	 * @return システム通知情報
	 * @throws FinderException
	 * @throws NamingException
	 */
	public Collection<NotifyRelationInfo>  getNotifyRelation(String notifyGroupId) throws FinderException, NamingException {
		
		ArrayList<NotifyRelationInfo> ret = new ArrayList<NotifyRelationInfo> ();
		Collection<NotifyRelationInfoLocal> notifies =  NotifyRelationInfoUtil.getLocalHome().findByNotifyGroupId(notifyGroupId);
		
		Iterator<NotifyRelationInfoLocal> it = notifies.iterator();
		
		while(it.hasNext()){
			
			 NotifyRelationInfoLocal detailEjb =it.next();
			 
			 NotifyRelationInfo detail = new NotifyRelationInfo(
					 detailEjb.getNotifyGroupId(),
					 detailEjb.getNotifyId(),
					 detailEjb.getNotifyType(),
					 detailEjb.getNotifyFlg());
			 
			 ret.add(detail);
			 
		}
		return ret;
		
	}
	
	/**
	 * 引数で指定した通知IDを利用している通知グループIDを取得する。
	 * 
	 * @param notifyId
	 * @return 通知グループIDのリスト
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList<String> getNotifyGroupIdBaseOnNotifyId(String notifyId) throws FinderException, NamingException{
		
		ArrayList<String> ret = new ArrayList<String>();
		Collection<NotifyRelationInfoLocal> relations = NotifyRelationInfoUtil.getLocalHome().findByNotifyId(notifyId);
		
		Iterator<NotifyRelationInfoLocal> itr = relations.iterator();
		
		while(itr.hasNext()){
			
			NotifyRelationInfoLocal relation = itr.next();
			
			ret.add(relation.getNotifyGroupId());
			
		}
		
		return ret;
	}
	
}
