/*
 
Copyright (C) 2008 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.mail.factory;

import java.sql.Timestamp;
import java.util.Date;

import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.notify.mail.ejb.entity.MailTemplateInfoData;
import com.clustercontrol.notify.mail.ejb.entity.MailTemplateInfoUtil;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * メールテンプレート情報を作成するクラス<BR>
 *
 * @version 2.4.0
 * @since 2.4.0
 */
public class AddMailTemplate {
	
	/** ログ出力のインスタンス。 */
	protected static Log m_log = LogFactory.getLog( AddMailTemplate.class );
	
	/**
	 * メールテンプレート情報を作成します。
	 * <p>
	 * <ol>
	 *  <li>メールテンプレート情報を作成します。</li>
	 * </ol>
	 * 
	 * @param info 作成対象のメールテンプレート情報
	 * @param name メールテンプレート情報を作成したユーザ名
	 * @return 作成に成功した場合、<code> true </code>
	 * @throws CreateException
	 * @throws NamingException
	 * 
	 * @see com.clustercontrol.notify.ejb.entity.MailTemplateInfoBean
	 */
	public boolean add(MailTemplateInfoData data, String name) throws CreateException, NamingException {
    	//アクセスロック
    	AccessLock.lock(AccessLock.NOTIFY);

    	Timestamp timestamp = new Timestamp(new Date().getTime());
    	
    	//エンティティBeanを作る
    	try {
			MailTemplateInfoUtil.getLocalHome().create(
					data.getMailTemplateId(),
					data.getDescription(),
					data.getSubject(),
					data.getBody(),
					timestamp,
					timestamp,
					name,
					name);
		} catch (CreateException e) {
			AplLogger apllog = new AplLogger("MAILTEMP", "mailTemplate");
			String[] args = { data.getMailTemplateId() };
			apllog.put("SYS", "001", args);
			m_log.warn("add():" + e.getMessage());
			throw e;
		} catch (NamingException e) {
			AplLogger apllog = new AplLogger("MAILTEMP", "mailTemplate");
			String[] args = { data.getMailTemplateId() };
			apllog.put("SYS", "001", args);
			m_log.warn("add():" + e.getMessage());
			throw e;
		}
    	
    	return true;
	}

}
