/*
                                                                                                
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
*/

package com.clustercontrol.performance.monitor.factory;

import java.rmi.RemoteException;
import java.util.Collection;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.notify.ejb.session.NotifyControllerLocal;
import com.clustercontrol.notify.ejb.session.NotifyControllerUtil;

import com.clustercontrol.monitor.run.factory.DeleteMonitorNumericValueType;
import com.clustercontrol.performance.util.JNDIConnectionManager;
import com.clustercontrol.performance.bean.CollectorRunStatus;
import com.clustercontrol.performance.ejb.bmp.Collector;
import com.clustercontrol.performance.ejb.bmp.CollectorHome;
import com.clustercontrol.performance.ejb.bmp.CollectorPK;
import com.clustercontrol.performance.monitor.ejb.entity.MonitorPerfInfoLocal;
import com.clustercontrol.performance.monitor.ejb.entity.MonitorPerfInfoPK;
import com.clustercontrol.performance.monitor.ejb.entity.MonitorPerfInfoUtil;

/**
 * リソース監視情報削除クラス
 *
 * @version 3.0.0
 * @since 2.0.0
 */
public class DeleteMonitorPerformance extends DeleteMonitorNumericValueType{
	
	protected static Log m_log = LogFactory.getLog( DeleteMonitorPerformance.class );

	/**
	 * リソース監視情報を削除します。
	 * @see com.clustercontrol.monitor.run.factory.DeleteMonitor#deleteCheckInfo()
	 */
	@Override
	public boolean deleteCheckInfo() throws FinderException, RemoveException, NamingException {
		// リソース監視情報を取得
		MonitorPerfInfoPK pk = new MonitorPerfInfoPK(m_monitorId, m_monitorTypeId);
		MonitorPerfInfoLocal perfLocal = MonitorPerfInfoUtil.getLocalHome().findByPrimaryKey(pk);
		
        // 監視のための収集を停止する
        String collectorId = perfLocal.getCollectorId();
        
        try{
        	// 指定のCollectorIDのEntityBeanを取得
        	CollectorHome home = JNDIConnectionManager.getCollectorHome();
        	Collector myBean = home.findByPrimaryKey(new CollectorPK(collectorId));
        	
        	// 収集を停止
        	myBean.stopCollect();
        	
        	// まだ動作中の場合
        	if(myBean.getStatus() == CollectorRunStatus.RUNNING){
        		m_log.debug("deleteRecordCollector()  : " + collectorId + " is running.");
        		throw new RemoveException(collectorId + " is running.");
        	} else {
        		// 収集設定を削除
        		myBean.remove();
        	}
        	

            //通知情報を削除
            NotifyControllerLocal nc = NotifyControllerUtil.getLocalHome().create();
    		
    		
    		//通知情報の取得
    		nc.deleteNotifyRelation(m_monitor.getNotifyGroupId());
    		 
    		//抑制情報の削除
    		nc.deleteNotifyInhibition(m_monitor.getNotifyGroupId());
            
        	
        } catch (FinderException e){
        	// 何もしない
        } catch (RemoteException e) {
			throw new EJBException(e);
		} catch (CreateException e) {
		
			e.printStackTrace();
		}

    	// リソース監視情報を削除
    	perfLocal.remove();
        
        return true;
	}
}
