/*
                                                                                                                                                                 
Copyright (C) 2008 NTT DATA Corporation
                                                                                                                                                                 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
                                                                                                                                                                 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                                                                                                                                                 
*/

package com.clustercontrol.performance.operator;

/**
 * 1番目の項目を2番目の項目で割ったものを百分率を求めます。
 * (var0 / var1) * 100
 */
public class Percentage extends SnmpOperator {
	@Override
	public double calc() throws CollectedDataNotFoundException, InvalidValueException{
		double val1;
		if((val1 = getCurrentMibValue("var1")) == 0) {
			return Double.NaN;				
		} else {
			return (double)getCurrentMibValue("var0") / val1 * 100.D;
		}
	}
}
