/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 */

package com.clustercontrol.performance.jmx;

import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Iterator;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.performance.bean.CollectorType;
import com.clustercontrol.performance.ejb.bmp.Collector;
import com.clustercontrol.performance.ejb.bmp.CollectorHome;
import com.clustercontrol.performance.util.JNDIConnectionManager;

/**
 * 性能管理機能の実績収集、リソース監視機能用性能値収集を再実行するクラス
 *
 */
public class PerformanceRestartManager {
	protected static Log m_log = LogFactory.getLog( PerformanceRestartManager.class );
	
	/**
	 * DBに登録されてる実行中常態の収集を全て再開する。
	 *
	 */
	public void restartAll() {
        try {
        	CollectorHome home = JNDIConnectionManager.getCollectorHome();
        	Collection pks = home.findAll();
        	
        	Iterator itr = pks.iterator();
        	while(itr.hasNext()){
        		Collector collector = (Collector)itr.next();
        		
        		// リアルタイム収集とリソース監視の場合
        		if(collector.getCollectorType() == CollectorType.REALTIME ||
        				collector.getCollectorType() == CollectorType.MONITOR){
            		m_log.debug("set StopDate " + collector.getCollectorID());
        			// 収集終了時刻をクリア
        			collector.setStopDate(null);
        		} else {
            		m_log.debug("check StopTime " + collector.getCollectorID());
        			// 現在時刻よりも収集終了時刻のほうが大きい場合は、既に完了した収集のため収集を再開しない
        			if(collector.getStopDate() != null &&
        					System.currentTimeMillis() >= collector.getStopDate().getTime()){
        				continue;
        			}
        		}
        		
        		// 収集を再開します
        		boolean restarted = collector.restartCollect();
        		
        		m_log.debug("restart " + collector.getCollectorID() + " " + restarted);
        	}
		} catch (RemoteException e) {
			e.printStackTrace();
		} catch (FinderException e) {
			e.printStackTrace();
		} catch (NamingException e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * DBに登録されてるリアルタイム監視、リソース監視用の収集を再起動する。
	 *
	 */
	public void refreshRepositoryAll() {
        try {
        	CollectorHome home = JNDIConnectionManager.getCollectorHome();
        	Collection pks = home.findAll();
        	
        	Iterator itr = pks.iterator();
        	while(itr.hasNext()){
        		Collector collector = (Collector)itr.next();
         		
        		// リアルタイム収集とリソース監視の場合
        		if(collector.getCollectorType() == CollectorType.REALTIME ||
        				collector.getCollectorType() == CollectorType.MONITOR){
        			// 収集を停止します。
        			collector.stopCollect();
       			
        			// リポジトリ情報を更新します。
        			collector.updateScopeTree();

        			// 収集終了時刻をクリア
        			collector.setStopDate(null);
        			
        			// 収集を再開します
        			boolean restarted = collector.restartCollect();
        		
        			m_log.debug("restart " + collector.getCollectorID() + " " + restarted);
        		}
        	}
		} catch (RemoteException e) {
			e.printStackTrace();
		} catch (FinderException e) {
			e.printStackTrace();
		} catch (NamingException e) {
			e.printStackTrace();
		}
	}
}
