/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.ping.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;
import org.quartz.SchedulerException;

import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.ping.ejb.session.MonitorPingController;
import com.clustercontrol.ping.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * ping監視を取得するクライアント側アクションクラス<BR>
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class GetPing {

    /**
     * ping監視情報を取得します。<BR>
     * 
     * @param monitorId 監視項目ID
     * @return ping監視情報
     */
    public MonitorInfo getPing(String monitorId) {

    	MonitorPingController ping = EjbConnectionManager.getConnectionManager().getPingController();

    	MonitorInfo info = null;
        try {
        	info = ping.getPing(monitorId);
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (CreateException e) {
        } catch (FinderException e) {
        } catch (SchedulerException e) {
        } catch (NamingException e) {
        }
        return info;
    }
    
    /**
     * ping監視一覧を返します。
     * 
     * @return ping監視一覧
     */
    public ArrayList getPingList() {

    	MonitorPingController ping = EjbConnectionManager.getConnectionManager()
                .getPingController();

        ArrayList records = null;
        try {
            records = ping.getPingList();
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (CreateException e) {
        } catch (FinderException e) {
        } catch (SchedulerException e) {
        } catch (NamingException e) {
        }
        return records;
    }
}