#!/bin/bash

DIR=/home/hinemos/package/build/RRDTool/release/hinemos_rrdtool

rm ${DIR}/log/hinemos_rrdtool.log
cp config.properties-normal ${DIR}/lib/config.properties

# shell normal test
${DIR}/ResourceDataExport.sh RRDTOOLSI001 cc020 999_01N.def 1209589200 1209600000 999_01N.csv
if [ $? -eq 0 ]; then echo " - OK"; else echo " - NG"; fi
${DIR}/ResourceDataExport.sh RRDTOOLSI001 cc020 999_02N.def 1209664800 1209675600 999_02N.csv
if [ $? -eq 0 ]; then echo " - OK"; else echo " - NG"; fi

# shell abnormal check
# 11
${DIR}/ResourceDataExport.sh RRDTOOLSI001 cc020 999_01N.def 1209589200 1209600000
if [ $? -eq 11 ]; then echo " - OK"; else echo " - NG"; fi
${DIR}/ResourceDataExport.sh RRDTOOLSI001 cc020 999_01N.def 1209589200 1209600000 abnormal.csv XXX
if [ $? -eq 11 ]; then echo " - OK"; else echo " - NG"; fi
# 12
${DIR}/ResourceDataExport.sh RRDTOOLSI001 cc020 999_01NXXX.def 1209589200 1209600000 abnormal.csv
if [ $? -eq 12 ]; then echo " - OK"; else echo " - NG"; fi
# 13
${DIR}/ResourceDataExport.sh RRDTOOLSI001 cc020 999_01E.def 1209589200 1209600000 abnormal.csv
if [ $? -eq 13 ]; then echo " - OK"; else echo " - NG"; fi
# 14
cp config.properties-abnormal ${DIR}/lib/config.properties
${DIR}/ResourceDataExport.sh RRDTOOLSI001 cc020 999_01N.def 1209589200 1209600000 abnormal.csv
if [ $? -eq 14 ]; then echo " - OK"; else echo " - NG"; fi
cp config.properties-normal ${DIR}/lib/config.properties
# 51
${DIR}/ResourceDataExport.sh RRDTOOLSI001 cc020 999_01N.def 1209589200 1209600000 /var/abnormal.csv
if [ $? -eq 51 ]; then echo " - OK"; else echo " - NG"; fi
# 52
${DIR}/ResourceDataExport.sh RRDTOOLSI001 cc020 999_01N.def 1209589200XXX 1209600000 abnormal.csv
if [ $? -eq 52 ]; then echo " - OK"; else echo " - NG"; fi
${DIR}/ResourceDataExport.sh RRDTOOLSI001 cc020 999_01N.def 1209589200 1209600000XXX abnormal.csv
if [ $? -eq 52 ]; then echo " - OK"; else echo " - NG"; fi
${DIR}/ResourceDataExport.sh RRDTOOLSI001 cc020 999_01N.def -1209589200 1209600000 abnormal.csv
if [ $? -eq 52 ]; then echo " - OK"; else echo " - NG"; fi
${DIR}/ResourceDataExport.sh RRDTOOLSI001 cc020 999_01N.def 1209589200 -1209600000 abnormal.csv
if [ $? -eq 52 ]; then echo " - OK"; else echo " - NG"; fi
${DIR}/ResourceDataExport.sh RRDTOOLSI001 cc020 999_01N.def 1209.589200 1209600000 abnormal.csv
if [ $? -eq 52 ]; then echo " - OK"; else echo " - NG"; fi
${DIR}/ResourceDataExport.sh RRDTOOLSI001 cc020 999_01N.def 1209589200 1209.600000 abnormal.csv
if [ $? -eq 52 ]; then echo " - OK"; else echo " - NG"; fi
${DIR}/ResourceDataExport.sh RRDTOOLSI001 cc020 999_01N.def 1209600000 1209589200 abnormal.csv
if [ $? -eq 52 ]; then echo " - OK"; else echo " - NG"; fi
# 53
${DIR}/ResourceDataExport.sh RRDTOOLSI001XXX cc020 999_01N.def 1209589200 1209600000 abnormal.csv
if [ $? -eq 53 ]; then echo " - OK"; else echo " - NG"; fi
# 54
${DIR}/ResourceDataExport.sh RRDTOOLSI001 cc020XXX 999_01N.def 1209589200 1209600000 abnormal.csv
if [ $? -eq 54 ]; then echo " - OK"; else echo " - NG"; fi
# 55
${DIR}/ResourceDataExport.sh RRDTOOLSI001 cc020 999_01N.def 1217527200 1217538000 abnormal.csv
if [ $? -eq 55 ]; then echo " - OK"; else echo " - NG"; fi
# 101
${DIR}/ResourceDataExport.sh RRDTOOLSI001 cc020 999_02E.def 1209589200 1209600000 999_02E.csv
if [ $? -eq 101 ]; then echo " - OK"; else echo " - NG"; fi
# 102
${DIR}/ResourceDataExport.sh RRDTOOLSI001 cc020 999_03E.def 1209589200 1209600000 999_03E.csv
if [ $? -eq 102 ]; then echo " - OK"; else echo " - NG"; fi

cp ${DIR}/log/hinemos_rrdtool.log .

exit 0
