#!/usr/bin/perl

#
# CREATE Sample Data for Hinemos 3.0 cc_calculated_data table
#
# @author NTT DATA takahatat
#

use strict qw( vars subs );

# configuration
my $max_value = 15;
my $min_value = -5;
my $output_file = './csv/cc_calculated_data.csv';
my @milisec = ('.000', '.400', '.800');

# variables
my $LF = "\n";
my $collector_id_file = shift;

# set collector_id list
my $perf_id = '';
my $collector_def = undef;
my $facility_id = '';
my $item_code = '';
my $device_name = '';

if ( open(IN, $collector_id_file) ) {
        while (<IN>) {
                chomp($_);
		if ($_ =~ /^([a-zA-Z0-9]+)\t([0-9]+)\t([0-9]+)\t([a-zA-Z0-9:]+)\t([0-9]+)\t([0-9.]+)\t([^\t]+)$/) {
			$perf_id = $1;
	                $collector_def->{$perf_id}->{'start_epoch'} = $2;
			$collector_def->{$perf_id}->{'epoch_length'} = $3;
			$collector_def->{$perf_id}->{'collect_cnt'} = $3 / $5;
			$collector_def->{$perf_id}->{'epoch_width'} = $5;
			$collector_def->{$perf_id}->{'blue_length'} = $6;
			foreach $facility_id (split(':', $4)) {
				$collector_def->{$perf_id}->{'facility_id'}->{$facility_id} = 1;
			}
			foreach $item_code (split(':', $7)) {
				if ($item_code =~ /^([^-]+)-([^-]+)$/) {
					$item_code = $1;
					$device_name = $2;
				} else {
					$device_name = '""';
				}
				$collector_def->{$perf_id}->{'item_code'}->{$item_code} = $device_name;
			}

		}
        }
        close(IN);
} else {
        print '[ERROR] Failed to read a file(' . $collector_id_file . ')' . $LF;
        exit(-1);
}


# print generate definition
print $LF;
print '---------------------' . $LF;
print 'Generate cc_calculated_date Sample Data' . $LF;
print '---------------------' . $LF;
print $LF;

# generate data
my $data = undef;
my $timestamp = '';
my $hash = undef;
my $collector_id = '';

foreach $collector_id (keys %$collector_def) {
	$hash = $collector_def->{$collector_id};
	foreach $facility_id (keys %{$hash->{'facility_id'}}) {
		for (my $i = 0; $i < $hash->{'collect_cnt'}; $i++) {
			foreach $item_code (keys %{$hash->{'item_code'}}) {
				$timestamp = &blurHiResTimeStr($hash->{'start_epoch'} + $i * $hash->{'epoch_width'}, $hash->{'blue_length'});
				$device_name = $hash->{'item_code'}->{$item_code};
				$data->{$timestamp}->{$collector_id}->{$facility_id}->{$item_code}->{$device_name} = rand($max_value - $min_value) + $min_value;
			}
		}
	}
}

# write data
my $value = 0;
if ( open(OUT, '> ' . $output_file) ) {
	foreach $timestamp (sort keys %$data) {
		foreach $collector_id (keys %{$data->{$timestamp}}) {
			foreach $facility_id (keys %{$data->{$timestamp}->{$collector_id}}) {
				foreach $item_code (keys %{$data->{$timestamp}->{$collector_id}->{$facility_id}}) {
					foreach $device_name (keys %{$data->{$timestamp}->{$collector_id}->{$facility_id}->{$item_code}}) {
						$value = $data->{$timestamp}->{$collector_id}->{$facility_id}->{$item_code}->{$device_name};
						print OUT "$collector_id,SNMP,$item_code,$device_name,$timestamp,$facility_id,$value\n";
					}
				}
			}
		}
	}
	close(OUT);
} else {
	print '[ERROR] Failed to write a file(' . $output_file . ')' . $LF;
	exit(-1);
}

exit(0);

sub createDataTimeStr( $ ) {

	my $epoch_time = shift;

	my @datetime = localtime($epoch_time);
	$datetime[5] += 1900;
	$datetime[4]++;
	my $yyyymmdd = join('-', ( sprintf('%04d', $datetime[5]), sprintf('%02d', $datetime[4]), sprintf('%02d', $datetime[3]) ));
	my $hhmmss = join(':', ( sprintf('%02d', $datetime[2]), sprintf('%02d', $datetime[1]), sprintf('%02d', $datetime[0]) ));

	return $yyyymmdd . ' ' . $hhmmss;
}

sub blurHiResTimeStr( $ $ ) {

	my $epoch_time = shift;
	my $blur_time = shift;
	
	my $blur_epoch_time = $epoch_time + int(rand($blur_time));
	
	return &createDataTimeStr($blur_epoch_time) . $milisec[int(rand($#milisec + 1))];
} 
