package com.clustercontrol.performance.rrdtool;

import java.io.File;
import java.io.IOException;
import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;

import javax.ejb.CreateException;
import javax.naming.CommunicationException;
import javax.naming.NamingException;
import javax.security.auth.login.LoginException;

import com.clustercontrol.performance.rrdtool.PerformanceCSVExport;
import com.clustercontrol.performance.rrdtool.csv.CSVColumn;

import junit.framework.TestCase;

import jp.co.dgic.testing.framework.DJUnitTestCase;

public class PerformanceCSVExportSI001 extends DJUnitTestCase {
	
	private static String file01DN = "resource/si_check/001_01DN.def";
	private static String file02DN = "resource/si_check/001_02DN.def";
	
	private static String file00DE = "resource/si_check/001_00DE.def";
	private static String file16DE = "resource/si_check/001_16DE.def";
	private static String file17DE = "resource/si_check/001_17DE.def";
	
	private static String file01N = "resource/si_out/001_01N.csv";
	private static String file02N = "resource/si_out/001_02N.csv";
	
	private static String file00E = "resource/si_out/001_00E.csv";
	private static String file16E = "resource/si_out/001_16E.csv";
	private static String file17E = "resource/si_out/001_17E.csv";
	
	public PerformanceCSVExportSI001() {
		super();
		init();
	}

	/**
	 * 出力ファイルの初期化
	 */
	public void init() {
		File ut_out_dir = new File("resource/ut_out");
		if (ut_out_dir.isDirectory()) {
			for (File file : ut_out_dir.listFiles()) {
				file.delete();
			}
		}
	}

	public void setUp() throws Exception {
		super.setUp();
	}

	public void tearDown() throws Exception {
		super.tearDown();
	}
	
	/**
	 * PerformanceCSVExport.mainメソッド結合試験<br>
	 * 正常な出力処理（収集日時ブレありデータの場合）（※実行後、5行目から10行目のデータをDBのデータを比較。抽出して目視比較すること。）
	 */
	public void testN01() {
		String[] args = new String[6];

		args[0] = "RRDTOOLSI001";
		args[1] = "cc020";
		args[2] = file01DN;
		args[3] = "1209589200";
		args[4] = "1209600000";
		args[5] = file01N;

		addReturnValue("java.lang.System", "exit");
		PerformanceCSVExport.main(args);
		
		assertEquals(1, getCallCount("java.lang.System", "exit"));
		assertEquals(0, ((Integer) getArgument("java.lang.System", "exit", 0)).intValue());
	}
	
	/**
	 * PerformanceCSVExport.mainメソッド結合試験<br>
	 * 正常な出力処理（収集日時ブレなしデータの場合）（※実行後、5行目から10行目のデータをDBのデータを比較。抽出して目視比較すること。）
	 */
	public void testN02() {
		String[] args = new String[6];

		args[0] = "RRDTOOLSI001";
		args[1] = "cc020";
		args[2] = file02DN;
		args[3] = "1209664800";
		args[4] = "1209675600";
		args[5] = file02N;

		addReturnValue("java.lang.System", "exit");
		PerformanceCSVExport.main(args);
		
		assertEquals(1, getCallCount("java.lang.System", "exit"));
		assertEquals(0, ((Integer) getArgument("java.lang.System", "exit", 0)).intValue());
	}

	/**
	 * PerformanceCSVExport.mainメソッド結合試験<br>
	 * 引数の数が0の場合
	 */
	public void testE01() {
		String[] args = new String[0];

		try {
			addReturnValue("java.lang.System", "exit", new Exception());
			PerformanceCSVExport.main(args);
		} catch (Exception e) {
			assertEquals(1, getCallCount("java.lang.System", "exit"));
			assertEquals(11, ((Integer) getArgument("java.lang.System", "exit", 0)).intValue());
		}
	}

	/**
	 * PerformanceCSVExport.mainメソッド結合試験<br>
	 * 引数の数が5の場合
	 */
	public void testE02() {
		String[] args = new String[5];

		try {
			addReturnValue("java.lang.System", "exit", new Exception());
			PerformanceCSVExport.main(args);
		} catch (Exception e) {
			assertEquals(1, getCallCount("java.lang.System", "exit"));
			assertEquals(11, ((Integer) getArgument("java.lang.System", "exit", 0)).intValue());
		}
	}

	/**
	 * PerformanceCSVExport.mainメソッド結合試験<br>
	 * 引数の数が7の場合
	 */
	public void testE03() {
		String[] args = new String[7];

		try {
			addReturnValue("java.lang.System", "exit", new Exception());
			PerformanceCSVExport.main(args);
		} catch (Exception e) {
			assertEquals(1, getCallCount("java.lang.System", "exit"));
			assertEquals(11, ((Integer) getArgument("java.lang.System", "exit", 0)).intValue());
		}
	}

	/**
	 * PerformanceCSVExport.mainメソッド結合試験<br>
	 * 開始日時の引数が正の整数でない場合（文字列）
	 */
	public void testE04() {
		String[] args = new String[6];

		args[0] = "RRDTOOLSI001";
		args[1] = "cc020";
		args[2] = file00DE;
		args[3] = "XXX";
		args[4] = "1209600000";
		args[5] = file00E;

		try {
			addReturnValue("java.lang.System", "exit", new Exception());
			PerformanceCSVExport.main(args);
		} catch (Exception e) {
			assertEquals(1, getCallCount("java.lang.System", "exit"));
			assertEquals(52, ((Integer) getArgument("java.lang.System", "exit", 0)).intValue());
		}
	}

	/**
	 * PerformanceCSVExport.mainメソッド結合試験<br>
	 * 終了日時の引数が正の整数でない場合（文字列）
	 */
	public void testE05() {
		String[] args = new String[6];

		args[0] = "RRDTOOLSI001";
		args[1] = "cc020";
		args[2] = file00DE;
		args[3] = "1209589200";
		args[4] = "XXX";
		args[5] = file00E;

		try {
			addReturnValue("java.lang.System", "exit", new Exception());
			PerformanceCSVExport.main(args);
		} catch (Exception e) {
			assertEquals(1, getCallCount("java.lang.System", "exit"));
			assertEquals(52, ((Integer) getArgument("java.lang.System", "exit", 0)).intValue());
		}
	}

	/**
	 * PerformanceCSVExport.mainメソッド結合試験<br>
	 * 開始日時の引数が正の整数でない場合（負の整数）
	 */
	public void testE06() {
		String[] args = new String[6];

		args[0] = "RRDTOOLSI001";
		args[1] = "cc020";
		args[2] = file00DE;
		args[3] = "-1209589200";
		args[4] = "1209600000";
		args[5] = file00E;

		try {
			addReturnValue("java.lang.System", "exit", new Exception());
			PerformanceCSVExport.main(args);
		} catch (Exception e) {
			assertEquals(1, getCallCount("java.lang.System", "exit"));
			assertEquals(52, ((Integer) getArgument("java.lang.System", "exit", 0)).intValue());
		}
	}

	/**
	 * PerformanceCSVExport.mainメソッド結合試験<br>
	 * 終了日時の引数が正の整数でない場合（負の整数）
	 */
	public void testE07() {
		String[] args = new String[6];

		args[0] = "RRDTOOLSI001";
		args[1] = "cc020";
		args[2] = file00DE;
		args[3] = "1209589200";
		args[4] = "-1209600000";
		args[5] = file00E;

		try {
			addReturnValue("java.lang.System", "exit", new Exception());
			PerformanceCSVExport.main(args);
		} catch (Exception e) {
			assertEquals(1, getCallCount("java.lang.System", "exit"));
			assertEquals(52, ((Integer) getArgument("java.lang.System", "exit", 0)).intValue());
		}
	}

	/**
	 * PerformanceCSVExport.mainメソッド結合試験<br>
	 * 開始日時の引数が正の整数でない場合（小数）
	 */
	public void testE08() {
		String[] args = new String[6];

		args[0] = "RRDTOOLSI001";
		args[1] = "cc020";
		args[2] = file00DE;
		args[3] = "-1209589200.123";
		args[4] = "1209600000";
		args[5] = file00E;

		try {
			addReturnValue("java.lang.System", "exit", new Exception());
			PerformanceCSVExport.main(args);
		} catch (Exception e) {
			assertEquals(1, getCallCount("java.lang.System", "exit"));
			assertEquals(52, ((Integer) getArgument("java.lang.System", "exit", 0)).intValue());
		}
	}

	/**
	 * PerformanceCSVExport.mainメソッド結合試験<br>
	 * 終了日時の引数が正の整数でない場合（小数）
	 */
	public void testE09() {
		String[] args = new String[6];

		args[0] = "RRDTOOLSI001";
		args[1] = "cc020";
		args[2] = file00DE;
		args[3] = "1209589200";
		args[4] = "-1209600000.123";
		args[5] = file00E;

		try {
			addReturnValue("java.lang.System", "exit", new Exception());
			PerformanceCSVExport.main(args);
		} catch (Exception e) {
			assertEquals(1, getCallCount("java.lang.System", "exit"));
			assertEquals(52, ((Integer) getArgument("java.lang.System", "exit", 0)).intValue());
		}
	}

	/**
	 * PerformanceCSVExport.mainメソッド結合試験<br>
	 * マネージャーへの接続（ログイン）に失敗した場合
	 */
	public void testE10() {
		String[] args = new String[6];

		args[0] = "RRDTOOLSI001";
		args[1] = "cc020";
		args[2] = file00DE;
		args[3] = "1209589200";
		args[4] = "1209600000";
		args[5] = file00E;

		try {
			addReturnValue("java.lang.System", "exit", new Exception());
			addReturnValue("com.clustercontrol.performance.rrdtool.util.LoginManager", "getNamingContext",
					new NamingException());
			PerformanceCSVExport.main(args);
		} catch (Exception e) {
			assertEquals(1, getCallCount("java.lang.System", "exit"));
			assertEquals(14, ((Integer) getArgument("java.lang.System", "exit", 0)).intValue());
		}
	}

	/**
	 * PerformanceCSVExport.mainメソッド結合試験<br>
	 * 収集IDが存在しない場合
	 */
	public void testE11() {
		String[] args = new String[6];

		args[0] = "RRDTOOLSI001XXX";
		args[1] = "cc020";
		args[2] = file00DE;
		args[3] = "1209589200";
		args[4] = "1209600000";
		args[5] = file00E;

		try {
			addReturnValue("java.lang.System", "exit", new Exception());
			PerformanceCSVExport.main(args);
		} catch (Exception e) {
			assertEquals(1, getCallCount("java.lang.System", "exit"));
			assertEquals(53, ((Integer) getArgument("java.lang.System", "exit", 0)).intValue());
		}
	}

	/**
	 * PerformanceCSVExport.mainメソッド結合試験<br>
	 * 性能収集定義オブジェクトの取得に失敗した場合
	 */
	public void testE12() {
		String[] args = new String[6];

		args[0] = "RRDTOOLSI001";
		args[1] = "cc020";
		args[2] = file00DE;
		args[3] = "1209589200";
		args[4] = "1209600000";
		args[5] = file00E;

		try {
			addReturnValue("java.lang.System", "exit", new Exception());
			addReturnValue("com.clustercontrol.performance.ejb.session.CollectorController", "getCollectorProperty",
					new RemoteException());
			PerformanceCSVExport.main(args);
		} catch (Exception e) {
			assertEquals(1, getCallCount("java.lang.System", "exit"));
			assertEquals(14, ((Integer) getArgument("java.lang.System", "exit", 0)).intValue());
		}
	}

	/**
	 * PerformanceCSVExport.mainメソッド結合試験<br>
	 * 性能収集定義にファシリティIDが含まれていない場合
	 */
	public void testE13() {
		String[] args = new String[6];

		args[0] = "RRDTOOLSI001";
		args[1] = "cc020XXX";
		args[2] = file00DE;
		args[3] = "1209589200";
		args[4] = "1209600000";
		args[5] = file00E;

		try {
			addReturnValue("java.lang.System", "exit", new Exception());
			PerformanceCSVExport.main(args);
		} catch (Exception e) {
			assertEquals(1, getCallCount("java.lang.System", "exit"));
			assertEquals(54, ((Integer) getArgument("java.lang.System", "exit", 0)).intValue());
		}
	}

	/**
	 * PerformanceCSVExport.mainメソッド結合試験<br>
	 * 収集性能値の取得に失敗した場合
	 */
	public void testE14() {
		String[] args = new String[6];

		args[0] = "RRDTOOLSI001";
		args[1] = "cc020";
		args[2] = file00DE;
		args[3] = "1209589200";
		args[4] = "1209600000";
		args[5] = file00E;

		try {
			addReturnValue("java.lang.System", "exit", new Exception());
			addReturnValue("com.clustercontrol.performance.ejb.session.CollectorController", "getRecordCollectedData",
					new RemoteException());
			PerformanceCSVExport.main(args);
		} catch (Exception e) {
			assertEquals(1, getCallCount("java.lang.System", "exit"));
			assertEquals(14, ((Integer) getArgument("java.lang.System", "exit", 0)).intValue());
		}
	}
	
	/**
	 * PerformanceCSVExport.mainメソッド結合試験<br>
	 * 出力対象の収集性能値が存在しない場合
	 */
	public void testE15() {
		String[] args = new String[6];

		args[0] = "RRDTOOLSI001";
		args[1] = "cc020";
		args[2] = file00DE;
		args[3] = "121305600";
		args[4] = "121306680";
		args[5] = file00E;

		try {
			addReturnValue("java.lang.System", "exit", new Exception());
			PerformanceCSVExport.main(args);
		} catch (Exception e) {
			assertEquals(1, getCallCount("java.lang.System", "exit"));
			assertEquals(55, ((Integer) getArgument("java.lang.System", "exit", 0)).intValue());
		}
	}
	
	/**
	 * PerformanceCSVExport.mainメソッド結合試験<br>
	 * 出力対象の収集性能値が存在しない出力項目がある場合
	 */
	public void testE16() {
		String[] args = new String[6];

		args[0] = "RRDTOOLSI001";
		args[1] = "cc020";
		args[2] = file16DE;
		args[3] = "1209589200";
		args[4] = "1209600000";
		args[5] = file16E;

		try {
			addReturnValue("java.lang.System", "exit", new Exception());
			PerformanceCSVExport.main(args);
		} catch (Exception e) {
			assertEquals(1, getCallCount("java.lang.System", "exit"));
			assertEquals(102, ((Integer) getArgument("java.lang.System", "exit", 0)).intValue());
		}
	}
	
	/**
	 * PerformanceCSVExport.mainメソッド結合試験<br>
	 * 収集定義に含まれない出力項目がある場合
	 */
	public void testE17() {
		String[] args = new String[6];

		args[0] = "RRDTOOLSI001";
		args[1] = "cc020";
		args[2] = file17DE;
		args[3] = "1209589200";
		args[4] = "1209600000";
		args[5] = file17E;

		try {
			addReturnValue("java.lang.System", "exit", new Exception());
			PerformanceCSVExport.main(args);
		} catch (Exception e) {
			assertEquals(1, getCallCount("java.lang.System", "exit"));
			assertEquals(101, ((Integer) getArgument("java.lang.System", "exit", 0)).intValue());
		}
	}
	
	/**
	 * PerformanceCSVExport.mainメソッド結合試験<br>
	 * セッションBeanの生成に失敗した場合
	 */
	public void testE18() {
		String[] args = new String[6];

		args[0] = "RRDTOOLSI001";
		args[1] = "cc020";
		args[2] = file00DE;
		args[3] = "1209589200";
		args[4] = "1209600000";
		args[5] = file17E;

		try {
			addReturnValue("java.lang.System", "exit", new Exception());
			addReturnValue("com.clustercontrol.accesscontrol.ejb.session.AccessCheckHome", "create",
					new CreateException());
			PerformanceCSVExport.main(args);
		} catch (Exception e) {
			assertEquals(1, getCallCount("java.lang.System", "exit"));
			assertEquals(14, ((Integer) getArgument("java.lang.System", "exit", 0)).intValue());
		}
	}
	
	/**
	 * PerformanceCSVExport.mainメソッド結合試験<br>
	 * ログインに失敗した場合（CommunicationException）
	 */
	public void testE19() {
		String[] args = new String[6];

		args[0] = "RRDTOOLSI001";
		args[1] = "cc020";
		args[2] = file00DE;
		args[3] = "1209589200";
		args[4] = "1209600000";
		args[5] = file17E;

		try {
			addReturnValue("java.lang.System", "exit", new Exception());
			addReturnValue("com.clustercontrol.performance.rrdtool.util.LoginManager", "login",
					new CommunicationException());
			PerformanceCSVExport.main(args);
		} catch (Exception e) {
			assertEquals(1, getCallCount("java.lang.System", "exit"));
			assertEquals(14, ((Integer) getArgument("java.lang.System", "exit", 0)).intValue());
		}
	}
	
	/**
	 * PerformanceCSVExport.mainメソッド結合試験<br>
	 * ログインに失敗した場合（AccessException）
	 */
	public void testE20() {
		String[] args = new String[6];

		args[0] = "RRDTOOLSI001";
		args[1] = "cc020";
		args[2] = file00DE;
		args[3] = "1209589200";
		args[4] = "1209600000";
		args[5] = file17E;

		try {
			addReturnValue("java.lang.System", "exit", new Exception());
			addReturnValue("com.clustercontrol.performance.rrdtool.util.LoginManager", "login",
					new AccessException("SI TEST"));
			PerformanceCSVExport.main(args);
		} catch (Exception e) {
			assertEquals(1, getCallCount("java.lang.System", "exit"));
			assertEquals(14, ((Integer) getArgument("java.lang.System", "exit", 0)).intValue());
		}
	}
	
	/**
	 * PerformanceCSVExport.mainメソッド結合試験<br>
	 * ログインに失敗した場合（LoginException）
	 */
	public void testE21() {
		String[] args = new String[6];

		args[0] = "RRDTOOLSI001";
		args[1] = "cc020";
		args[2] = file00DE;
		args[3] = "1209589200";
		args[4] = "1209600000";
		args[5] = file17E;

		try {
			addReturnValue("java.lang.System", "exit", new Exception());
			addReturnValue("com.clustercontrol.performance.rrdtool.util.LoginManager", "login",
					new LoginException());
			PerformanceCSVExport.main(args);
		} catch (Exception e) {
			assertEquals(1, getCallCount("java.lang.System", "exit"));
			assertEquals(14, ((Integer) getArgument("java.lang.System", "exit", 0)).intValue());
		}
	}
	
	
}
