/*
 
Copyright (C) 2008 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.performance.rrdtool.util;

import java.util.Comparator;

import com.clustercontrol.performance.bean.CollectedDataInfo;

/**
 * Hinemos Addon for RRDTool<br>
 * 収集性能値オブジェクトを日付で比較するクラス<br>
 *
 * @since 3.0.0
 */
public class CollectedDataInfoDateComparator implements Comparator {

	/**
	 * 日付でオブジェクトの大小を比較する。<br>
	 * 
	 * @return o1のほうが最新であれば1、同じ日時であれば0、古ければ-1
	 */
	public int compare(Object o1, Object o2) {
		
		int ret = 0;
		
		long time1 = ((CollectedDataInfo)o1).getDate().getTime();
		long time2 = ((CollectedDataInfo)o2).getDate().getTime();
		
		if (time1 > time2) {
			ret = 1;
		} else if (time1 < time2) {
			ret = -1;
		}
		
		return ret;
	}

}
