package com.clustercontrol.performance.rrdtool;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

import com.clustercontrol.performance.rrdtool.PerformanceCSVExport;
import com.clustercontrol.performance.rrdtool.csv.CSVColumn;
import com.clustercontrol.performance.bean.CollectedDataInfo;

import jp.co.dgic.testing.framework.DJUnitTestCase;
import junit.framework.TestCase;

public class PerformanceCSVExportUT002 extends DJUnitTestCase {

	// 出力ファイル
	private static String file01N = "resource/ut_out/002_01N.def";
	private static String file02N = "resource/ut_out/002_02N.def";
	private static String file03N = "resource/ut_out/002_03N.def";
	private static String file04N = "resource/ut_out/002_04N.def";
	private static String file05N = "resource/ut_out/002_05N.def";
	private static String file06N = "resource/ut_out/002_06N.def";
	private static String file07N = "resource/ut_out/002_07N.def";
	private static String file08N = "resource/ut_out/002_08N.def";
	private static String file09N = "resource/ut_out/002_09N.def";
	private static String file10N = "resource/ut_out/002_10N.def";
	private static String file11N = "resource/ut_out/002_11N.def";
	private static String file12N = "resource/ut_out/002_12N.def";
	
	private static String file01E = "resource/ut_out/002_01E.def";
	private static String file02E = "resource/ut_out/002_02E.def";
	private static String file03E = "resource/ut_out/002_03E.def";
	private static String file04E = "resource/ut_out/002_04E.def";

	// 確認ファイル
	private static String file01C = "resource/ut_check/002_01C.def";
	private static String file02C = "resource/ut_check/002_02C.def";
	private static String file03C = "resource/ut_check/002_03C.def";
	private static String file04C = "resource/ut_check/002_04C.def";
	private static String file05C = "resource/ut_check/002_05C.def";
	private static String file06C = "resource/ut_check/002_06C.def";
	private static String file07C = "resource/ut_check/002_07C.def";
	private static String file08C = "resource/ut_check/002_08C.def";
	private static String file09C = "resource/ut_check/002_09C.def";
	private static String file10C = "resource/ut_check/002_10C.def";
	private static String file11C = "resource/ut_check/002_11C.def";
	private static String file12C = "resource/ut_check/002_12C.def";

	public PerformanceCSVExportUT002() {
		super();
	}
	
	public void setUp() throws Exception {
		super.setUp();
	}

	public void tearDown() throws Exception {
		super.tearDown();
	}

	/**
	 * PerformanceCSVExport.writeCSVFileメソッド単体試験<br>
	 * 出力項目が1つ, 収集性能情報が各項目1つずつの場合
	 */
	public void testN01() {
		ArrayList<CSVColumn> csvCols = csvCols1();
		ArrayList<CollectedDataInfo> collectedDataInfos = collectedDataInfos1();

		PerformanceCSVExport.writeCSVFile(file01N, csvCols, collectedDataInfos);

		if (!compareFile(file01N, file01C)) {
			fail("出力ファイルの比較");
		}
	}

	/**
	 * PerformanceCSVExport.writeCSVFileメソッド単体試験<br>
	 * 出力項目が5つ, 収集性能情報が各項目1つずつの場合
	 */
	public void testN02() {
		ArrayList<CSVColumn> csvCols = csvCols5();
		ArrayList<CollectedDataInfo> collectedDataInfos = collectedDataInfos1();

		PerformanceCSVExport.writeCSVFile(file02N, csvCols, collectedDataInfos);

		if (!compareFile(file02N, file02C)) {
			fail("出力ファイルの比較");
		}
	}

	/**
	 * PerformanceCSVExport.writeCSVFileメソッド単体試験<br>
	 * 出力項目が5つ, 収集性能情報がすべての項目に存在しない場合
	 */
	public void testN03() {
		ArrayList<CSVColumn> csvCols = csvCols5();
		ArrayList<CollectedDataInfo> collectedDataInfos = new ArrayList<CollectedDataInfo>();

		PerformanceCSVExport.writeCSVFile(file03N, csvCols, collectedDataInfos);

		if (!compareFile(file03N, file03C)) {
			fail("出力ファイルの比較");
		}
	}

	/**
	 * PerformanceCSVExport.writeCSVFileメソッド単体試験<br>
	 * 出力項目が5つ, 収集性能情報が一部（先頭の3つの項目）に存在する場合
	 */
	public void testN04() {
		ArrayList<CSVColumn> csvCols = csvCols5();
		ArrayList<CollectedDataInfo> collectedDataInfos = collectedDataInfos2();

		PerformanceCSVExport.writeCSVFile(file04N, csvCols, collectedDataInfos);

		if (!compareFile(file04N, file04C)) {
			fail("出力ファイルの比較");
		}
	}
	
	/**
	 * PerformanceCSVExport.writeCSVFileメソッド単体試験<br>
	 * 出力項目が5つ, 収集性能情報が一部（中央の3つの項目）に存在する場合
	 */
	public void testN05() {
		ArrayList<CSVColumn> csvCols = csvCols5();
		ArrayList<CollectedDataInfo> collectedDataInfos = collectedDataInfos3();

		PerformanceCSVExport.writeCSVFile(file05N, csvCols, collectedDataInfos);

		if (!compareFile(file05N, file05C)) {
			fail("出力ファイルの比較");
		}
	}
	
	/**
	 * PerformanceCSVExport.writeCSVFileメソッド単体試験<br>
	 * 出力項目が5つ, 収集性能情報が一部（末尾の3つの項目）に存在する場合
	 */
	public void testN06() {
		ArrayList<CSVColumn> csvCols = csvCols5();
		ArrayList<CollectedDataInfo> collectedDataInfos = collectedDataInfos4();

		PerformanceCSVExport.writeCSVFile(file06N, csvCols, collectedDataInfos);

		if (!compareFile(file06N, file06C)) {
			fail("出力ファイルの比較");
		}
	}
	
	/**
	 * PerformanceCSVExport.writeCSVFileメソッド単体試験<br>
	 * 出力項目が5つ, 収集性能情報が各項目12つずつに存在する場合
	 */
	public void testN07() {
		ArrayList<CSVColumn> csvCols = csvCols5();
		ArrayList<CollectedDataInfo> collectedDataInfos = collectedDataInfos5();

		PerformanceCSVExport.writeCSVFile(file07N, csvCols, collectedDataInfos);

		if (!compareFile(file07N, file07C)) {
			fail("出力ファイルの比較");
		}
	}
	
	/**
	 * PerformanceCSVExport.writeCSVFileメソッド単体試験<br>
	 * 出力項目が5つ（同一カラムが先頭と末尾）, 収集性能情報が各項目12つずつに存在する場合
	 */
	public void testN08() {
		ArrayList<CSVColumn> csvCols = csvCols5e1();
		ArrayList<CollectedDataInfo> collectedDataInfos = collectedDataInfos5();

		PerformanceCSVExport.writeCSVFile(file08N, csvCols, collectedDataInfos);

		if (!compareFile(file08N, file08C)) {
			fail("出力ファイルの比較");
		}
	}
	
	/**
	 * PerformanceCSVExport.writeCSVFileメソッド単体試験<br>
	 * 出力項目が5つ（同一カラムが先頭と中）, 収集性能情報が各項目12つずつに存在する場合
	 */
	public void testN09() {
		ArrayList<CSVColumn> csvCols = csvCols5e2();
		ArrayList<CollectedDataInfo> collectedDataInfos = collectedDataInfos5();

		PerformanceCSVExport.writeCSVFile(file09N, csvCols, collectedDataInfos);

		if (!compareFile(file09N, file09C)) {
			fail("出力ファイルの比較");
		}
	}
	
	/**
	 * PerformanceCSVExport.writeCSVFileメソッド単体試験<br>
	 * 出力項目が5つ（同一カラムが中と末尾）, 収集性能情報が各項目12つずつに存在する場合
	 */
	public void testN10() {
		ArrayList<CSVColumn> csvCols = csvCols5e3();
		ArrayList<CollectedDataInfo> collectedDataInfos = collectedDataInfos5();

		PerformanceCSVExport.writeCSVFile(file10N, csvCols, collectedDataInfos);

		if (!compareFile(file10N, file10C)) {
			fail("出力ファイルの比較");
		}
	}
	
	/**
	 * PerformanceCSVExport.writeCSVFileメソッド単体試験<br>
	 * 出力項目が5つ, 収集性能情報が各項目12つずつに存在する場合（収集日時が予定とずれている場合）
	 */
	public void testN11() {
		ArrayList<CSVColumn> csvCols = csvCols5();
		ArrayList<CollectedDataInfo> collectedDataInfos = collectedDataInfos6();

		PerformanceCSVExport.writeCSVFile(file11N, csvCols, collectedDataInfos);

		if (!compareFile(file11N, file11C)) {
			fail("出力ファイルの比較");
		}
	}
	
	/**
	 * PerformanceCSVExport.writeCSVFileメソッド単体試験<br>
	 * 出力項目が5つ, 収集性能情報が各項目12つずつに存在する場合（収集間隔が6秒の場合）
	 */
	public void testN12() {
		ArrayList<CSVColumn> csvCols = csvCols5();
		ArrayList<CollectedDataInfo> collectedDataInfos = collectedDataInfos7();

		PerformanceCSVExport.writeCSVFile(file12N, csvCols, collectedDataInfos);

		if (!compareFile(file12N, file12C)) {
			fail("出力ファイルの比較");
		}
	}
	
	/**
	 * PerformanceCSVExport.writeCSVFileメソッド単体試験<br>
	 * ファイルの排他制御に失敗する場合
	 */
	public void testE01() {
		addReturnValue("java.lang.System", "exit");
		addReturnNull("java.nio.channels.FileChannel", "tryLock");
		
		ArrayList<CSVColumn> csvCols = csvCols1();
		ArrayList<CollectedDataInfo> collectedDataInfos = collectedDataInfos1();

		PerformanceCSVExport.writeCSVFile(file01E, csvCols, collectedDataInfos);
		
		assertEquals(1, getCallCount("java.lang.System", "exit"));
		assertEquals(51, ((Integer) getArgument("java.lang.System", "exit", 0)).intValue());
	}
	
	/**
	 * PerformanceCSVExport.writeCSVFileメソッド単体試験<br>
	 * ファイルの書き込みに失敗する場合（パーミッションエラーなど）
	 */
	public void testE02() {
		addReturnValue("java.lang.System", "exit");
		addReturnValue("java.io.FilterOutputStream", "write", new IOException());
		
		ArrayList<CSVColumn> csvCols = csvCols1();
		ArrayList<CollectedDataInfo> collectedDataInfos = collectedDataInfos1();

		PerformanceCSVExport.writeCSVFile(file02E, csvCols, collectedDataInfos);
		
		assertEquals(1, getCallCount("java.lang.System", "exit"));
		assertEquals(51, ((Integer) getArgument("java.lang.System", "exit", 0)).intValue());
	}
	
	/**
	 * PerformanceCSVExport.writeCSVFileメソッド単体試験<br>
	 * ファイルのflushに失敗する場合
	 */
	public void testE03() {
		addReturnValue("java.lang.System", "exit");
		addReturnValue("java.io.BufferedOutputStream", "flush", new IOException());
		
		ArrayList<CSVColumn> csvCols = csvCols1();
		ArrayList<CollectedDataInfo> collectedDataInfos = collectedDataInfos1();

		PerformanceCSVExport.writeCSVFile(file03E, csvCols, collectedDataInfos);
		
		assertEquals(1, getCallCount("java.lang.System", "exit"));
		assertEquals(51, ((Integer) getArgument("java.lang.System", "exit", 0)).intValue());
	}
	
	/**
	 * PerformanceCSVExport.writeCSVFileメソッド単体試験<br>
	 * ファイルのcloseに失敗する場合
	 */
	public void testE04() {
		addReturnValue("java.lang.System", "exit");
		addReturnValue("java.io.FilterOutputStream", "close", new IOException());
		
		ArrayList<CSVColumn> csvCols = csvCols1();
		ArrayList<CollectedDataInfo> collectedDataInfos = collectedDataInfos1();

		PerformanceCSVExport.writeCSVFile(file04E, csvCols, collectedDataInfos);
		
		assertEquals(1, getCallCount("java.lang.System", "exit"));
		assertEquals(51, ((Integer) getArgument("java.lang.System", "exit", 0)).intValue());
	}
	
	/**
	 * PerformanceCSVExport.writeCSVFileメソッド単体試験<br>
	 * ファイルのFileOutputStreamに失敗する場合（出力先ディレクトリが存在しないなど）
	 */
	public void testE05() {
		addReturnValue("java.lang.System", "exit");
		addReturnValue("java.io.FileOutputStream", "<init>", new FileNotFoundException());
		
		ArrayList<CSVColumn> csvCols = csvCols1();
		ArrayList<CollectedDataInfo> collectedDataInfos = collectedDataInfos1();

		PerformanceCSVExport.writeCSVFile(file04E, csvCols, collectedDataInfos);
		
		assertEquals(1, getCallCount("java.lang.System", "exit"));
		assertEquals(51, ((Integer) getArgument("java.lang.System", "exit", 0)).intValue());
	}

	/**
	 * 出力項目定義1
	 * 
	 * @return
	 */
	private ArrayList<CSVColumn> csvCols1() {
		ArrayList<CSVColumn> csvCols = new ArrayList<CSVColumn>();

		csvCols.add(new CSVColumn("CPU_ALL", "CPU0100_CPU_UTIL", ""));

		return csvCols;
	}

	/**
	 * 出力項目定義2
	 * 
	 * @return
	 */
	private ArrayList<CSVColumn> csvCols5() {
		ArrayList<CSVColumn> csvCols = new ArrayList<CSVColumn>();

		csvCols.add(new CSVColumn("CPU_ALL", "CPU0100_CPU_UTIL", ""));
		csvCols.add(new CSVColumn("MEM_PHY", "MEM0100_MEM_UTIL", ""));
		csvCols.add(new CSVColumn("FS /", "FS_0100_DVC_UTIL", "/"));
		csvCols.add(new CSVColumn("FS /var", "FS_0100_DVC_UTIL", "/var"));
		csvCols.add(new CSVColumn("NW eth0", "NET0100_PACKET", "eth0"));

		return csvCols;
	}
	
	/**
	 * 出力項目定義3
	 * 
	 * @return
	 */
	private ArrayList<CSVColumn> csvCols5e1() {
		ArrayList<CSVColumn> csvCols = new ArrayList<CSVColumn>();

		csvCols.add(new CSVColumn("CPU_ALL", "CPU0100_CPU_UTIL", ""));
		csvCols.add(new CSVColumn("MEM_PHY", "MEM0100_MEM_UTIL", ""));
		csvCols.add(new CSVColumn("FS /", "FS_0100_DVC_UTIL", "/"));
		csvCols.add(new CSVColumn("FS /var", "FS_0100_DVC_UTIL", "/var"));
		csvCols.add(new CSVColumn("CPU_ALL", "CPU0100_CPU_UTIL", ""));

		return csvCols;
	}
	
	/**
	 * 出力項目定義4
	 * 
	 * @return
	 */
	private ArrayList<CSVColumn> csvCols5e2() {
		ArrayList<CSVColumn> csvCols = new ArrayList<CSVColumn>();

		csvCols.add(new CSVColumn("CPU_ALL", "CPU0100_CPU_UTIL", ""));
		csvCols.add(new CSVColumn("MEM_PHY", "MEM0100_MEM_UTIL", ""));
		csvCols.add(new CSVColumn("CPU_ALL", "CPU0100_CPU_UTIL", ""));
		csvCols.add(new CSVColumn("FS /var", "FS_0100_DVC_UTIL", "/var"));
		csvCols.add(new CSVColumn("NW eth0", "NET0100_PACKET", "eth0"));

		return csvCols;
	}
	
	/**
	 * 出力項目定義5
	 * 
	 * @return
	 */
	private ArrayList<CSVColumn> csvCols5e3() {
		ArrayList<CSVColumn> csvCols = new ArrayList<CSVColumn>();

		csvCols.add(new CSVColumn("CPU_ALL", "CPU0100_CPU_UTIL", ""));
		csvCols.add(new CSVColumn("MEM_PHY", "MEM0100_MEM_UTIL", ""));
		csvCols.add(new CSVColumn("NW eth0", "NET0100_PACKET", "eth0"));
		csvCols.add(new CSVColumn("FS /var", "FS_0100_DVC_UTIL", "/var"));
		csvCols.add(new CSVColumn("NW eth0", "NET0100_PACKET", "eth0"));

		return csvCols;
	}

	/**
	 * 性能値情報定義1
	 * 
	 * @return
	 */
	private ArrayList<CollectedDataInfo> collectedDataInfos1() {
		ArrayList<String> facilityIDs = new ArrayList<String>();
		facilityIDs.add("db");

		ArrayList<CSVColumn> itemCodes = new ArrayList<CSVColumn>();
		itemCodes.add(new CSVColumn("", "CPU0100_CPU_UTIL", ""));
		itemCodes.add(new CSVColumn("", "MEM0100_MEM_UTIL", ""));
		itemCodes.add(new CSVColumn("", "FS_0100_DVC_UTIL", "/"));
		itemCodes.add(new CSVColumn("", "FS_0100_DVC_UTIL", "/var"));
		itemCodes.add(new CSVColumn("", "NET0100_PACKET", "eth0"));
		itemCodes.add(new CSVColumn("", "NET0100_PACKET", "eth1"));
		itemCodes.add(new CSVColumn("", "MEM0400_SWAP_IO", ""));

		return collectedDataInfos("2008-06-10 8:00:00", 60, 1, facilityIDs, itemCodes);
	}
	
	/**
	 * 性能値情報定義2
	 * 
	 * @return
	 */
	private ArrayList<CollectedDataInfo> collectedDataInfos2() {
		ArrayList<String> facilityIDs = new ArrayList<String>();
		facilityIDs.add("db");

		ArrayList<CSVColumn> itemCodes = new ArrayList<CSVColumn>();
		itemCodes.add(new CSVColumn("", "CPU0100_CPU_UTIL", ""));
		itemCodes.add(new CSVColumn("", "MEM0100_MEM_UTIL", ""));
		itemCodes.add(new CSVColumn("", "FS_0100_DVC_UTIL", "/"));

		return collectedDataInfos("2008-06-10 8:00:00", 60, 1, facilityIDs, itemCodes);
	}
	
	/**
	 * 性能値情報定義3
	 * 
	 * @return
	 */
	private ArrayList<CollectedDataInfo> collectedDataInfos3() {
		ArrayList<String> facilityIDs = new ArrayList<String>();
		facilityIDs.add("db");

		ArrayList<CSVColumn> itemCodes = new ArrayList<CSVColumn>();
		itemCodes.add(new CSVColumn("", "MEM0100_MEM_UTIL", ""));
		itemCodes.add(new CSVColumn("", "FS_0100_DVC_UTIL", "/"));
		itemCodes.add(new CSVColumn("", "FS_0100_DVC_UTIL", "/var"));

		return collectedDataInfos("2008-06-10 8:00:00", 60, 1, facilityIDs, itemCodes);
	}
	
	/**
	 * 性能値情報定義4
	 * 
	 * @return
	 */
	private ArrayList<CollectedDataInfo> collectedDataInfos4() {
		ArrayList<String> facilityIDs = new ArrayList<String>();
		facilityIDs.add("db");

		ArrayList<CSVColumn> itemCodes = new ArrayList<CSVColumn>();
		itemCodes.add(new CSVColumn("", "FS_0100_DVC_UTIL", "/"));
		itemCodes.add(new CSVColumn("", "FS_0100_DVC_UTIL", "/var"));
		itemCodes.add(new CSVColumn("", "NET0100_PACKET", "eth0"));

		return collectedDataInfos("2008-06-10 8:00:00", 60, 1, facilityIDs, itemCodes);
	}
	
	/**
	 * 性能値情報定義5
	 * 
	 * @return
	 */
	private ArrayList<CollectedDataInfo> collectedDataInfos5() {
		ArrayList<String> facilityIDs = new ArrayList<String>();
		facilityIDs.add("db");

		ArrayList<CSVColumn> itemCodes = new ArrayList<CSVColumn>();
		itemCodes.add(new CSVColumn("", "CPU0100_CPU_UTIL", ""));
		itemCodes.add(new CSVColumn("", "MEM0100_MEM_UTIL", ""));
		itemCodes.add(new CSVColumn("", "FS_0100_DVC_UTIL", "/"));
		itemCodes.add(new CSVColumn("", "FS_0100_DVC_UTIL", "/var"));
		itemCodes.add(new CSVColumn("", "NET0100_PACKET", "eth0"));
		itemCodes.add(new CSVColumn("", "NET0100_PACKET", "eth1"));
		itemCodes.add(new CSVColumn("", "MEM0400_SWAP_IO", ""));

		return collectedDataInfos("2008-06-10 8:00:00", 5, 1, facilityIDs, itemCodes);
	}
	
	/**
	 * 性能値情報定義6
	 * 
	 * @return
	 */
	private ArrayList<CollectedDataInfo> collectedDataInfos6() {
		ArrayList<String> facilityIDs = new ArrayList<String>();
		facilityIDs.add("db");

		ArrayList<CSVColumn> itemCodes = new ArrayList<CSVColumn>();
		itemCodes.add(new CSVColumn("", "CPU0100_CPU_UTIL", ""));
		itemCodes.add(new CSVColumn("", "MEM0100_MEM_UTIL", ""));
		itemCodes.add(new CSVColumn("", "FS_0100_DVC_UTIL", "/"));
		itemCodes.add(new CSVColumn("", "FS_0100_DVC_UTIL", "/var"));
		itemCodes.add(new CSVColumn("", "NET0100_PACKET", "eth0"));

		return collectedDataInfosBlur("2008-06-10 8:00:00", 5, 1, facilityIDs, itemCodes);
	}
	
	/**
	 * 性能値情報定義7
	 * 
	 * @return
	 */
	private ArrayList<CollectedDataInfo> collectedDataInfos7() {
		ArrayList<String> facilityIDs = new ArrayList<String>();
		facilityIDs.add("db");

		ArrayList<CSVColumn> itemCodes = new ArrayList<CSVColumn>();
		itemCodes.add(new CSVColumn("", "CPU0100_CPU_UTIL", ""));
		itemCodes.add(new CSVColumn("", "MEM0100_MEM_UTIL", ""));
		itemCodes.add(new CSVColumn("", "FS_0100_DVC_UTIL", "/"));
		itemCodes.add(new CSVColumn("", "FS_0100_DVC_UTIL", "/var"));
		itemCodes.add(new CSVColumn("", "NET0100_PACKET", "eth0"));
		itemCodes.add(new CSVColumn("", "NET0100_PACKET", "eth1"));
		itemCodes.add(new CSVColumn("", "MEM0400_SWAP_IO", ""));

		return collectedDataInfos("2008-06-10 8:00:00", 0.1, 0.1, facilityIDs, itemCodes);
	}

	/**
	 * 性能値情報定義の汎用生成メソッド
	 * 
	 * @return
	 */
	private ArrayList<CollectedDataInfo> collectedDataInfos(String startDateStr, double minWidth, double hours,
			ArrayList<String> facilityIDs, ArrayList<CSVColumn> itemCodes) {

		ArrayList<CollectedDataInfo> collectedDataInfos = new ArrayList<CollectedDataInfo>();

		long startEpoch = 0;
		SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

		int ratio = 0;

		try {
			startEpoch = dateformat.parse(startDateStr).getTime();
		} catch (ParseException e1) {
			fail("collectedDataInfos1 failed");
			e1.printStackTrace();
		}

		for (String facilityID : facilityIDs) {
			for (int i = 0; i < hours * 60 / minWidth; i++) {
				ratio = 0;
				for (CSVColumn itemCode : itemCodes) {
					if (ratio == 0) {
						collectedDataInfos.add(new CollectedDataInfo(facilityID, itemCode.getItemCode(), itemCode
								.getDeviceName(), "SNMP", new Date(startEpoch + (int)(minWidth * 60 * 1000 * i)), Math.pow(-1, i)
								* 0.01 * i));
					} else {
						collectedDataInfos.add(new CollectedDataInfo(facilityID, itemCode.getItemCode(), itemCode
								.getDeviceName(), "SNMP", new Date(startEpoch + (int)(minWidth * 60 * 1000 * i)), Math.pow(-1, i)
								* (Math.pow(10, ratio - 1) + 0.01 * i)));
					}
					ratio++;
				}
			}
		}

		return collectedDataInfos;
	}
	
	/**
	 * 性能値情報定義の汎用生成メソッド（収集日時ずれあり）
	 * 
	 * @return
	 */
	private ArrayList<CollectedDataInfo> collectedDataInfosBlur(String startDateStr, double minWidth, double hours,
			ArrayList<String> facilityIDs, ArrayList<CSVColumn> itemCodes) {

		ArrayList<CollectedDataInfo> collectedDataInfos = new ArrayList<CollectedDataInfo>();

		long startEpoch = 0;
		SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

		int ratio = 0;
		int blursec = 30;

		try {
			startEpoch = dateformat.parse(startDateStr).getTime();
		} catch (ParseException e1) {
			fail("collectedDataInfos1 failed");
			e1.printStackTrace();
		}

		for (String facilityID : facilityIDs) {
			for (int i = 0; i < hours * 60 / minWidth; i++) {
				ratio = 0;
				for (CSVColumn itemCode : itemCodes) {
					if (ratio == 0) {
						collectedDataInfos.add(new CollectedDataInfo(facilityID, itemCode.getItemCode(), itemCode
								.getDeviceName(), "SNMP", new Date(startEpoch + (int)(minWidth * 60 * 1000 * i) + blursec * ratio * 1000), Math.pow(-1, i)
								* 0.01 * i));
					} else {
						collectedDataInfos.add(new CollectedDataInfo(facilityID, itemCode.getItemCode(), itemCode
								.getDeviceName(), "SNMP", new Date(startEpoch + (int)(minWidth * 60 * 1000 * i) + blursec * ratio * 1000), Math.pow(-1, i)
								* (Math.pow(10, ratio - 1) + 0.01 * i)));
					}
					ratio++;
				}
			}
		}

		return collectedDataInfos;
	}

	/**
	 * ファイル内容（バイナリ）比較メソッド
	 * 
	 * @param fileExpect
	 * @param file
	 * @return
	 */
	private boolean compareFile(String fileExpect, String file) {
		boolean ret = true;

		int byte1 = 0;
		int byte2 = 0;
		BufferedInputStream input1 = null;
		BufferedInputStream input2 = null;

		try {
			input1 = new BufferedInputStream(new FileInputStream(fileExpect));
			input2 = new BufferedInputStream(new FileInputStream(file));

			while ((byte1 = input1.read()) != -1 && (byte2 = input2.read()) != -1) {
				if (byte1 != byte2) {
					ret = false;
					break;
				}
			}

		} catch (Exception e) {
			fail("compareFile Failed");
			e.printStackTrace();
		} finally {
			try {
				if (input1 != null) {
					input1.close();
				}
				if (input2 != null) {
					input2.close();
				}
			} catch (IOException e) {
				fail("compareFile Failed");
				e.printStackTrace();
			}
		}

		return ret;
	}

}
