package com.clustercontrol.performance.rrdtool.csv;

import com.clustercontrol.performance.rrdtool.csv.CSVColumn;

import junit.framework.TestCase;

public class CSVColumnUT001 extends TestCase {

	/**
	 * 同一カラム定義（デバイス名なし）の比較1
	 */
	public void testN01() {
		CSVColumn csvCol1 = new CSVColumn("COL1", "CPU0100_CPU_UTIL", "");
		CSVColumn csvCol2 = new CSVColumn("COL1", "CPU0100_CPU_UTIL", "");
		
		assertTrue("カラム定義比較", csvCol1.equalsCollection(csvCol2));
	}
	
	/**
	 * 同一カラム定義（デバイス名あり）の比較2
	 */
	public void testN02() {
		CSVColumn csvCol1 = new CSVColumn("COL1", "FS_0100_DVC_UTIL", "/");
		CSVColumn csvCol2 = new CSVColumn("COL1", "FS_0100_DVC_UTIL", "/");
		
		assertTrue("カラム定義比較", csvCol1.equalsCollection(csvCol2));
	}
	
	/**
	 * デバイス名の異なるカラム定義の比較1<br>
	 * デバイス名なし - デバイス名あり
	 */
	public void testN03() {
		CSVColumn csvCol1 = new CSVColumn("COL1", "FS_0100_DVC_UTIL", "");
		CSVColumn csvCol2 = new CSVColumn("COL1", "FS_0100_DVC_UTIL", "/var");
		
		assertFalse("カラム定義比較", csvCol1.equalsCollection(csvCol2));
	}
	
	/**
	 * 異なるカラム定義（デバイス名）の比較2<br>
	 * デバイス名あり -　デバイス名なし
	 */
	public void testN04() {
		CSVColumn csvCol1 = new CSVColumn("COL1", "FS_0100_DVC_UTIL", "/var");
		CSVColumn csvCol2 = new CSVColumn("COL1", "FS_0100_DVC_UTIL", "");
		
		assertFalse("カラム定義比較", csvCol1.equalsCollection(csvCol2));
	}
	
	/**
	 * 異なるカラム定義（デバイス名）の比較3<br>
	 * デバイス名あり(/) - デバイス名あり(/var)
	 */
	public void testN05() {
		CSVColumn csvCol1 = new CSVColumn("COL1", "FS_0100_DVC_UTIL", "/");
		CSVColumn csvCol2 = new CSVColumn("COL1", "FS_0100_DVC_UTIL", "/var");
		
		assertFalse("カラム定義比較", csvCol1.equalsCollection(csvCol2));
	}
	
	/**
	 * 異なるカラム定義（デバイス名）の比較4<br>
	 * デバイス名あり(/var) - デバイス名あり(/)
	 */
	public void testN06() {
		CSVColumn csvCol1 = new CSVColumn("COL1", "FS_0100_DVC_UTIL", "/var");
		CSVColumn csvCol2 = new CSVColumn("COL1", "FS_0100_DVC_UTIL", "/");
		
		assertFalse("カラム定義比較", csvCol1.equalsCollection(csvCol2));
	}
	
	/**
	 * 異なるカラム定義（アイテム名）の比較1<br>
	 * アイテム名なし - アイテム名(FS_0100_DVC_UTIL)
	 */
	public void testN07() {
		CSVColumn csvCol1 = new CSVColumn("COL1", "", "/");
		CSVColumn csvCol2 = new CSVColumn("COL1", "FS_0100_DVC_UTIL", "/");
		
		assertFalse("カラム定義比較", csvCol1.equalsCollection(csvCol2));
	}
	
	/**
	 * 異なるカラム定義（アイテム名）の比較2<br>
	 * アイテム名(CPU0100_CPU_UTIL) - アイテム名なし
	 */
	public void testN08() {
		CSVColumn csvCol1 = new CSVColumn("COL1", "CPU0100_CPU_UTIL", "/");
		CSVColumn csvCol2 = new CSVColumn("COL1", "", "/");
		
		assertFalse("カラム定義比較", csvCol1.equalsCollection(csvCol2));
	}
	
	/**
	 * 異なるカラム定義（アイテム名）の比較3<br>
	 * アイテム名(CPU0100_CPU_UTIL) - アイテム名(FS_0100_DVC_UTIL)
	 */
	public void testN09() {
		CSVColumn csvCol1 = new CSVColumn("COL1", "CPU0100_CPU_UTIL", "/");
		CSVColumn csvCol2 = new CSVColumn("COL1", "FS_0100_DVC_UTIL", "/");
		
		assertFalse("カラム定義比較", csvCol1.equalsCollection(csvCol2));
	}
	
	/**
	 * 異なるカラム定義（アイテム名,デバイス名)の比較<br>
	 * アイテム名(CPU0100_CPU_UTIL),デバイス名(/) - アイテム名(FS_0100_DVC_UTIL),デバイス名(/var)
	 */
	public void testN10() {
		CSVColumn csvCol1 = new CSVColumn("COL1", "CPU0100_CPU_UTIL", "/");
		CSVColumn csvCol2 = new CSVColumn("COL1", "FS_0100_DVC_UTIL", "/var");
		
		assertFalse("カラム定義比較", csvCol1.equalsCollection(csvCol2));
	}
	
	/**
	 * 異なるカラム定義（カラム名)の比較<br>
	 * カラム名(COL1) - カラム名(COL2)
	 */
	public void testN11() {
		CSVColumn csvCol1 = new CSVColumn("COL1", "CPU0100_CPU_UTIL", "/");
		CSVColumn csvCol2 = new CSVColumn("COL2", "CPU0100_CPU_UTIL", "/");
		
		assertTrue("カラム定義比較", csvCol1.equalsCollection(csvCol2));
	}
	
	/**
	 * 不正なカラム定義（アイテム名）の比較<br>
	 * アイテム名(null) - アイテム名(CPU0100_CPU_UTIL)
	 */
	public void testE01() {
		CSVColumn csvCol1 = new CSVColumn("COL1", null, "/");
		CSVColumn csvCol2 = new CSVColumn("COL1", "FS_0100_DVC_UTIL", "/");
		
		assertFalse("カラム定義比較", csvCol1.equalsCollection(csvCol2));
	}
	
	/**
	 * 不正なカラム定義（デバイス名）の比較<br>
	 * デバイス名(null) - デバイス名(/)
	 */
	public void testE02() {
		CSVColumn csvCol1 = new CSVColumn("COL1", "FS_0100_DVC_UTIL", null);
		CSVColumn csvCol2 = new CSVColumn("COL1", "FS_0100_DVC_UTIL", "/");
		
		assertFalse("カラム定義比較", csvCol1.equalsCollection(csvCol2));
	}
	
	/**
	 * 不正なカラム定義（カラム名）の比較<br>
	 * カラム名(null) - カラム名(COL1)
	 */
	public void testE03() {
		CSVColumn csvCol1 = new CSVColumn(null, "FS_0100_DVC_UTIL", "/");
		CSVColumn csvCol2 = new CSVColumn("COL1", "FS_0100_DVC_UTIL", "/");
		
		assertTrue("カラム定義比較", csvCol1.equalsCollection(csvCol2));
	}
	
	
	
}
