/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */
package com.clustercontrol.snmptrap.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;

import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.commons.util.ConnectionManager;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapInfoBean;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapInfoPK;

/**
 * Entity Bean SnmpTrapInfo DAO実装クラス
 * 
 * @version 3.0.0
 * @since 2.1.0
 */
public class SnmpTrapInfoDAOImpl implements SnmpTrapInfoDAO {
	
	protected static Log m_log = LogFactory.getLog(SnmpTrapInfoDAOImpl.class);
	
	public void init() {
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.snmptrap.dao.SnmpTrapInfoDAO#load(com.clustercontrol.snmptrap.ejb.entity.SnmpTrapInfoPK, com.clustercontrol.snmptrap.ejb.entity.SnmpTrapInfoBean)
	 */
	public void load(SnmpTrapInfoPK pk, SnmpTrapInfoBean ejb) throws EJBException {
		m_log.debug("load() start : " + pk.toString());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			// SQL文の定義
			String sql = "SELECT * FROM cc_snmp_trap_info WHERE monitor_id = ?";
			//SQL文のセット
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, pk.monitorId);
			
			res = stmt.executeQuery();
			
			if (res.next()) {
				//取得した値をBeanにセット
				ejb.setMonitorId(res.getString("monitor_id"));
				ejb.setDescription(res.getString("description"));
				ejb.setFacilityId(res.getString("facility_id"));
				ejb.setCommunityName(res.getString("community_name"));
				ejb.setNotifyGroupId(res.getString("notify_group_id"));
				ejb.setApplication(res.getString("application"));
				ejb.setValidFlg(res.getInt("valid_flg"));
				ejb.setCalendarId(res.getString("calendar_id"));
				ejb.setRegDate(res.getTimestamp("reg_date"));
				ejb.setUpdateDate(res.getTimestamp("update_date"));
				ejb.setRegUser(res.getString("reg_user"));
				ejb.setUpdateUser(res.getString("update_user"));
				ejb.setCheckMode(res.getInt("check_mode"));
			} else {
				String msg = "SnmpTrapInfo data is not found.";
				m_log.error("load() error : " + pk.toString() + " SQLException " + msg);
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			m_log.error("load() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());
		} finally {
			// コネクション、結果セット、プリペアドステートメントのクロース
			try {
				if (stmt != null) {
					stmt.close();
				}
				if (res != null) {
					res.close();
				}
				if (conn != null) {
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("load() error : " + pk.toString() + " SQLException " + e1.getMessage());
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("load() end : " + pk.toString());
	}
	
	/* (非 Javadoc)
	 * @see com.clustercontrol.snmptrap.dao.SnmpTrapInfoDAO#store(com.clustercontrol.snmptrap.ejb.entity.SnmpTrapInfoBean)
	 */
	public void store(SnmpTrapInfoBean ejb) throws EJBException {
		m_log.debug("store() start : " + ejb.getMonitorId());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			//SQL文の定義
			StringBuilder sql = new StringBuilder();
			sql.append("UPDATE cc_snmp_trap_info SET ");
			sql.append("description = ?, ");
			sql.append("facility_id = ?, ");
			sql.append("community_name = ?, ");
			sql.append("notify_group_id = ?, ");
			sql.append("application = ?, ");
			sql.append("valid_flg = ?, ");
			sql.append("calendar_id = ?, ");
			sql.append("reg_date = ?, ");
			sql.append("update_date = ?, ");
			sql.append("reg_user = ?, ");
			sql.append("update_user = ?, ");
			sql.append("check_mode = ?");
			sql.append("WHERE monitor_id = ?");
			
			//SQL文のセット
			stmt = conn.prepareStatement(sql.toString());
			
			stmt.setString(1, ejb.getDescription());
			stmt.setString(2, ejb.getFacilityId());
			stmt.setString(3, ejb.getCommunityName());
			stmt.setString(4, ejb.getNotifyGroupId());
			stmt.setString(5, ejb.getApplication());
			stmt.setInt(6, ejb.getValidFlg());
			stmt.setString(7, ejb.getCalendarId());
			stmt.setTimestamp(8, ejb.getRegDate());
			stmt.setTimestamp(9, ejb.getUpdateDate());
			stmt.setString(10, ejb.getRegUser());
			stmt.setString(11, ejb.getUpdateUser());
			stmt.setInt(12, ejb.getCheckMode());
			stmt.setString(13, ejb.getMonitorId());
			
			int row = stmt.executeUpdate();
			
			if (row != 1) {
				String msg = "result row is not 1";
				m_log.error("store() error : " + ejb.getMonitorId() + " SQLException" + msg);
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			m_log.error("store() error : " + ejb.getMonitorId() + " SQLException");
			e.printStackTrace();
			throw new EJBException(e.getMessage());
		} finally {
			// コネクション、結果セット、プリペアドステートメントのクロース
			try {
				if (stmt != null) {
					stmt.close();
				}
				if (conn != null) {
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("store() error : " + ejb.getMonitorId() + " SQLException");
				e1.printStackTrace();
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("store() end : " + ejb.getMonitorId());
	}
	
	/* (非 Javadoc)
	 * @see com.clustercontrol.snmptrap.dao.SnmpTrapInfoDAO#remove(com.clustercontrol.snmptrap.ejb.entity.SnmpTrapInfoPK)
	 */
	public void remove(SnmpTrapInfoPK pk) throws RemoveException, EJBException {
		m_log.debug("remove() start : " + pk.toString());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			//SQL文の定義
			String sql = "DELETE FROM cc_snmp_trap_info WHERE monitor_id = ?";
			//SQL文のセット
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, pk.monitorId);
			
			int row = stmt.executeUpdate();
			
			if (row != 1 ) {
				String msg = "result row is not 1";
				m_log.error("remove() error : " + pk.toString() + " SQLException" + msg);
				throw new EJBException(msg);	
			}
		} catch (SQLException e) {
			m_log.error("remove() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());
			
		} finally {
			try {
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("remove() error : " + pk.toString() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("remove() end : " + pk.toString());
	}
	
	/* (非 Javadoc)
	 * @see com.clustercontrol.snmptrap.dao.SnmpTrapInfoDAO#create(com.clustercontrol.snmptrap.ejb.entity.SnmpTrapInfoBean)
	 */
	public SnmpTrapInfoPK create(SnmpTrapInfoBean ejb) throws CreateException,
	EJBException {
		m_log.debug("create() start : " + ejb.getMonitorId());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		SnmpTrapInfoPK pk;
		
		
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			//SQL文の定義
			StringBuilder sql = new StringBuilder();
			sql.append("INSERT INTO cc_snmp_trap_info (");
			sql.append("monitor_id, ");
			sql.append("description, ");
			sql.append("facility_id, ");
			sql.append("community_name, ");
			sql.append("notify_group_id, ");
			sql.append("application, ");
			sql.append("valid_flg, ");
			sql.append("calendar_id, ");
			sql.append("reg_date, ");
			sql.append("update_date, ");
			sql.append("reg_user, ");
			sql.append("update_user, ");
			sql.append("check_mode ) ");
			sql.append("values (?,?,?,?,?,?,?,?,?,?,?,?,?)");
			
			//SQL文のセット
			stmt = conn.prepareStatement(sql.toString());
			
			stmt.setString(1, ejb.getMonitorId());
			stmt.setString(2, ejb.getDescription());
			stmt.setString(3, ejb.getFacilityId());
			stmt.setString(4, ejb.getCommunityName());
			stmt.setString(5, ejb.getNotifyGroupId());
			stmt.setString(6, ejb.getApplication());
			stmt.setInt(7, ejb.getValidFlg());
			stmt.setString(8, ejb.getCalendarId());
			stmt.setTimestamp(9, ejb.getRegDate());
			stmt.setTimestamp(10, ejb.getUpdateDate());
			stmt.setString(11, ejb.getRegUser());
			stmt.setString(12, ejb.getUpdateUser());
			stmt.setInt(13,ejb.getCheckMode());
			
			
			int row =	stmt.executeUpdate();
			pk = new SnmpTrapInfoPK(
					ejb.getMonitorId()
			);
			
			if (row != 1) {
				String msg = "result row is not 1";
				m_log.error("create() error : " + ejb.getMonitorId() + " SQLException");
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			if(e.getSQLState().equals("23505")){
				m_log.error("create() error : " + ejb.getMonitorId() + " SQLException" + "DuplicateKeyException ");
				throw new DuplicateKeyException(e.getMessage());
			}
			throw new CreateException(e.getMessage());
		}finally{
			try {
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("create() error : " + ejb.getMonitorId() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("create() end : " + ejb.getMonitorId());
		return pk;
	}
	
	/* (非 Javadoc)
	 * @see com.clustercontrol.snmptrap.dao.SnmpTrapInfoDAO#findAll()
	 */
	public Collection findAll() throws FinderException {
		m_log.debug("findAll() start : ");
		
		ArrayList<SnmpTrapInfoPK> ret = new ArrayList<SnmpTrapInfoPK>();
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();	
			//SQL文の定義
			String sql = "SELECT * FROM cc_snmp_trap_info";
			//SQL文のセット
			stmt = conn.prepareStatement(sql);
			res = stmt.executeQuery();
			
			while(res.next()) {
				SnmpTrapInfoPK pk= new SnmpTrapInfoPK(
						res.getString("monitor_id")
				);
				ret.add(pk);
			}
			
		} catch (SQLException e) {
			m_log.error("findAll() error :  SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("findAll() error :  SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("findAll() end : ");
		return ret;
	}
	
	/* (非 Javadoc)
	 * @see com.clustercontrol.snmptrap.dao.SnmpTrapInfoDAO#findByPrimaryKey(com.clustercontrol.snmptrap.ejb.entity.SnmpTrapInfoPK)
	 */
	public SnmpTrapInfoPK findByPrimaryKey(SnmpTrapInfoPK pk) throws FinderException {
		m_log.debug("findByPrimaryKey() start : " + pk.toString());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			// SQL文の定義
			String sql = "SELECT * FROM cc_snmp_trap_info WHERE monitor_id = ?";
			//SQL文のセット
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, pk.monitorId);
			
			res = stmt.executeQuery();
			
			if (res.next()) {
				return pk;
			} else {
				String msg = "id " + pk.toString() + " not found.";
				throw new FinderException(msg);
			}
		} catch (SQLException e) {
			m_log.error("find() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("find() error : " + pk.toString() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
			m_log.debug("findByPrimaryKey() end : " + pk.toString());
		}
	}

	/* (非 Javadoc)
	 * @see com.clustercontrol.snmptrap.dao.SnmpTrapInfoDAO#findByFacilityId(java.lang.String)
	 */
	public Collection findByFacilityId(String facilityId) throws FinderException {
		m_log.debug("findByFacilityId() start : " + facilityId);
		
		ArrayList<SnmpTrapInfoPK> ret = new ArrayList<SnmpTrapInfoPK>();
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();	
			//SQL文の定義
			String sql = "SELECT * FROM cc_snmp_trap_info WHERE facility_id = ?";
			//SQL文のセット
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, facilityId);
			
			res = stmt.executeQuery();
			
			while(res.next()) {
				SnmpTrapInfoPK pk= new SnmpTrapInfoPK(
						res.getString("monitor_id")
				);
				ret.add(pk);
			}
			
		} catch (SQLException e) {
			m_log.error("findByFacilityId() error : " + facilityId + " SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("findByFacilityId() error : " + facilityId + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("findByFacilityId() end : " + facilityId);
		return ret;
	}
}
