/*
 
Copyright (C) 2008 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.snmptrap.factory;

import java.sql.Timestamp;
import java.util.Date;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.snmptrap.bean.SnmpTrapMasterInfo;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterLocal;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterPK;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterUtil;
import com.clustercontrol.util.apllog.AplLogger;

/**
 *　OIDマスター情報を変更するクラス<BR>
 *
 * @version 3.0.0
 * @since 2.4.0
 * @author Yosuke
 */
public class ModifyOidMaster {
	
	protected static Log m_log = LogFactory.getLog( ModifyOidMaster.class );
	

	protected SnmpTrapMasterInfo m_OidData;
	
/**
 * OIDマスター情報を変更します。
 * 
 * @param oidData　変更するマスター情報
 * @param user　変更実行ユーザ
 * @return
 * @throws CreateException
 * @throws NotSupportedException
 * @throws RollbackException
 * @throws HeuristicMixedException
 * @throws HeuristicRollbackException
 * @throws SystemException
 * @throws InvalidTransactionException
 * @throws NamingException
 * @throws FinderException
 */
	public boolean modify(SnmpTrapMasterInfo oidData, String user) throws CreateException, NotSupportedException, RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException, InvalidTransactionException, NamingException, FinderException {
		
    	//アクセスロック
    	AccessLock.lock(AccessLock.MONITOR_SNMPTRAP);

    	m_OidData = oidData;
		
		TransactionManager tm = null;
//		Transaction tx = null;
//		Transactionの利用を取りやめたため、関連箇所ふくめコメントアウトした : uchiyama		
		Transaction oldTx = null;
		boolean result = false;
		
		try 
		{
			// TransactionManagerを取得
			InitialContext context = new InitialContext();
			tm = (TransactionManager)context.lookup("java:/TransactionManager");
			
			// 実行中のスレッドがトランザクションに関連付けられている場合は、トランザクションを退避 
			if(tm.getTransaction() != null){
				oldTx = tm.suspend();
			}
			
			try{
				// トランザクション開始
				if(tm.getTransaction() == null){
					tm.begin();	
//					tx = tm.getTransaction();
				}
				
				// 監視情報を登録
				result = modifyOIDMaster(user);
				if(result){
					// コミット
//					tx.commit();
					tm.commit();
				}
			
			} catch(NotSupportedException e){
				outputLog(e, "add()");
				throw e;
			} catch (RollbackException e) {
				outputLog(e, "add()");
				throw e;
			} catch (HeuristicMixedException e) {
				outputLog(e, "add()");
				throw e;
			} catch(HeuristicRollbackException e){
				outputLog(e, "add()");
				throw e;
			} catch(SystemException e){
				outputLog(e, "add()");
				throw e;
			}
			finally{
				// トランザクション関連の例外が発生した場合は、ロールバック
//				if(tx != null){
//					if(!result){
//						tx.rollback();
//					}
//					tx = null;
//				}
				if(tm.getTransaction() != null){
					if(!result){
						tm.rollback();
					}
				}
			}
		}
		finally{
			
			// 一時停止していたトランザクションを再開
			if(oldTx != null){
				try{
					tm.resume(oldTx);
				
				} catch(InvalidTransactionException e){
					outputLog(e, "add()");
					throw e;
				} catch(IllegalStateException e){
					outputLog(e, "add()");
					throw e;
				} catch(SystemException e){
					outputLog(e, "add()");
					throw e;
				}
			}
		}
		return result;
	}

	/**
	 * OIDマスター情報の変更を行う。 
	 * @param user　変更実行ユーザ
	 * 
	 * @return
	 * @throws NamingException
	 * @throws FinderException
	 */
	public boolean modifyOIDMaster(String user) throws NamingException, FinderException {
		boolean result = false;
		
		try 
		{
			Timestamp now = new Timestamp(new Date().getTime());

			
			// 監視情報を検索
			
			SnmpTrapMasterLocal OIDMaster = SnmpTrapMasterUtil.getLocalHome()
			                                    .findByPrimaryKey(new SnmpTrapMasterPK(m_OidData.getMib(),
			                                    									   m_OidData.getTrapOid(),
			                                    									   m_OidData.getGenericId(),
			                                    									   m_OidData.getSpecificId()));
			
			OIDMaster.setUei(m_OidData.getUei());
			OIDMaster.setPriority(m_OidData.getPriority());
			OIDMaster.setLogmsg(m_OidData.getLogmsg());
			OIDMaster.setDescr(m_OidData.getDescr());

			result = true;
			
		} catch (NamingException e) {
			outputLog(e, "addOIDMaster()");
			throw e;
		} 
		return result;
	}
	
	/**
     * アプリケーションログにログを出力
     * 
     * @param e 例外
     */
	private void outputLog(Exception e, String method){
		AplLogger apllog = new AplLogger("TRAP", "trap");
		String[] args = {m_OidData.getMib(), m_OidData.getTrapOid(),Integer.toString(m_OidData.getGenericId()),
				Integer.toString(m_OidData.getSpecificId())};
        apllog.put("SYS", "001", args);
        m_log.debug(method + ":" + e.getMessage());
	}
}
