//
//This file is part of the joeSNMP Java Library.
//
//joeSNMP is Copyright (C) 2002-2003 Blast Internet Services, Inc.  All rights reserved.
//joeSNMP is a derivative work, containing both original code, included code and modified
//code that was published under the GNU Lesser General Public License. Copyrights for modified 
//and included code are below.
//
//Copyright (C) 1999-2001 Oculan Corp. All rights reserved.
//
//This library is free software; you can redistribute it and/or
//modify it under the terms of the GNU Lesser General Public
//License as published by the Free Software Foundation; either
//version 2.1 of the License, or (at your option) any later version.
//
//This library is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//Lesser General Public License for more details.
//
//You should have received a copy of the GNU Lesser General Public
//License along with this library; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//See: http://www.fsf.org/copyleft/lesser.html
//
//For more information contact:
//   joeSNMP Licensing       <joesnmp-license@lists.sourceforge.net>
//   http://sourceforge.net/projects/joesnmp/
//

package org.opennms.examples;

import java.net.InetAddress;

import org.opennms.protocols.snmp.SnmpHandler;
import org.opennms.protocols.snmp.SnmpParameters;
import org.opennms.protocols.snmp.SnmpPduBulk;
import org.opennms.protocols.snmp.SnmpPduPacket;
import org.opennms.protocols.snmp.SnmpPeer;
import org.opennms.protocols.snmp.SnmpSMI;
import org.opennms.protocols.snmp.SnmpSession;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.SnmpVarBind;

public class SnmpBulkRequestExample
{
    public static void main(String st[]) throws Exception
    {
        if (st.length != 2)
        {
            System.out.println("Usage: java SnmpBulkRequestExample host oid...");
            System.exit(0);
        }
        
        InetAddress remote = InetAddress.getByName(st[0]); 
        SnmpPeer peer = new SnmpPeer(remote); 
        peer.setPort(161); 
        peer.setTimeout(5000); 
        peer.setRetries(1); // it is actually number of tries
         
        SnmpParameters parms = peer.getParameters(); 
        parms.setVersion(SnmpSMI.SNMPV2); 
        parms.setReadCommunity("public"); 
                 
        final SnmpSession session = new SnmpSession(peer); 
        session.setDefaultHandler(new SnmpHandler()
        {        
            public void snmpTimeoutError(SnmpSession session, SnmpSyntax pdu)
            {
                System.out.println("SnmpTimeout");
                synchronized (session) { session.notify(); }
            }
        
            public void snmpInternalError(SnmpSession session, int err, SnmpSyntax pdu)
            {
                System.out.println("InternalError");
                synchronized (session) { session.notify(); }
            }
        
            public void snmpReceivedPdu(SnmpSession session, int command, SnmpPduPacket pdu)
            {
                int responseLength = pdu.getLength();
                for (int i = 0; i < responseLength; i++)
                {
                    SnmpVarBind varBind = pdu.getVarBindAt(i);
                    System.out.println("Received value: " + varBind.getName() + "=" + varBind.getValue());
                }
                
                synchronized (session) { session.notify(); }
            }        
        });
        
        SnmpVarBind[] vblist = new SnmpVarBind[st.length - 1];
        for (int i = 1; i < st.length ; i++)
            vblist[i - 1] = new SnmpVarBind(st[i]);
        
        int nonRepeaters = 0;
        int maxRepitition = 100; // Change this to get a bigger/smaller result set
        SnmpPduPacket requestPDU = new SnmpPduBulk(nonRepeaters, maxRepitition, vblist);
        requestPDU.setRequestId(1);
        
        try
        {
            synchronized (session)
            {
                session.send(requestPDU);
                session.wait();
            }
        }
        catch (InterruptedException e)
        {
            // do nothing
        }
        finally
        {
            session.close();
        }
    }
}
