/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.vm;

import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import org.postgresforest.Driver;
import org.postgresforest.core.PGStream;
import org.postgresforest.jdbc3.AbstractJdbc3Connection;
import org.postgresforest.jdbc3.Jdbc3Connection;
import org.postgresforest.jdbc3.Jdbc3DatabaseMetaData;
import org.postgresforest.util.PSQLException;
import org.postgresforest.util.PSQLState;
import org.postgresforest.vm.ForestSQLState;
import org.postgresforest.vm.GSCdata;
import org.postgresforest.vm.GscMetaData;
import org.postgresforest.vm.LogUtil;
import org.postgresforest.vm.StatementThreadMng;

public abstract class AbstractForestConnection
extends AbstractJdbc3Connection {
    public GSCdata m_gsc;
    public StatementThreadMng m_threadMng;
    protected LinkedList m_execSeq = new LinkedList();
    protected LogUtil m_logUtil;
    protected boolean m_rollback = false;
    protected SQLException m_rollbackException;
    protected static Timer m_closeTimer = new Timer(true);
    protected int isolationLevel = 2;
    protected boolean transactionOpened = false;

    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.metadata == null) {
            this.metadata = new Jdbc3DatabaseMetaData((Jdbc3Connection)this.m_gsc.getDistServer());
        }
        return this.metadata;
    }

    public void close() throws SQLException {
        PGStream pg_stream = this.getPGStream();
        if (pg_stream != null) {
            super.close();
        } else if (this.m_gsc != null && !this.isClosed()) {
            this.m_gsc.setClosed(true);
            m_closeTimer.schedule((TimerTask)new CloseTask(), 0L);
        }
    }

    public void closeGD() throws SQLException {
        super.close();
    }

    public Statement createStatement() throws SQLException {
        Statement smt = super.createStatement();
        if (this.m_gsc != null) {
            smt.setQueryTimeout(this.m_gsc.getTimeout());
        }
        return smt;
    }

    public void setAutoCommit(boolean autoCommit, boolean syncronize) throws SQLException {
        this.setUpdateSyncMode(syncronize);
        this.setAutoCommit(autoCommit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.m_threadMng.waitFree();
        if (this.autoCommit == autoCommit) {
            return;
        }
        ArrayList conList = this.m_gsc.getDistServerList();
        for (int i = 0; i < conList.size(); ++i) {
            ((AbstractForestConnection)conList.get((int)i)).autoCommit = autoCommit;
        }
        boolean orgSync = this.getUpdateSyncMode();
        this.setUpdateSyncMode(false);
        try {
            Statement smt = this.createStatement();
            if (autoCommit) {
                this.commit();
            }
            smt.close();
        }
        finally {
            this.setUpdateSyncMode(orgSync);
        }
        this.autoCommit = autoCommit;
    }

    protected void _setAutoCommit(boolean autoCommit) throws SQLException {
        if (Driver.logInfo) {
            this.m_logUtil.info("SET AUTO COMMIT:value=" + autoCommit + ": Execute Connection = " + this.getURL());
        }
        super.setAutoCommit(autoCommit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws SQLException {
        this.m_threadMng.waitFree();
        this.chkRollBack();
        boolean canBegin = this.m_gsc.isTableAvailable() & this.autoCommit;
        if (this.autoCommit) {
            return;
        }
        boolean orgSync = this.getUpdateSyncMode();
        this.setUpdateSyncMode(false);
        try {
            Statement smt = this.createStatement();
            smt.execute("commit");
            this.transactionOpened = false;
            smt.close();
        }
        finally {
            this.m_threadMng.waitFree();
            this.setUpdateSyncMode(orgSync);
        }
    }

    protected void begin() throws PSQLException, SQLException {
        while (!this.m_gsc.isTableAvailable()) {
            try {
                if (Driver.logInfo) {
                    this.m_logUtil.info("Sleeping 3 secs before retrying...");
                }
                Thread.sleep(3000L);
            }
            catch (Exception ex) {
                throw new PSQLException("postgresql.forest.execute.internal", (PSQLState)ForestSQLState.INTERNAL_ERROR, (Object)ex);
            }
        }
        if (this.autoCommit) {
            return;
        }
        Statement smt = this.createStatement();
        if (this.haveMinimumServerVersion("7.1")) {
            smt.execute("BEGIN;" + this.getIsolationLevelSQL());
            this.transactionOpened = true;
        } else {
            smt.execute("BEGIN");
            smt.execute(this.getIsolationLevelSQL());
            this.transactionOpened = true;
        }
        smt.close();
    }

    protected void chkRollBack() throws SQLException {
        if (this.isRollback()) {
            try {
                this.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw this.m_rollbackException;
        }
    }

    protected void _commit() throws SQLException {
        if (Driver.logInfo) {
            this.m_logUtil.info("COMMIT: Execute Connection = " + this.getURL());
        }
        super.commit();
    }

    protected void commitOnly() throws SQLException {
        if (Driver.logInfo) {
            this.m_logUtil.info("COMMIT: Execute Connection = " + this.getURL());
        }
        if (this.autoCommit) {
            return;
        }
        this.execSQL("commit;");
    }

    protected void _begin() throws SQLException {
        if (Driver.logInfo) {
            this.m_logUtil.info("BEGIN: Execute Connection = " + this.getURL());
        }
        if (this.autoCommit) {
            return;
        }
        if (this.haveMinimumServerVersion("7.1")) {
            this.execSQL("begin;" + this.getIsolationLevelSQL());
        } else {
            this.execSQL("begin");
            this.execSQL(this.getIsolationLevelSQL());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws SQLException {
        this.m_threadMng.waitFree();
        this.clearRollback();
        boolean canBegin = this.m_gsc.isTableAvailable() & this.autoCommit;
        if (this.autoCommit) {
            return;
        }
        boolean orgSync = this.getUpdateSyncMode();
        this.setUpdateSyncMode(false);
        try {
            Statement smt = this.createStatement();
            smt.execute("rollback");
            this.transactionOpened = false;
            smt.close();
        }
        finally {
            this.m_threadMng.waitFree();
            this.setUpdateSyncMode(orgSync);
        }
    }

    protected void rollbackOnly() throws SQLException {
        if (Driver.logInfo) {
            this.m_logUtil.info("ROLLBACK: Execute Connection = " + this.getURL());
        }
        if (this.autoCommit) {
            return;
        }
        this.execSQL("rollback;");
    }

    protected void _rollback() throws SQLException {
        if (Driver.logInfo) {
            this.m_logUtil.info("ROLLBACK: Execute Connection = " + this.getURL());
        }
        super.rollback();
    }

    public boolean isClosed() throws SQLException {
        if (this.m_gsc == null) {
            return super.isClosed();
        }
        return this.m_gsc.isClosed();
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement smt = super.prepareStatement(sql);
        if (this.m_gsc != null) {
            smt.setQueryTimeout(this.m_gsc.getTimeout());
        }
        return smt;
    }

    public boolean haveMinimumServerVersion(String ver) throws SQLException {
        if (this.m_gsc != null) {
            AbstractForestConnection conn = (AbstractForestConnection)((Object)this.m_gsc.getDistServer());
            return conn.haveMinimumServerVersion(ver);
        }
        return super.haveMinimumServerVersion(ver);
    }

    public boolean haveMinimumCompatibleVersion(String ver) throws SQLException {
        if (this.m_gsc != null) {
            AbstractForestConnection conn = (AbstractForestConnection)((Object)this.m_gsc.getDistServer());
            return conn.haveMinimumCompatibleVersion(ver);
        }
        return super.haveMinimumCompatibleVersion(ver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExecSeq(Object obj) {
        LinkedList linkedList = this.m_execSeq;
        synchronized (linkedList) {
            this.m_execSeq.addLast(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endExecSeq(Object obj) {
        LinkedList linkedList = this.m_execSeq;
        synchronized (linkedList) {
            try {
                Object executing = this.m_execSeq.getFirst();
                if (obj.equals(executing)) {
                    this.m_execSeq.removeFirst();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_execSeq.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitExecSeq(Object obj) {
        LinkedList linkedList = this.m_execSeq;
        synchronized (linkedList) {
            while (this.m_execSeq.size() != 0 && !obj.equals(this.m_execSeq.getFirst())) {
                if (Driver.forestTestLog) {
                    try {
                        System.out.println(((Thread)obj).getName() + ":CON_SEQ_WAIT:" + this.getURL());
                    }
                    catch (SQLException e1) {
                        // empty catch block
                    }
                }
                try {
                    this.m_execSeq.notify();
                    this.m_execSeq.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public LogUtil getLogUtil() {
        return this.m_logUtil;
    }

    public void setLogUtil(LogUtil util) {
        this.m_logUtil = util;
    }

    public boolean getUpdateSyncMode() {
        return this.m_gsc.getUpdateSyncMode();
    }

    public void setUpdateSyncMode(boolean b) {
        this.m_gsc.setUpdateSyncMode(b);
    }

    public int getTransactionIsolation() throws SQLException {
        return ((AbstractForestConnection)((Object)this.m_gsc.getDistServer()))._getTransactionIsolation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransactionIsolation(int level) throws SQLException {
        this.m_threadMng.waitFree();
        boolean orgSync = this.getUpdateSyncMode();
        this.setUpdateSyncMode(false);
        try {
            String isolationLevelSQL;
            this.isolationLevel = level;
            if (!this.haveMinimumServerVersion("7.1")) {
                isolationLevelSQL = this.getIsolationLevelSQL();
            } else {
                isolationLevelSQL = "SET SESSION CHARACTERISTICS AS TRANSACTION ISOLATION LEVEL ";
                switch (this.isolationLevel) {
                    case 2: {
                        isolationLevelSQL = isolationLevelSQL + "READ COMMITTED";
                        break;
                    }
                    case 8: {
                        isolationLevelSQL = isolationLevelSQL + "SERIALIZABLE";
                        break;
                    }
                    default: {
                        throw new PSQLException("postgresql.con.isolevel", PSQLState.TRANSACTION_STATE_INVALID, new Integer(this.isolationLevel));
                    }
                }
            }
            this.createStatement().execute(isolationLevelSQL);
        }
        finally {
            this.m_threadMng.waitFree();
            this.setUpdateSyncMode(orgSync);
        }
    }

    protected int _getTransactionIsolation() throws SQLException {
        return super.getTransactionIsolation();
    }

    protected void _setTransactionIsolation(int level) throws SQLException {
        super.setTransactionIsolation(level);
    }

    public GscMetaData getGscMetaData() {
        return new GscMetaData(this.m_gsc);
    }

    public synchronized boolean isRollback() {
        return this.m_rollback;
    }

    public synchronized void setRollback(SQLException ex) {
        if (ex != null) {
            this.m_rollback = true;
            this.m_rollbackException = new PSQLException("postgresql.forest.execute.rollback", (PSQLState)ForestSQLState.INTERNAL_ERROR, (Object)ex);
        }
    }

    public synchronized void clearRollback() {
        this.m_rollback = false;
    }

    protected boolean isTransactionOpened() {
        return this.transactionOpened;
    }

    protected class CloseTask
    extends TimerTask {
        protected CloseTask() {
        }

        public void run() {
            AbstractForestConnection.this.m_threadMng.terminate();
            AbstractForestConnection.this.m_gsc.close();
        }
    }
}

