/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.vm;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.postgresforest.Driver;
import org.postgresforest.util.PSQLException;
import org.postgresforest.vm.AbstractForestConnection;
import org.postgresforest.vm.AbstractForestThread;
import org.postgresforest.vm.ForestSQLState;
import org.postgresforest.vm.GSCdata;
import org.postgresforest.vm.Lock;
import org.postgresforest.vm.QueryInfo;
import org.postgresforest.vm.ReWriter;
import org.postgresforest.vm.StatementExecuteSub;
import org.postgresforest.vm.StatementThreadMng;

public class StatementSub
extends AbstractForestThread {
    public static final int STAT_OK = 0;
    public static final int STAT_NG = -1;
    protected Statement m_mst;
    protected AbstractForestConnection m_con;
    protected String[] m_sqlFragments;
    public ResultSet m_res = null;
    protected QueryInfo m_qi;
    protected GSCdata m_gsc;
    protected ReWriter m_rw;
    public SQLException m_stesql;
    public int m_nErrCode = 0;
    public int m_retry = 0;
    protected StatementThreadMng m_threadMng;
    protected boolean m_selfClose;
    protected boolean m_serverBrokenChk;
    StatementExecuteSub m_ses;
    protected Lock m_lock;
    static int id = 0;

    public StatementSub(StatementThreadMng mng) {
        super(mng.getLogUtil());
        this.m_ses = new StatementExecuteSub(mng.getLogUtil());
        if (Driver.logInfo) {
            this.setName("StmSub" + id++);
            this.m_ses.setName(this.getName() + "SES_thread");
        }
        this.m_threadMng = mng;
    }

    public void execute(Statement srcst, QueryInfo srcQueryInfo, GSCdata srcGSCdata, ReWriter srcRewriter) {
        this.m_mst = srcst;
        this.m_qi = srcQueryInfo;
        this.m_con = (AbstractForestConnection)((Object)this.m_qi.getConnection());
        this.m_sqlFragments = new String[1];
        this.m_sqlFragments[0] = this.m_qi.getSql();
        this.m_gsc = srcGSCdata;
        this.m_rw = srcRewriter;
        this.m_retry = this.m_gsc.getRetry();
        this.m_con.setExecSeq(this);
        this.execute();
    }

    public void execute(Statement srcst, QueryInfo srcQueryInfo, GSCdata srcGSCdata, ReWriter srcRewriter, Lock lock) {
        this.waitExecute();
        this.m_lock = lock;
        this.execute(srcst, srcQueryInfo, srcGSCdata, srcRewriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void _execute() {
        boolean flg = true;
        this.m_nErrCode = 0;
        int retryCount = 0;
        try {
            while (flg) {
                flg = false;
                this.m_con.waitExecSeq(this);
                if (Driver.forestTestLog) {
                    System.out.println("SQL:" + this.m_sqlFragments[0] + "\nURL:" + this.m_con.getURL() + '\n');
                }
                if (Driver.logInfo) {
                    this.m_logUtil.info(this.getName() + ": Execute Query = " + this.m_sqlFragments[0]);
                    this.m_logUtil.info(this.getName() + ": Execute Connection = " + this.m_con.getURL());
                }
                try {
                    this.m_ses.execute(this.m_con, this.m_sqlFragments, new Object[0], this);
                    StatementSub statementSub = this;
                    synchronized (statementSub) {
                        if (this.m_mst.getQueryTimeout() != 0) {
                            if (Driver.logInfo) {
                                this.m_logUtil.info(this.getName() + ": The timer surveillance thread was started.");
                            }
                            this.wait(this.m_mst.getQueryTimeout() * 1000);
                        } else {
                            this.wait();
                        }
                    }
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                int sesStatus = this.m_ses.getErrCode();
                if (sesStatus == -3) {
                    if (Driver.logInfo) {
                        this.m_logUtil.info(this.getName() + ": The timeout occurred in execution of a query.");
                    }
                    this.m_gsc.setServerBroken((Connection)((Object)this.m_con), this.m_sqlFragments[0], new PSQLException("postgresql.forest.execute.timeout", ForestSQLState.INTERNAL_ERROR));
                    this.m_ses.terminate();
                    if (Driver.logInfo) {
                        this.m_logUtil.info(this.getName() + ": The query execution thread was stopped.");
                    }
                    this.m_ses = new StatementExecuteSub(this.m_logUtil);
                    this.m_ses.setName(this.getName() + this.getName() + "SES_thread" + (retryCount + 1));
                    if (this.m_rw.getQueryType() == 2) {
                        if (Driver.logInfo) {
                            this.m_logUtil.info(this.getName() + ": Execution of a query is not re-tried for parallel processing.");
                        }
                        flg = false;
                        this.m_stesql = new PSQLException("postgresql.forest.execute.timeout", ForestSQLState.INTERNAL_ERROR);
                        this.m_nErrCode = -1;
                        continue;
                    }
                    if (this.m_retry <= retryCount) {
                        if (Driver.logInfo) {
                            this.m_logUtil.info(this.getName() + ": Since the number of times of re-trial was exceeded, it is made an error, without re-trying.");
                        }
                        flg = false;
                        this.m_stesql = new PSQLException("postgresql.forest.execute.retryover", ForestSQLState.INTERNAL_ERROR);
                        this.m_nErrCode = -1;
                        continue;
                    }
                    if (Driver.logInfo) {
                        this.m_logUtil.info(this.getName() + ": Execution of a query is re-tried.");
                    }
                    this.m_con.endExecSeq(this);
                    this.m_con = (AbstractForestConnection)((Object)this.m_rw.getRetryConnection(this.m_qi));
                    this.m_con.setExecSeq(this);
                    flg = true;
                    ++retryCount;
                    continue;
                }
                if (sesStatus == 0) {
                    if (Driver.logInfo) {
                        this.m_logUtil.info(this.getName() + ": Execution of a query was ended normally.");
                    }
                    flg = false;
                    continue;
                }
                if (sesStatus == -1 || sesStatus == -4 && this.m_con.getAutoCommit()) {
                    if (Driver.logInfo) {
                        this.m_logUtil.info(this.getName() + ": The error for server separation occurred.");
                    }
                    this.m_gsc.setServerBroken((Connection)((Object)this.m_con), this.m_sqlFragments[0], this.m_ses.getErrobj());
                    if (this.m_rw.getQueryType() == 2) {
                        if (Driver.logInfo) {
                            this.m_logUtil.info(this.getName() + ": Execution of a query is not re-tried for parallel processing.");
                        }
                        this.m_stesql = this.m_ses.getErrobj();
                        this.m_nErrCode = -1;
                        flg = false;
                        continue;
                    }
                    if (this.m_retry <= retryCount) {
                        if (Driver.logInfo) {
                            this.m_logUtil.info(this.getName() + ": Since the number of times of re-trial was exceeded, it is made an error, without re-trying.");
                        }
                        this.m_stesql = new PSQLException("postgresql.forest.execute.retryover", ForestSQLState.INTERNAL_ERROR);
                        this.m_nErrCode = -1;
                        flg = false;
                        continue;
                    }
                    if (Driver.logInfo) {
                        this.m_logUtil.info(this.getName() + ": Execution of a query is re-tried.");
                    }
                    this.m_con.endExecSeq(this);
                    this.m_con = (AbstractForestConnection)((Object)this.m_rw.getRetryConnection(this.m_qi));
                    this.m_con.setExecSeq(this);
                    flg = true;
                    ++retryCount;
                    continue;
                }
                if (sesStatus == -2) {
                    if (Driver.logInfo) {
                        this.m_logUtil.info(this.getName() + ": The error which is not a candidate for server separation occurred.");
                    }
                    flg = false;
                    this.m_stesql = this.m_ses.getErrobj();
                    this.m_nErrCode = -1;
                    continue;
                }
                if (sesStatus != -4) continue;
                if (Driver.logInfo) {
                    this.m_logUtil.info(this.getName() + ": Rollback object error generation.");
                }
                flg = false;
                this.m_stesql = this.m_ses.getErrobj();
                this.m_nErrCode = -1;
                AbstractForestConnection con = (AbstractForestConnection)((Object)this.m_mst.getConnection());
                con.setRollback(this.m_stesql);
            }
        }
        catch (SQLException esql) {
            this.m_stesql = esql;
            this.m_nErrCode = -1;
        }
        finally {
            this.m_con.endExecSeq(this);
            this.m_lock.notifyEnd();
        }
        if (Driver.logDebug) {
            this.m_logUtil.debug(this.getName() + ": _execute() End");
        }
    }

    public void terminate() {
        if (Driver.logDebug) {
            this.m_logUtil.debug(this.getName() + ": terminate() In");
        }
        this.m_ses.terminate();
        super.terminate();
        if (Driver.logDebug) {
            this.m_logUtil.debug(this.getName() + ": terminate() Out");
        }
    }

    public void setSelfClose(boolean b) {
        this.m_selfClose = b;
    }

    public void close() {
        if (Driver.logDebug) {
            this.m_logUtil.debug(this.getName() + ": The separation check of a server is started.");
        }
        boolean brokenChk = this.isServerBrokenChk();
        this.setServerBrokenChk(false);
        if (brokenChk && this.m_rw.getQueryType() == 2 && this.m_nErrCode == -1) {
            try {
                AbstractForestConnection con = (AbstractForestConnection)((Object)this.m_mst.getConnection());
                if (con.isRollback()) {
                    return;
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            if (Driver.logInfo) {
                this.m_logUtil.info(this.getName() + ": There is a server for separation.");
            }
            try {
                this.m_gsc.setServerBroken((Connection)((Object)this.m_con), this.m_sqlFragments[0], this.m_ses.getErrobj());
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (Driver.logDebug) {
            this.m_logUtil.debug(this.getName() + ": The separation check of a server is ended.");
        }
    }

    public void setServerBrokenChk(boolean b) {
        this.m_serverBrokenChk = b;
    }

    public boolean isServerBrokenChk() {
        return this.m_serverBrokenChk;
    }

    protected void standby() {
        super.standby();
        if (this.m_selfClose) {
            this.m_threadMng.closeStatementSub(this);
        }
        this.m_selfClose = false;
    }
}

