/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.plugin;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.jboss.jms.server.plugin.contract.JMSUserManager;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.impl.JDBCSupport;

public class JDBCJMSUserManager
extends JDBCSupport
implements JMSUserManager {
    private static final Logger log = Logger.getLogger(JDBCJMSUserManager.class);

    public JDBCJMSUserManager(DataSource ds, TransactionManager tm, Properties sqlProperties, boolean createTablesOnStartup) {
        super(ds, tm, sqlProperties, createTablesOnStartup);
    }

    protected Map getDefaultDMLStatements() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("SELECT_PRECONF_CLIENTID", "SELECT CLIENTID FROM JBM_USER WHERE USER_ID=?");
        return map;
    }

    protected Map getDefaultDDLStatements() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("CREATE_USER_TABLE", "CREATE TABLE JBM_USER (USER_ID VARCHAR(32) NOT NULL, PASSWD VARCHAR(32) NOT NULL, CLIENTID VARCHAR(128), PRIMARY KEY(USER_ID))");
        map.put("CREATE_ROLE_TABLE", "CREATE TABLE JBM_ROLE (ROLE_ID VARCHAR(32) NOT NULL, USER_ID VARCHAR(32) NOT NULL, PRIMARY KEY(USER_ID, ROLE_ID))");
        return map;
    }

    protected boolean ignoreVerificationOnStartup(String statementName) {
        return statementName.startsWith("POPULATE.TABLES.");
    }

    public void start() throws Exception {
        super.start();
        this.insertUserRoleData();
    }

    public void stop() throws Exception {
        super.stop();
    }

    public String getPreConfiguredClientID(String username) throws Exception {
        String string;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        JDBCSupport.TransactionWrapper wrap = new JDBCSupport.TransactionWrapper(this);
        try {
            conn = this.ds.getConnection();
            ps = conn.prepareStatement(this.getSQLStatement("SELECT_PRECONF_CLIENTID"));
            ps.setString(1, username);
            rs = ps.executeQuery();
            String clientID = null;
            if (rs.next()) {
                clientID = rs.getString(1);
            }
            string = clientID;
        }
        catch (SQLException e) {
            try {
                wrap.exceptionOccurred();
                throw e;
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(ps);
                this.closeConnection(conn);
                wrap.end();
                throw throwable;
            }
        }
        this.closeResultSet(rs);
        this.closeStatement(ps);
        this.closeConnection(conn);
        wrap.end();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertUserRoleData() throws Exception {
        ArrayList<Object> populateTables = new ArrayList<Object>();
        for (Map.Entry<Object, Object> entry : this.sqlProperties.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith("POPULATE.TABLES.")) continue;
            populateTables.add(entry.getValue());
        }
        if (!populateTables.isEmpty()) {
            for (String string : populateTables) {
                Statement st = null;
                Connection conn = null;
                JDBCSupport.TransactionWrapper tx = null;
                try {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Executing: " + string));
                    }
                    tx = new JDBCSupport.TransactionWrapper(this);
                    conn = this.ds.getConnection();
                    st = conn.createStatement();
                    st.executeUpdate(string);
                }
                catch (Exception e) {
                    try {
                        log.debug((Object)("Failed to execute " + string), (Throwable)e);
                        tx.exceptionOccurred();
                    }
                    catch (Throwable throwable) {
                        this.closeStatement(st);
                        this.closeConnection(conn);
                        tx.end();
                        throw throwable;
                    }
                    this.closeStatement(st);
                    this.closeConnection(conn);
                    tx.end();
                    continue;
                }
                this.closeStatement(st);
                this.closeConnection(conn);
                tx.end();
            }
        }
    }
}

