/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import java.util.ArrayList;
import org.jboss.aop.Advisor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.joinpoint.Joinpoint;

public class AdviceStack {
    protected String name;
    protected ArrayList interceptorFactories;

    public AdviceStack(String name, ArrayList factories) {
        this.name = name;
        this.interceptorFactories = factories;
    }

    public String getName() {
        return this.name;
    }

    public ArrayList getInterceptorFactories() {
        return this.interceptorFactories;
    }

    public Interceptor[] createInterceptors(Advisor advisor, Joinpoint jp) {
        ArrayList<Interceptor> interceptors = new ArrayList<Interceptor>();
        for (int i = 0; i < this.interceptorFactories.size(); ++i) {
            InterceptorFactory factory = (InterceptorFactory)this.interceptorFactories.get(i);
            if (!factory.isDeployed()) continue;
            interceptors.add(factory.create(advisor, jp));
        }
        return interceptors.toArray(new Interceptor[interceptors.size()]);
    }

    public Interceptor[] createInterceptors() {
        return this.createInterceptors(null, null);
    }
}

