/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMQualifiableElement;
import org.sblim.wbem.cim.CIMQualifier;
import org.sblim.wbem.cim.CIMValue;

public class CIMArgument
extends CIMQualifiableElement
implements Cloneable {
    private static final long serialVersionUID = 828496901160110115L;
    private CIMValue iValue;
    private CIMDataType iType;

    public CIMArgument() {
    }

    public CIMArgument(String pName) {
        super(pName);
    }

    public CIMArgument(String pName, CIMValue pValue) {
        super(pName);
        this.iValue = pValue;
        this.iType = pValue != null ? pValue.getType() : null;
    }

    public CIMArgument(String pName, CIMDataType pDataType) {
        super(pName);
        this.iValue = null;
        if (pDataType == null) {
            throw new IllegalArgumentException("Illegal argument - data type must not be null");
        }
        this.iType = pDataType;
    }

    public Object clone() {
        return this.clone(true);
    }

    public Object clone(boolean pIncludeQualifier) {
        CIMArgument clone = new CIMArgument(this.iName);
        clone.iType = (CIMDataType)this.iType.clone();
        clone.iValue = (CIMValue)this.iValue.clone();
        if (pIncludeQualifier) {
            for (int i = 0; i < this.iQualifiers.size(); ++i) {
                clone.iQualifiers.add(((CIMQualifier)this.iQualifiers.elementAt(i)).clone());
            }
        }
        return clone;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CIMArgument)) {
            return false;
        }
        CIMArgument that = (CIMArgument)o;
        if (!this.iQualifiers.equals(that.iQualifiers)) {
            return false;
        }
        if (!(this.iType == null && that.iType == null || this.iType != null && this.iType.equals(that.iType))) {
            return false;
        }
        if (!(this.iValue == null && that.iValue == null || this.iValue != null && this.iValue.equals(that.iValue))) {
            return false;
        }
        return this.iName.equalsIgnoreCase(that.iName);
    }

    public int hashCode() {
        return this.iQualifiers.hashCode() + (this.iType != null ? this.iType.hashCode() : 0) + (this.iValue != null ? this.iValue.hashCode() : 0) + this.iName.hashCode();
    }

    public CIMValue getValue() {
        return this.iValue;
    }

    public CIMDataType getType() {
        return this.iType;
    }

    public void setType(CIMDataType pType) {
        if (this.iValue == null) {
            this.iType = pType;
        } else if (this.iValue.getType() != null && this.iValue.getType().getType() != pType.getType()) {
            throw new IllegalArgumentException("Specified data type does not match data type of argument value");
        }
    }

    public void setValue(CIMValue pValue) {
        if (this.iType != null && pValue != null && pValue.getType().getType() != this.iType.getType()) {
            throw new IllegalArgumentException("value type does not match property type");
        }
        this.iValue = pValue;
        if (this.iType == null && pValue != null) {
            this.iType = pValue.getType();
        }
    }

    public String toString() {
        return "CIMArgument(name=" + this.iName + ", value=" + this.iValue + ")";
    }
}

