/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.io.Serializable;
import org.sblim.wbem.cim.UnsignedInt16;
import org.sblim.wbem.cim.UnsignedInt8;

public class UnsignedInt32
extends Number
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -9063069511184239822L;
    public static long MIN_VALUE = 0L;
    public static long MAX_VALUE = 0xFFFFFFFFL;
    private long iValue;

    public UnsignedInt32(byte pValue) {
        if ((long)pValue < MIN_VALUE || (long)pValue > MAX_VALUE) {
            throw new IllegalArgumentException("Invalid value range. Value must be in a " + MIN_VALUE + ".." + MAX_VALUE + " range");
        }
        this.iValue = pValue;
    }

    public UnsignedInt32(short pValue) {
        if ((long)pValue < MIN_VALUE || (long)pValue > MAX_VALUE) {
            throw new IllegalArgumentException("Invalid value range. Value must be in a " + MIN_VALUE + ".." + MAX_VALUE + " range");
        }
        this.iValue = pValue;
    }

    public UnsignedInt32(int pValue) {
        if ((long)pValue < MIN_VALUE || (long)pValue > MAX_VALUE) {
            throw new IllegalArgumentException("Invalid value range. Value must be in a " + MIN_VALUE + ".." + MAX_VALUE + " range");
        }
        this.iValue = pValue;
    }

    public UnsignedInt32(long pValue) {
        if (pValue < MIN_VALUE || pValue > MAX_VALUE) {
            throw new IllegalArgumentException("Invalid value range. Value must be in a " + MIN_VALUE + ".." + MAX_VALUE + " range");
        }
        this.iValue = pValue;
    }

    public UnsignedInt32(String pValue) {
        if (pValue == null) {
            throw new IllegalArgumentException("null string argument");
        }
        if (pValue.trim().length() == 0) {
            throw new IllegalArgumentException("empty string argument");
        }
        this.iValue = Long.parseLong(pValue);
        if (this.iValue < MIN_VALUE || this.iValue > MAX_VALUE) {
            throw new IllegalArgumentException("Invalid value range. Value must be in a " + MIN_VALUE + ".." + MAX_VALUE + " range");
        }
    }

    public UnsignedInt32(UnsignedInt8 pValue) {
        this.iValue = pValue.longValue();
    }

    public UnsignedInt32(UnsignedInt16 pValue) {
        this.iValue = pValue.longValue();
    }

    public UnsignedInt32(UnsignedInt32 pValue) {
        this.iValue = pValue.longValue();
    }

    public String toString() {
        return Long.toString(this.iValue);
    }

    public boolean equals(Object o) {
        if (o instanceof UnsignedInt32) {
            return this.iValue == ((UnsignedInt32)o).iValue;
        }
        return false;
    }

    public byte byteValue() {
        if (this.iValue < -128L || this.iValue > 127L) {
            throw new NumberFormatException("Value range exceeded. The value " + this.iValue + " is not in the range of a Byte value which is inbetween " + -128 + " .. " + 127);
        }
        return (byte)this.iValue;
    }

    public short shortValue() {
        if (this.iValue < -32768L || this.iValue > 32767L) {
            throw new NumberFormatException("Value range exceeded. The value " + this.iValue + " is not in the range of a Short value which is inbetween " + Short.MIN_VALUE + " .. " + Short.MAX_VALUE);
        }
        return (short)this.iValue;
    }

    public int intValue() {
        if (this.iValue < Integer.MIN_VALUE || this.iValue > Integer.MAX_VALUE) {
            throw new NumberFormatException("Value range exceeded. The value " + this.iValue + " is not in the range of a Integer value which is inbetween " + Integer.MIN_VALUE + " .. " + Integer.MAX_VALUE);
        }
        return (int)this.iValue;
    }

    public long longValue() {
        return this.iValue;
    }

    public float floatValue() {
        return this.iValue;
    }

    public double doubleValue() {
        return this.iValue;
    }

    public int hashCode() {
        return new Long(this.iValue).hashCode();
    }

    public Object clone() {
        return new UnsignedInt32(this.iValue);
    }
}

