/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.io.Serializable;

public class UnsignedInt8
extends Number
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 5547591341269280086L;
    public static short MIN_VALUE = 0;
    public static short MAX_VALUE = (short)255;
    private short iValue;

    public UnsignedInt8(byte pValue) {
        if (pValue < MIN_VALUE || pValue > MAX_VALUE) {
            throw new IllegalArgumentException("Invalid value range. Value must be in a " + MIN_VALUE + ".." + MAX_VALUE + " range");
        }
        this.iValue = pValue;
    }

    public UnsignedInt8(short pValue) {
        if (pValue < MIN_VALUE || pValue > MAX_VALUE) {
            throw new IllegalArgumentException("Invalid value range. Value must be in a " + MIN_VALUE + ".." + MAX_VALUE + " range");
        }
        this.iValue = pValue;
    }

    public UnsignedInt8(String pValue) {
        if (pValue == null) {
            throw new IllegalArgumentException("null string argument");
        }
        if (pValue.trim().length() == 0) {
            throw new IllegalArgumentException("empty string argument");
        }
        this.iValue = Short.parseShort(pValue);
        if (this.iValue < MIN_VALUE || this.iValue > MAX_VALUE) {
            throw new IllegalArgumentException("Invalid value range. Value must be in a " + MIN_VALUE + ".." + MAX_VALUE + " range");
        }
    }

    public UnsignedInt8(UnsignedInt8 pValue) {
        this.iValue = pValue.shortValue();
    }

    public String toString() {
        return Short.toString(this.iValue);
    }

    public boolean equals(Object o) {
        if (o instanceof UnsignedInt8) {
            return this.iValue == ((UnsignedInt8)o).iValue;
        }
        return false;
    }

    public byte byteValue() {
        if (this.iValue < -128 || this.iValue > 127) {
            throw new NumberFormatException("Value range exceeded. The value " + this.iValue + " is not in the range of a Byte value which is inbetween " + -128 + " .. " + 127);
        }
        return Byte.parseByte(Short.toString(this.iValue));
    }

    public short shortValue() {
        return this.iValue;
    }

    public int intValue() {
        return this.iValue;
    }

    public long longValue() {
        return this.iValue;
    }

    public float floatValue() {
        return this.iValue;
    }

    public double doubleValue() {
        return this.iValue;
    }

    public int hashCode() {
        return new Short(this.iValue).hashCode();
    }

    public Object clone() {
        return new UnsignedInt8(this.iValue);
    }
}

